/*
 * Decompiled with CFR 0.152.
 */
package SOMA.agent.mobility;

import SOMA.Environment;
import SOMA.agent.Agent;
import SOMA.agent.AgentWorker;
import SOMA.agent.mobility.AgentPacket;
import SOMA.naming.AgentID;
import SOMA.naming.PlaceID;
import SOMA.network.connection.Command;

public class AgentTransportCommand
extends Command {
    private final AgentPacket agentPacket;
    private final PlaceID destination;

    public AgentTransportCommand(Environment environment, Agent agent, PlaceID placeID) {
        this.agentPacket = environment.agentManager.packAgent(agent);
        this.destination = placeID;
    }

    public void run() {
        AgentID agentID = null;
        try {
            Agent agent = this.agentPacket.getAgent(this.env);
            AgentWorker agentWorker = this.env.agentManager.createWorker(agent);
            if (this.env.mobilePlaceManager != null && this.env.mobilePlaceManager.checkWaitCondition(this.destination)) {
                this.env.mobilePlaceManager.addWaitingAgent(agent.getID(), this.destination);
            } else {
                agentWorker.start();
            }
            agentID = agent.getID();
        }
        catch (Exception exception) {
            exception.printStackTrace(this.env.err);
        }
        if (agentID == null) {
            this.env.out.println("AgentTransportCommand: CANNOT START " + this.agentPacket);
            this.env.agentManager.agentDeath(this.agentPacket.getAgentID());
        }
    }

    public boolean startOnError() {
        return true;
    }

    public String toString() {
        return "[AgentTransportCommand " + this.agentPacket + "]";
    }
}

