/*
 * Decompiled with CFR 0.152.
 */
package SOMA.agent;

import SOMA.Environment;
import SOMA.agent.Agent;
import SOMA.agent.CantGoException;
import SOMA.agent.mobility.AgentTransportCommand;
import SOMA.agent.mobility.AgentWorkerStore;
import SOMA.naming.PlaceID;
import SOMA.network.connection.Daemon;
import SOMA.network.connection.Status;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class AgentWorker
implements Runnable,
Daemon {
    public final Agent agent;
    ThreadGroup agentThreadGroup = null;
    Thread agentThread = null;
    Object status = Daemon.OFF;
    public static final Object IDLE = new Status("IDLE");
    public static final Object GONE = new Status("GONE");
    public static final Object DEAD = new Status("DEAD");
    public static final Object STOPPED = new Status("STOPPED");
    public static final Object KILLED = new Status("KILLED");
    Environment env;

    public AgentWorker(Agent agent, Environment environment) {
        this.agent = agent;
        agent.worker = this;
        this.env = environment;
    }

    public static void WaitForOtherThreads(PrintStream printStream) {
        Thread thread = Thread.currentThread();
        ThreadGroup threadGroup = thread.getThreadGroup();
        int n = threadGroup.activeCount();
        while (n > 1) {
            Thread[] threadArray = new Thread[n];
            threadGroup.enumerate(threadArray, true);
            int n2 = 0;
            while (n2 < threadArray.length) {
                if (!threadArray[n2].equals(thread) && threadArray[n2].isAlive()) {
                    try {
                        threadArray[n2].join();
                    }
                    catch (InterruptedException interruptedException) {
                        printStream.println("AgentWorker.WaitForOtherThreads " + threadArray[n2] + " --> " + interruptedException);
                    }
                }
                ++n2;
            }
            n = threadGroup.activeCount();
        }
    }

    public Object getStatus() {
        return this.status;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void go(PlaceID placeID) throws CantGoException {
        if (this.status == DEAD || this.status == GONE || this.status == KILLED) {
            throw new CantGoException(String.valueOf(this.agent.toString()) + " can't go to " + placeID.toString() + " because his status is " + this.status);
        }
        if (!this.env.networkManager.sendCommand(placeID, new AgentTransportCommand(this.env, this.agent, placeID))) {
            if (this.env.mobilePlaceManager == null || !this.env.mobilePlaceManager.checkWaitCondition(placeID)) throw new CantGoException(String.valueOf(this.agent.toString()) + " can't go to " + placeID.toString());
            this.env.mobilePlaceManager.addWaitingAgent(this.agent.getID(), placeID);
            this.status = this.status == Daemon.ON ? IDLE : Daemon.OFF;
            return;
        } else {
            this.env.out.println("Worker " + this.toString() + ": agent " + this.agent + " sent to " + placeID);
            if (this.status == Daemon.ON) {
                this.status = GONE;
                return;
            } else {
                try {
                    this.remove();
                    return;
                }
                catch (AgentWorkerException agentWorkerException) {
                    agentWorkerException.printStackTrace(this.env.out);
                }
            }
        }
    }

    public synchronized void idle() {
        if (this.status == Daemon.ON) {
            this.status = IDLE;
        }
    }

    public synchronized void kill() {
        Thread thread = new Thread(this.env.threadGroup, "Agent killer thread"){

            public void run() {
                AgentWorker.this.env.out.println("Killing worker " + AgentWorker.this);
                AgentWorker.this.status = KILLED;
                AgentWorker.this.agentThreadGroup.stop();
                try {
                    AgentWorker.this.remove();
                }
                catch (AgentWorkerException agentWorkerException) {
                    AgentWorker.this.env.out.println("ERROR Removing worker: " + agentWorkerException.toString());
                }
            }
        };
        thread.start();
        try {
            thread.join(10000L);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace(this.env.out);
        }
        if (thread.isAlive()) {
            this.env.out.println("The killer thread has troubles in killing " + this + ": STILL WAITING!");
        } else {
            this.env.out.println("Worker " + this + " killed.");
        }
    }

    public synchronized void remove() throws AgentWorkerException {
        if (this.status == Daemon.OFF || this.status == GONE || this.status == KILLED) {
            AgentWorkerStore agentWorkerStore = this.env.agentManager.agentWorkerStore;
            synchronized (agentWorkerStore) {
                AgentWorker agentWorker = this.env.agentManager.agentWorkerStore.removeWorker(this.agent.getID());
                if (agentWorker != this && agentWorker != null) {
                    this.env.err.println(String.valueOf(this.toString()) + " PROCEDURA INSOLITA: reinserisco il worker: " + agentWorker);
                    this.env.agentManager.agentWorkerStore.putWorker(agentWorker);
                }
            }
            if (this.status == Daemon.OFF) {
                this.status = DEAD;
                this.env.agentManager.agentDeath(this.agent.getID());
                this.env.err.println(String.valueOf(this.toString()) + " AGENT DIED.");
            }
        } else {
            throw new AgentWorkerException("Can't remove worker " + this);
        }
    }

    public void run() {
        Class<?> clazz = this.agent.getClass();
        Method method = null;
        try {
            method = clazz.getMethod(this.agent.start, new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            this.env.err.println("ERROR: " + noSuchMethodException);
        }
        catch (Exception exception) {
            exception.printStackTrace(this.env.err);
        }
        try {
            if (method == null) {
                this.env.err.println(String.valueOf(this.toString()) + "ERROR: null start method --> run() method.");
                this.agent.run();
            } else {
                this.env.err.println(String.valueOf(this.toString()) + " calling method: " + method.toString());
                method.invoke((Object)this.agent, null);
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            this.env.err.println(String.valueOf(this.toString()) + " ERROR " + invocationTargetException);
            invocationTargetException.getTargetException().printStackTrace(this.env.err);
        }
        catch (Exception exception) {
            exception.printStackTrace(this.env.err);
            this.env.err.println(String.valueOf(this.toString()) + " Error " + exception + " on method" + method);
        }
        AgentWorker.WaitForOtherThreads(this.env.err);
        AgentWorker agentWorker = this;
        synchronized (agentWorker) {
            if (this.status == Daemon.ON) {
                this.status = Daemon.OFF;
            }
            try {
                this.remove();
            }
            catch (AgentWorkerException agentWorkerException) {
                this.status = Daemon.OFF;
            }
        }
    }

    public synchronized void start() throws AgentWorkerException {
        if (this.status == Daemon.OFF || this.status == IDLE || this.status == STOPPED) {
            if (this.status == Daemon.OFF) {
                this.agentThreadGroup = new ThreadGroup(this.env.threadGroup, this.agent.getID().toString());
                this.agentThreadGroup.setDaemon(true);
            } else {
                this.env.out.println("WARNING: The Agent was stil in " + this.status + " state.");
                this.env.out.println("  There were still active threads!");
            }
        } else {
            throw new AgentWorkerException("AgentWorker " + this.toString() + " already " + this.status);
        }
        this.agentThread = new Thread(this.agentThreadGroup, this, this.toString());
        this.agentThread.setDaemon(true);
        this.agentThread.setContextClassLoader(this.agent.getClass().getClassLoader());
        this.status = Daemon.ON;
        this.agentThread.start();
    }

    public synchronized void stop() throws AgentWorkerException {
        if (this.status == Daemon.ON) {
            try {
                this.agent.stop();
                this.status = STOPPED;
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                this.env.err.println("Can't stop AgentWorker " + this.toString() + ": agent does't support the stop() operation.");
                throw new AgentWorkerException(unsupportedOperationException.toString());
            }
            catch (Exception exception) {
                this.env.err.println("Can't stop AgentWorker " + this.toString() + ": " + exception);
                exception.printStackTrace(this.env.err);
                throw new AgentWorkerException(exception.toString());
            }
        } else {
            throw new AgentWorkerException("AgentWorker " + this.toString() + " already OFF");
        }
    }

    public String toString() {
        return "[Worker: " + this.agent + " Status: " + this.status + "]";
    }

    public static class AgentWorkerException
    extends Exception {
        public AgentWorkerException(String string) {
            super(string);
        }
    }
}

