/*
 * Decompiled with CFR 0.152.
 */
package SOMA.agent;

import SOMA.Environment;
import SOMA.agent.Agent;
import SOMA.agent.AgentPermission;
import SOMA.agent.CantGoException;
import SOMA.agent.Message;
import SOMA.agent.mobility.PlaceAccessPermission;
import SOMA.naming.PlaceID;
import SOMA.utility.IndexHashtable;
import java.io.InputStream;
import java.io.PrintStream;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

public class AgentSystem {
    private Environment env;
    public IndexHashtable sharedObjects = new IndexHashtable();

    public AgentSystem(Environment environment) {
        this.env = environment;
    }

    public int agentsNumber() {
        return this.env.agentManager.agentsNumber();
    }

    public PlaceID[] getDomains() {
        if (this.env.domainNameService != null) {
            return this.env.domainNameService.getDomainsArray();
        }
        return new PlaceID[0];
    }

    public Environment getEnvironment() {
        if (System.getSecurityManager() != null) {
            AccessController.checkPermission(new AgentPermission("Environment"));
        }
        return this.env;
    }

    public PrintStream getErr() {
        return this.env.err;
    }

    public InputStream getIn() {
        return this.env.in;
    }

    public PrintStream getOut() {
        return this.env.out;
    }

    public PlaceID getPlaceID() {
        return this.env.placeID;
    }

    public PlaceID[] getPlaces() {
        return this.env.placeNameService.getPlacesArray();
    }

    protected void go(final Agent agent, final PlaceID placeID) throws CantGoException {
        try {
            if (System.getSecurityManager() != null) {
                AccessController.checkPermission(new PlaceAccessPermission(placeID));
            }
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws CantGoException {
                    agent.worker.go(placeID);
                    return null;
                }
            });
        }
        catch (AccessControlException accessControlException) {
            throw new CantGoException("Place Access Permission Denied.");
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (CantGoException)privilegedActionException.getException();
        }
    }

    protected void idle(Agent agent) {
        agent.worker.idle();
    }

    public void sendMessage(final Message message) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ((AgentSystem)this).env.agentManager.sendMessage(message);
                return null;
            }
        });
    }
}

