/*
 * Decompiled with CFR 0.152.
 */
package SOMA.explorer;

import SOMA.explorer.DirExplorerItem;
import SOMA.explorer.ExplorerItem;
import java.io.PrintStream;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import javax.security.auth.Policy;
import javax.security.auth.Subject;
import javax.swing.tree.TreeNode;

public class ExplorerTreeNode
implements TreeNode,
Enumeration {
    private ExplorerTreeNode parent;
    private String key;
    private ExplorerItem item;
    private ArrayList sons = new ArrayList();
    private Iterator iter;

    public ExplorerTreeNode(TreeNode treeNode, String string, ExplorerItem explorerItem) {
        this.parent = (ExplorerTreeNode)treeNode;
        this.key = string;
        this.item = explorerItem;
        this.populate();
    }

    public ExplorerTreeNode(ExplorerItem explorerItem) {
        this(null, "/", explorerItem);
    }

    public void populate() {
        if (!this.getAllowsChildren()) {
            return;
        }
        int n = 0;
        int n2 = ((DirExplorerItem)this.item).getItemNumber();
        while (n < n2) {
            String string = (String)((DirExplorerItem)this.item).getKey(n);
            ExplorerItem explorerItem = ((DirExplorerItem)this.item).getItem(n);
            if (this.isGUIKey(string)) {
                this.sons.add(new ExplorerTreeNode(this, string, explorerItem));
            }
            ++n;
        }
    }

    public String getKey() {
        return this.key;
    }

    public String getSyntax() {
        return this.item.getSyntax();
    }

    public TreeNode getChildAt(int n) {
        return (TreeNode)this.sons.get(n);
    }

    public int getChildCount() {
        return this.sons.size();
    }

    public TreeNode getParent() {
        return this.parent;
    }

    public int getIndex(TreeNode treeNode) {
        return this.sons.indexOf(treeNode);
    }

    public boolean getAllowsChildren() {
        return this.item instanceof DirExplorerItem;
    }

    public boolean isLeaf() {
        return this.sons.isEmpty();
    }

    public Enumeration children() {
        this.iter = ((AbstractList)this.sons).iterator();
        return this;
    }

    public boolean hasMoreElements() {
        return this.iter.hasNext();
    }

    public Object nextElement() {
        return this.iter.next();
    }

    private boolean isGUIKey(String string) {
        boolean bl = false;
        bl = bl || string.equals("/");
        bl = bl || string.equals("cd");
        bl = bl || string.equals("exit");
        bl = bl || string.equals("..");
        bl = bl || string.equals("end");
        return !bl;
    }

    public void execute(String string, PrintStream printStream) {
        AccessControlContext accessControlContext = AccessController.getContext();
        Subject subject = Subject.getSubject(accessControlContext);
        System.out.println("Soggetto Attivo che lancia il comando:\n" + subject);
        Policy policy = Policy.getPolicy();
        try {
            System.out.println(policy.getPermissions(subject, this.getClass().getProtectionDomain().getCodeSource()));
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
        if (this.parent != null) {
            ((DirExplorerItem)this.parent.item).Execute(this.key + " " + string, printStream);
        } else {
            ((DirExplorerItem)this.item).Execute(string, printStream);
        }
    }

    public String toString() {
        return this.key;
    }
}

