package SOMA.agent.mobility;

import SOMA.naming.*;
import SOMA.network.connection.*;
import SOMA.agent.*;
import SOMA.agent.mobility.*;
import SOMA.agent.classLoading.AgentClassLoader;
import SOMA.mobilePlace.MobilePlaceID;
import SOMA.Environment;

/** Comando per il trasporto di agenti.
*
* @author Livio Profiri
*/
public class AgentTransportCommand extends Command
{
  /** @serial*/
  final private AgentPacket agentPacket;

  /** @serial*/
  final private PlaceID destination;

  /** Costruttore. */
  public AgentTransportCommand( Environment env, Agent agent, PlaceID destination )
  {
    /*
    if( agent.getClass().getClassLoader() instanceof AgentClassLoader )
      agentPacket = new BasicAgentPacket( agent );
    else
      agentPacket = new SystemAgentPacket( agent );
    */
    agentPacket = env.agentManager.packAgent( agent );

    this.destination = destination;

    //System.out.println( "AgentTransportCommand: created ->" + agentPacket );
  }

  /** Avvia l'agente. */
  public void run()
  {
    AgentID startedID = null;

    try
    {
      Agent agent = agentPacket.getAgent( env );
      AgentWorker worker = env.agentManager.createWorker( agent );

      // Se sono nella home del place mobile dove devo recarmi
      //   vuol dire che questo non  raggiungibile, quindi metto l'agente in attesa.
      if( env.mobilePlaceManager != null && env.mobilePlaceManager.checkWaitCondition( destination ) )
        env.mobilePlaceManager.addWaitingAgent( agent.getID(), destination );
      else
        worker.start();

      startedID = agent.getID();
    }
    catch( Exception e)
    {
      e.printStackTrace( env.err );
    }

    //env.agentManager.startAgent( agentPacket.getAgent( env ) );

    //if( startedID != null )
    //  env.out.println( "AgentTransportCommand: " + startedID + " started." );
    //else
    if( startedID == null )
    {
      env.out.println( "AgentTransportCommand: CANNOT START " + agentPacket );
      env.agentManager.agentDeath( agentPacket.getAgentID() );
    }
  }

  /** Restituisce <code>true</code>.
  * <BR><BR>
  * Gli agenti vengono avviati anche se non raggiungono la destinazione.
  * In questo modo si evita la loro distruzione in caso di malfunzionamento della rete.
  */
  public boolean startOnError()
  {
    return true;
  }

  public String toString()
  {
    return "[AgentTransportCommand " + agentPacket + "]";
  }
}
