package SOMA.agent.classLoading;

import SOMA.naming.*;
import SOMA.network.connection.Command;
import SOMA.Environment;

public class ClassRequestCommand extends Command
{
  private String className;
  private PlaceID sender;
  private int waitAndTimeoutIndex;
  private int classDataIndex;

  /** Costruttore. */
  public ClassRequestCommand( String className, PlaceID sender, int classDataIndex, int waitAndTimeoutIndex )
  {
    this.className = className;
    this.sender =  sender;
    this.classDataIndex =  classDataIndex;
    this.waitAndTimeoutIndex = waitAndTimeoutIndex;
  }

  public void run()
  {
    try
    {
      // Togliere il not!!! per il messaggio!
      if( !env.networkManager.sendCommand(
            sender,
            new SendClassCommand(
                   env.agentManager.agentClassManager.loadClassFile( className ),
                   classDataIndex,
                   waitAndTimeoutIndex )) )
      //  env.err.println( "Class: " + className + " SENT!!!" );
      //else
        env.err.println( "ERROR: couldnt SEND Class: " + className );

    }
    catch( Exception e )
    {
      e.printStackTrace( env.err );
    }
  }

  public String toString()
  {
    return "[ClassRequestCommand " + className + " from " + sender + " classDataIndex: " + classDataIndex + "    waitAndTimeoutIndex: " + waitAndTimeoutIndex + "]";
  }
}
