import SOMA.agent.*;
import SOMA.naming.*;
import java.io.PrintStream;

public class Tour extends Agent
{
  PlaceID[] places = null;
  int index = -1;  // Al primo tour  messo a zero!
  static final String Header = "******";

  public void putArgument( Object obj )
  {
    String[] PlaceNames = (String[])obj;
    places = new PlaceID[PlaceNames.length];

    for( int i = 0; i < PlaceNames.length; i++ )
    {
      try
      {
        //places[i] = new PlaceID( PlaceNames[i] );
        places[i] = SOMA.mobilePlace.MobilePlaceID.parsePlaceID( PlaceNames[i] );
      }
      catch( NameException e )
      {
        try
        {
          places[i] = new PlaceID( "DummyDomain DummyPlace"  );
        }
        catch( NameException f )
        {
          f.printStackTrace();
        }
      }
    }
  }

  public void run()
  {
    PrintStream out = agentSystem.getOut();

    out.println( Header + getID().toString() + " This is my tour:" );

    int i;

    for( i = 0; i < places.length; i++ )
      out.println( Header + getID().toString() + "  " + i + ") " + places[i] );

    out.println( Header + getID().toString() );
    out.println( Header + getID().toString() );
    out.println( Header + getID().toString() + "     STARTING TOUR!!!" );
    out.println( Header + getID().toString() );
    out.println( Header + getID().toString() );

    tour();
  }

  public void tour()
  {
    PrintStream out = agentSystem.getOut();

    index++;

    if( index < places.length )
    {
      if( index == 0 )
        out.println( Header + getID().toString() + "  " + index + ")  --> " + places[index] );
      else
        out.println( Header + getID().toString() + "  " + index + ") " + places[index - 1] + " --> " + places[index] );

      try
      {
        go( places[index], "tour" );
      }
      catch( CantGoException e )
      {
        e.printStackTrace( out );
        out.println( Header + getID().toString() );
        out.println( Header + getID().toString() + "  GOING TO NEXT PLACE" );
        out.println( Header + getID().toString() );
        tour();
      }
    }
    else
    {
      out.println( Header + getID().toString() + "  END OF THE TOUR!!!" );
    }
  }
}