import SOMA.agent.*;
import SOMA.naming.*;
import SOMA.output.*;
import SOMA.utility.*;
import SOMA.mobilePlace.*;

import java.io.*;
import java.awt.*;
import java.awt.event.*;
import java.util.*;

import SOMA.Environment;
import SOMA.explorer.ExplorerThread;


/**
 * L'agente si segue le indicazioni date da console.
 */
public class Shell extends Agent
{
  Chronometer Chrono = new Chronometer();
  transient OutputFrame Win;
  String outputText = "";

  Vector VisitedPlaces, HistoryList;
  transient ExplorerThread explorerThread = null;
  transient ThreadGroup threadGroup = null;

  transient WaitAndTimeout ExitSemaphore;
    // Lo uso per sincronizzare il thread principale
    //   (che aspetta) con il menu.

  //Blocco di inizializzazione!
  MenuBar MainMenuBar;
  // Win.setMenuBar( null );
  Menu menuGo;
  MenuItem goAgentID;
  MenuItem goPlace;
  MenuItem goDomain;
  MenuItem goAbsolute;
  MenuItem goMobile;
  MenuItem goIdle;
  MenuItem goExit;

  Menu menuMail;
  MenuItem mailCheck;
  MenuItem mailSend;
  MenuItem mailSendMobile;

  Menu menuPlace;
  MenuItem placeThis;
  MenuItem placePlaces;
  MenuItem placeDomains;
  MenuItem placeGetEnvironment;
  MenuItem placeAdministration;


  MenuItem placeLocation;
  MenuItem placeHomeName;
  MenuItem placePrintIdleAgents;
  MenuItem placeSaveIdleAgents;
  MenuItem placePrintMobilePlacePositions;
  MenuItem placePrintWaitingAgents;
  MenuItem placeFindMobilePlace;

  Menu menuHistory;
  MenuItem historyList;
  MenuItem historyVisitedPlaces;
  MenuItem historyGo;
  MenuItem historyFind;

  MainMenuActionListener mmal;

  public void stop()
  {
    Win.out.println( "The SYSTEM is stopping me!" );

    // Il metodo di avvio!
    start = "StartMethod";
    outputText = Win.getText();
    ExitSemaphore.Done();
  }

  public void run()
  {
    Chrono.Start();

 	  mmal = new MainMenuActionListener();
 	  outputText = "";

    VisitedPlaces = new Vector();
    HistoryList = new Vector();

    mailbox.mailListener = new Mailbox.MailListener()
 	    {
 	      public void run()
 	      {
          if( Win != null )
          {
            Win.out.println();
            Win.out.println( "!! I have new Mail !!" );
            Win.out.println();
          }
 	      }
 	    };


    StartMethod();
  }

  // Metodo di avvio dopo Idle e go.
  public void StartMethod()
  {
    Chrono.Stop();

    // usato da ExplorerThread
    threadGroup = Thread.currentThread().getThreadGroup();

    BuildMenu(); // Lo faccio ogni volta, se no non compare dopo la deserializzazione... perche?
    ExitSemaphore = new WaitAndTimeout( 0, "< EXIT >", Win.out ); // Lo ricreo perch non  serializzabile.


    Win.show();
    Win.repaint();

    // Vedo se avevo gi questa placeID nella lista
    int IndexOfThisHome = VisitedPlaces.indexOf( agentSystem.getPlaceID() );


    // -1 Non c': l'aggiungo, se no la sostituisco.
    if( IndexOfThisHome == -1 )
      VisitedPlaces.add(agentSystem.getPlaceID() );
    else
      VisitedPlaces.setElementAt(agentSystem.getPlaceID(), IndexOfThisHome );

    // Nella HistoryList c' tutta la sequenza.
    HistoryList.add( agentSystem.getPlaceID() );

    Win.out.println( Chrono.toString() );

    PrintVisitedHomeNames();

    Win.out.println("==>" + agentSystem.getPlaceID() );


    if( mailbox.isMessage() )
      Win.out.println("I have NEW MAIL!" );


    Win.out.println();


    //Mi fermo qui. Riparto con Exit, Go ed Idle.
    ExitSemaphore.Wait();

    if( explorerThread != null )
      explorerThread.stop();

    // Memorizzo il testo della finestra, in questo modo evito di serializzare tutta la finestra!
    outputText = Win.getText();
    //agentSystem.getOut().println( outputText );

    Win.dispose();
    agentSystem.getOut().println( "Agent " + getID() + ": I am EXITING from main Thread!" );
  }

  //Stampa la lista degli HomeName visitati
  void PrintVisitedHomeNames()
  {
    int IndexOfThisHome = VisitedPlaces.indexOf( agentSystem.getPlaceID() );

    Win.out.println( "List of the visited places:" );
    for( int i = 0; i < VisitedPlaces.size(); i++ )
      if( VisitedPlaces.elementAt( i ).equals(
              agentSystem.getPlaceID() ) )
        Win.out.println( "  " + i + ") -> " + VisitedPlaces.elementAt( i ) );
      else
        Win.out.println( "  " + i + ")    " + VisitedPlaces.elementAt( i ) );

    Win.out.println();
  }

    //Stampa la lista degli HomeName visitati
  void PrintHistoryList()
  {
    Win.out.println( "History List:" );
    for( int i = 0; i < HistoryList.size(); i++ )
      Win.out.println( "  " + i + ")    "+ HistoryList.elementAt( i ) );

    Win.out.println();
  }

  private String ReadLine()
  {
    String Answer;

    try
    {
      Answer = Win.inBufferedReader.readLine();
      Win.out.println( Answer );
    }
    catch( Exception e )
    {
      e.printStackTrace( Win.out );
      Answer = "";
    }

    return Answer;
  }

  private boolean PressYes()
  {
    String Answer = ReadLine();

    if( Answer.equalsIgnoreCase( "y" ) || Answer.equalsIgnoreCase( "s" ) )
      return true;
    else
      return false;
  }

	// Il metodo costruisce il menu.
	// Lo faccio ogni volta che l'agente rinasce,
	// se no non mi compare il menu... perch?
	// baco di java 1.2beta2 oppure problema mio?
	void BuildMenu()
	{
    Win = new OutputFrame( "Agent [" + getID() + "]" );

    Win.OnExitCommand = new OutputFrame.Listener() //Stabilisco il comportamento all'uscita
      {
		    public void run()
		    {
          Win.out.println( "  Exiting!" );
		      ExitSemaphore.Done();
        }
      };

    //agentSystem.getOut().println( outputText );
    Win.setText( outputText );

    MainMenuBar = new MenuBar();

    menuGo = new Menu("Agent");
    goAgentID  = new MenuItem("My AgentID");
    goPlace    = new MenuItem("Go to place...");
    goDomain   = new MenuItem("Go to domain...");
    goAbsolute = new MenuItem("Go to domain, place...");
    goMobile   = new MenuItem("Go to domain, place (Mobile)...");
    goIdle     = new MenuItem("Idle...");
    goExit     = new MenuItem("Exit...");

    menuMail = new Menu("Mail");
    mailCheck      = new MenuItem("Check mail");
    mailSend       = new MenuItem("Send message (AgentID)...");
    mailSendMobile = new MenuItem("Send message (MobileAgentID)...");

    menuPlace = new Menu("Place");
    placeThis            = new MenuItem("This PlaceID");
    placePlaces          = new MenuItem("List Places");
    placeDomains         = new MenuItem("List Domains");
    placeLocation        = new MenuItem("This Location");
    placeHomeName        = new MenuItem("This HomeName");

    placeGetEnvironment  = new MenuItem( "Get Environment" );
    placeAdministration  = new MenuItem( "Administer" );

    placePrintIdleAgents = new MenuItem("List Idle agents");
    placeSaveIdleAgents  = new MenuItem("Save Idle agents");
    placePrintMobilePlacePositions = new MenuItem("List mobile places positions");
    placePrintWaitingAgents        = new MenuItem("List agents waiting for connection");
    placeFindMobilePlace = new MenuItem("Find mobile place...");


    menuHistory = new Menu("History");
    historyList          = new MenuItem("History List");
    historyVisitedPlaces = new MenuItem("Show visited places");
    historyGo            = new MenuItem("Go to...");
    historyFind          = new MenuItem("Find place...");

 		menuGo.add( goAgentID );
 		goAgentID.addActionListener( mmal );
	  menuGo.addSeparator();

		menuGo.add( goPlace );
    goPlace.addActionListener( mmal );
    /*
    menuGo.add( goDomain );
    goDomain.addActionListener( mmal );
		menuGo.add( goAbsolute );
		goAbsolute.addActionListener( mmal );
		menuGo.add( goMobile );
		goMobile.addActionListener( mmal );

		menuGo.addSeparator();
		*/
		menuGo.add( goIdle );
		goIdle.addActionListener( mmal );

		menuGo.addSeparator();
		menuGo.add( goExit );
		goExit.addActionListener( mmal );
    MainMenuBar.add( menuGo );


    menuMail.add( mailCheck );
 		mailCheck.addActionListener( mmal );

    menuMail.addSeparator();
    menuMail.add( mailSend );
    mailSend.addActionListener( mmal );
    /*
    menuMail.add( mailSendMobile );
    mailSendMobile.addActionListener( mmal );
    */
    MainMenuBar.add( menuMail );

    menuPlace.add( placeThis );
 		placeThis.addActionListener( mmal );

 		menuPlace.add( placePlaces );
 		placePlaces.addActionListener( mmal );

 		menuPlace.add( placeDomains );
 		placeDomains.addActionListener( mmal );

    menuPlace.addSeparator();

    menuPlace.add( placeGetEnvironment );
    placeGetEnvironment.addActionListener( mmal );

    menuPlace.add( placeAdministration );
    placeAdministration.addActionListener( mmal );

    /*
    menuPlace.add( placeLocation );
 		placeLocation.addActionListener( mmal );

    menuPlace.add( placeHomeName );
    placeHomeName.addActionListener( mmal );

    menuPlace.addSeparator();
    menuPlace.add( placePrintIdleAgents );
    placePrintIdleAgents.addActionListener( mmal );

    menuPlace.add( placeSaveIdleAgents );
    placeSaveIdleAgents.addActionListener( mmal );

    menuPlace.addSeparator();
    menuPlace.add( placePrintMobilePlacePositions );
    placePrintMobilePlacePositions.addActionListener( mmal );

    menuPlace.add( placePrintWaitingAgents );
    placePrintWaitingAgents.addActionListener( mmal );

    menuPlace.add( placeFindMobilePlace );
    placeFindMobilePlace.addActionListener( mmal );
    */
    MainMenuBar.add( menuPlace );

    menuHistory.add( historyList );
    historyList.addActionListener( mmal );
    menuHistory.add( historyVisitedPlaces );
    historyVisitedPlaces.addActionListener( mmal );

    menuHistory.addSeparator();
    menuHistory.add( historyGo );
    historyGo.addActionListener( mmal );
    /*
    menuHistory.add( historyFind );
    historyFind.addActionListener( mmal );
    */

    MainMenuBar.add( menuHistory );

    Win.setMenuBar( MainMenuBar );
  }
	//Questa classe  un actionlistener
	//  assiciato a tutte le voci del menu
	//  lancia un thread per eseguire le singole operazioni
	//  in modo da non bloccare.
	// Occhio alle implements
	class MainMenuActionListener implements
	                                 ActionListener,
	                                 Serializable,
	                                 Runnable
	{
		Object TheMenuItem;

		public void actionPerformed( ActionEvent event )
		{
		  //MenuExecutorThread Th = new MenuExecutorThread( event.getSource() );
		  TheMenuItem = event.getSource();

		  Thread Th = new Thread( this );

		  Th.start();
		  // Devo avviare un thread in modo da non bloccare il thread gestore dell'interfaccia,
		  //   che si deve occupare dell'input.
		}

	  public void run()
	  {
			if( TheMenuItem == goAgentID )
			{
		    Win.out.println( "My AgentID is:" + getID() );
		    Win.out.println();
			}
			else if( TheMenuItem == goIdle )
			{
			  Win.out.println( "Going Idle: send me a message to wake me up!" );
			  Win.out.print( "  Enter y to go to the Idle status..." );

		    if( PressYes() )
		    {
		      Win.out.println( "  Bye!" );
          Win.out.println();
          idle( "StartMethod" );

          ExitSemaphore.Done(); //Sblocco il thread in attesa.
		      //agentSystem.getOut().println( "--> " + getID() + " vado in IDLE" );
		    }
		    else
  	      Win.out.println();
			}
			else if( TheMenuItem == goPlace )
			{
			  Win.out.print( "In which PLACE would you like to go? " );

			  String Answer = ReadLine();

			  Win.out.println( "  Going to " + Answer );
		    Win.out.println();

        try
        {
          Chrono.Start();
          Win.out.println( Chrono.toString() );

          //go( new PlaceID( Answer ), "StartMethod" );
          go( MobilePlaceID.parsePlaceID( Answer ), "StartMethod" );
          ExitSemaphore.Done(); //Sblocco il thread in attesa.
  		    //agentSystem.getOut().println( "--> " + getID() + " vado a" + Answer );
        }
        catch( Exception e )
        {
          Win.out.println( "!!! Can't Go Exception: " + e );
          Win.out.println();
        }
  	  }
  		/*
  		else if( TheMenuItem == goDomain )
			{
			  Win.out.print( "In which DOMAIN would you like to go? " );

			  String Answer = ReadLine();

			  Win.out.println( "  Going to " + Answer );
		    Win.out.println();

        try
        {
          Chrono.Start();
          Win.out.println( Chrono.toString() );

          go( new DomainName( Answer ), "StartMethod" );
          ExitSemaphore.Done(); //Sblocco il thread in attesa.
  		    agentSystem.getOut().println( "--> " + getID() + " vado a" + Answer );
        }
        catch( Exception e )
        {
          Win.out.println( "!!! Can't Go Exception: " + e.getMessage() );
          Win.out.println();
        }
		  }
			else if( TheMenuItem == goAbsolute )
			{
			  Win.out.print( "Enter destination DOMAIN and PLACE:" );

			  StringTokenizer stk = new StringTokenizer( ReadLine() );

        if( stk.hasMoreTokens() )
        {
          String Domain = stk.nextToken();

          String Place = "";

          if( stk.hasMoreTokens() )
            Place = stk.nextToken();

          HomeName Dest = new HomeName( Domain, Place );

			    Win.out.println( "  Going to " + Dest );
  		    Win.out.println();

          try
          {
            Chrono.Start();
            Win.out.println( Chrono.toString() );


            go( Dest, "StartMethod" );
            ExitSemaphore.Done(); //Sblocco il thread in attesa.
  		      agentSystem.getOut().println( "--> " + getID() + " vado a" + Dest );
          }
          catch( Exception e )
          {
            Win.out.println( "!!! Can't Go Exception: " + e.getMessage() );
            Win.out.println();
          }
        }
        else
        {
            Win.out.println( "You should at least enter a Domain, then I will go to the default place." );
            Win.out.println();
        }
		  }
			else if( TheMenuItem == goMobile )
			{
			  Win.out.println( "I need a MobileHomeName identifier for a Mobile Place" );
			  Win.out.print( "  enter DOMAIN and PLACE:" );

			  StringTokenizer stk = new StringTokenizer( ReadLine() );

        try
        {
          String Domain = stk.nextToken();
          String Place  = stk.nextToken();

          // Questa fissa l'ID uguale a Domain e Place,
          //   manda gli aggiornamenti della posizione a Domain, ""
          //   ossia al place di default del dominio.
          MobileHomeName Dest = new MobileHomeName( Domain, Place );

			    Win.out.println( "  Going to " + Dest );
  		    Win.out.println();

          try
          {
            Chrono.Start();
            Win.out.println( Chrono.toString() );

            go( Dest, "StartMethod" );
            ExitSemaphore.Done(); //Sblocco il thread in attesa.
  		      agentSystem.getOut().println( "--> " + getID() + " vado a" + Dest );
          }
          catch( Exception f )
          {
            Win.out.println( "!!! Can't Go Exception: " + f.getMessage() );
            Win.out.println();
          }
        }
        catch( Exception e )
        {
            Win.out.println( "I need 2 fields: " + e.getMessage() );
            Win.out.println();
        }
  	  }*/
			else if( TheMenuItem == goExit )
			{
			  Win.out.print( "Enter y if you want to Exit: " );

		    if( PressYes() )
		    {
		      Win.out.println( "  Bye!" );
          Win.out.println();

		      //agentSystem.getOut().println( "--> " + getID() + " MUOIO" );
		      ExitSemaphore.Done();
		    }
		    else
  	      Win.out.println();
			}
			else if( TheMenuItem == mailCheck )
			{
			  if( !mailbox.isMessage() )
			  {
			    Win.out.println( "No message in my mailbox." );
			    Win.out.println();
			  }
			  else
			    while( mailbox.isMessage() )
          {
            Message Ricevuto = mailbox.getMessage();

            Win.out.println( "Message:" );
            Win.out.println( "  Sender: " + Ricevuto.from );
            Win.out.println( "  Receiver: " + Ricevuto.to );
            Win.out.println( "  Message: " + Ricevuto.message );
            Win.out.println();
          }
			}
			else if( TheMenuItem == mailSend )
			{
        Win.out.println( "To send a Message I need an AgentID in this form:" );
        Win.out.println( "  Domain Place AgentClass Number" );
        Win.out.println();
        Win.out.print( "  AgentID: " );

        AgentID aID = null;
        try
        {
          aID = new AgentID( ReadLine() );
        }
        catch( Exception e )
        {
          Win.out.println( "  Not a valid format. Retry! " + e );
        }
        if( aID != null )
        {
          Win.out.println( "  AgentID --> " + aID );

          Win.out.print( "  Enter message: " );

          String Message = ReadLine();

          Win.out.print( "  Should I send the message?" );

          if( PressYes() )
          {
            agentSystem.sendMessage( new Message( Message, getID(), aID ) );
            Win.out.println( "  Message sent!" );
          }
          else
            Win.out.println( "  Message discarded." );

          Win.out.println();
        }
      }
      /*
      else if( TheMenuItem == mailSendMobile )
			{
        Win.out.println( "To send a Message I need a MobileAgentID in this form:" );
        Win.out.println( "  Domain Place AgentClass Number" );
        Win.out.println();
        Win.out.print( "  AgentID: " );

        StringTokenizer stk = new StringTokenizer( ReadLine() );

        MobileAgentID aID = null;
        MobileHomeName Mhn = null;
        try
        {
          // Costruisco una HomeName, poi una MobileHomeName,
          // infine un MobileAgentID
          Mhn = new MobileHomeName(
                    new HomeName( stk.nextToken(),
                                  stk.nextToken() ) );
          aID = new MobileAgentID(
                             Mhn,
                             stk.nextToken(),
                             Integer.parseInt( stk.nextToken() ) );
        }
        catch( Exception e )
        {
          Win.out.println( "  Not a valid format. Retry!" );
        }
        if( aID != null )
        {
          Win.out.println( "  MobileHomeName --> " + Mhn );
          Win.out.println( "  AgentID --> " + aID );

          Win.out.print( "  Enter message: " );

          String Message = ReadLine();

          Win.out.print( "  Should I send the message?" );

          if( PressYes() )
          {
            Mail.sendMessage( new Message( Message, getID(), aID ) );
            Win.out.println( "  Message sent!" );
          }
          else
            Win.out.println( "  Message discarded." );

          Win.out.println();
        }
      }
			*/
		  else if( TheMenuItem == placeThis )
			{
			  Win.out.println("My Location is:" );

        Win.out.println( "  " + agentSystem.getPlaceID() );

			  Win.out.println();
			}
			else if( TheMenuItem == placePlaces )
			{
        Win.out.println("Places belonging to this Domain:" );

        PlaceID places[] = agentSystem.getPlaces();

        for( int i = 0; i < places.length; i++ )
          Win.out.println( "    " + i + ") " + places[i] );

        Win.out.println();
			}
			else if( TheMenuItem == placeDomains )
			{
        Win.out.println("List of the known Domains:" );

        PlaceID domains[] = agentSystem.getDomains();

        for( int i = 0; i < domains.length; i++ )
          Win.out.println( "    " + i + ") " + domains[i] );

        Win.out.println();
			}
			else if( TheMenuItem == placeGetEnvironment )
			{
			  try
			  {
			    Environment env = agentSystem.getEnvironment();

			    Win.out.println();
			    Win.out.println( "I have access to the Environment and I can administer this Place." );
			    Win.out.println( env.toString() );
			    Win.out.println();
			  }
			  catch( SecurityException e )
			  {
			    Win.out.println();
			    Win.out.println( "I don't have the privileges to get the Environment." );
			    Win.out.println( e.toString() );
			    Win.out.println();
  		  }
			}
			else if( TheMenuItem == placeAdministration )
			{
			  if( explorerThread != null && explorerThread.isAlive() )
			  {
			    explorerThread.Stop();
			    Win.out.println();
			    Win.out.println( "Administration terminated." );
			    Win.out.println();
			  }
			  else
			  {
  			  try
  			  {
  			    Environment env = agentSystem.getEnvironment();

    			  explorerThread = new ExplorerThread( threadGroup, env.dir, Win.in, Win.out, true );

    			  // Volutamente non prevedo un modo per arrestare il thread:
    			  //   deve essere l'utente a farlo chiamando exit();
    			  //explorerThread.addExit();
    			  explorerThread.start();

    			  Win.out.println();
    			  Win.out.println( "Explorer Thread activated." );
    			  Win.out.println( "Use the Administer command AGAIN to disactivate it." );
    			  Win.out.println();
  			  }
  			  catch( Exception e )
  			  {
  			    e.printStackTrace( Win.out );
    		  }
    	  }
			}


			/*
  		else if( TheMenuItem == placeHomeName )
			{
			  Win.out.println("My HomeName is:" );

        Win.out.println( "  " + agentSystem.getPlaceID() );

			  Win.out.println();
			}
			else if( TheMenuItem == placePrintIdleAgents )
			{
			  if( Main.agentManager instanceof IdleAgentManager )
			  	((IdleAgentManager)Main.agentManager).PrintIdleAgents( Win.out );
			  else
			    Win.out.println( "Non  stato installato l'IdleAgentManager!" );

        Win.out.println();
			}
			else if( TheMenuItem == placeSaveIdleAgents )
			{
			  if( Main.agentManager instanceof IdleAgentManager )
			   	try
			  	{
			  	  ((IdleAgentManager)Main.agentManager).SaveIdleAgents();
			  	  Win.out.println( "Idle agents saved successfully!" );
			  	}
			  	catch( IOException e )
			  	{
			  	  e.printStackTrace( Win.out );
			  	}
			  else
			    Win.out.println( "Non  stato installato l'IdleAgentManager!" );

        Win.out.println();
			}
			else if( TheMenuItem == placePrintMobilePlacePositions )
			{
			  Win.out.println( "List of Mobile Places based on this place:" );
			  Main.netManager.PrintMobilePlacePositions( Win.out );
			  Win.out.println();
      }
      else if( TheMenuItem == placePrintWaitingAgents )
			{
			  Main.netManager.PrintWaitingAgents( Win.out );
      }
      else if( TheMenuItem == placeFindMobilePlace )
      {
			  Win.out.println( "I need a MobileHomeName identifier for a Mobile Place" );
			  Win.out.print( "  enter DOMAIN and PLACE:" );

			  StringTokenizer stk = new StringTokenizer( ReadLine() );

        try
        {
          String Domain = stk.nextToken();
          String Place  = stk.nextToken();

          // Questa fissa l'ID uguale a Domain e Place,
          //   manda gli aggiornamenti della posizione a Domain, ""
          //   ossia al place di default del dominio.
          MobileHomeName Destination = new MobileHomeName( Domain, Place );

			    Win.out.println( "  Looking for place: " + Destination );

          Win.out.print( "  Enter TimeOut (in seconds): " );

          MobileHomeName Answer = null;
          try
          {
            long Timeout = Long.parseLong( ReadLine() );

            Answer = Main.netManager.FindMobilePlace( Destination, Timeout * 1000 );
          }
          catch( Exception f )
          {
            Win.out.println( "  Using default timeout. "  );

            Answer = Main.netManager.FindMobilePlace( Destination );
          }

          Win.out.println( "  RESULT: " + Answer );

          if( Answer == MobileHomeName.VoidHomeName )
            Win.out.println( "   No answer from " + Destination.getHomeBase() );
          else if( Answer == null )
            Win.out.println( "   " + Destination + " not found!" );
          else if( Answer.IsConnected() )
          {
            Win.out.println( "   " + Destination.getID() + " CONNECTED as" + Answer  );
            Win.out.println( "             HomeBase:" + Answer.getHomeBase() );
          }
          else
          {
            Win.out.println( "   " + Destination.getID() + " NOT CONNECTED" );
            Win.out.println( "             HomeBase:" + Answer.getHomeBase() );
          }

          Win.out.println();
        }
        catch( Exception e )
        {
            Win.out.println( "I need 2 fields: " + e.getMessage() );
            Win.out.println();
        }
  	  }*/
  	  else if( TheMenuItem == historyList )
      {
        PrintHistoryList();
      }
      else if( TheMenuItem == historyVisitedPlaces )
      {
        PrintVisitedHomeNames();
      }
      else if( TheMenuItem == historyGo )
      {
        PrintHistoryList();
        Win.out.print( "  Enter index: " );

        PlaceID Destination = null;
        try  // Leggo indice, converto e cerco il PlaceID
        {
          Destination = (PlaceID)HistoryList.elementAt(
              Integer.parseInt( ReadLine() ) );
        }
        catch( Exception e )
        {
          Win.out.println( "  Index not valid: " + e );
        }

        if( Destination != null )
        {
        	Win.out.println( "  Going to " + Destination );
  		    Win.out.println();

          try
          {
            go( Destination, "StartMethod" );
            ExitSemaphore.Done(); //Sblocco il thread in attesa.
  		      //agentSystem.getOut().println( "--> " + getID() + " vado a" + Destination );
          }
          catch( Exception e )
          {
            Win.out.println( "!!! Can't Go Exception: " + e.getMessage() );
            Win.out.println();
          }
        }
      }/*
      else if( TheMenuItem == historyFind )
      {
        PrintHistoryList();
        Win.out.print( "  Enter index (pick a Mobile node!): " );

        MobileHomeName Destination = null;
        try  // Leggo indice, converto e cerco la HomeName
        {
          Destination = (MobileHomeName)HistoryList.elementAt(
              Integer.parseInt( ReadLine() ) );
        }
        catch( Exception e )
        {
          Win.out.println( "  Index not valid: " + e );
        }

        if( Destination != null )
        {
        	Win.out.println( "  Looking for place: " + Destination );

          Win.out.print( "  Enter TimeOut (in seconds): " );

          MobileHomeName Answer = null;
          try
          {
            long Timeout = Long.parseLong( ReadLine() );

            Answer = Main.netManager.FindMobilePlace( Destination, Timeout * 1000 );
          }
          catch( Exception e )
          {
            Win.out.println( "  Using default timeout. "  );

            Answer = Main.netManager.FindMobilePlace( Destination );
          }

          Win.out.println( "  RESULT: " + Answer );

          if( Answer == MobileHomeName.VoidHomeName )
            Win.out.println( "   No answer from " + Destination.getHomeBase() );
          else if( Answer == null )
            Win.out.println( "   " + Destination + " not found!" );
          else if( Answer.IsConnected() )
          {
            Win.out.println( "   " + Destination.getID() + " CONNECTED as" + Answer  );
            Win.out.println( "             HomeBase:" + Answer.getHomeBase() );
          }
          else
          {
            Win.out.println( "   " + Destination.getID() + " NOT CONNECTED" );
            Win.out.println( "             HomeBase:" + Answer.getHomeBase() );
          }

          Win.out.println();
        }*/
      }
  }

  // Questo metodo  chiamato durante la serializzazione: salvo il contenuto della finestra
	private void writeObject(java.io.ObjectOutputStream stream)
	   throws IOException
  {
    // Questo non  molto bello: bisognerebbe serializzare tutta la finestra, ma
    //   ho avuto un sacco di problemi nel farlo.

    if( Win != null )
      outputText = Win.getText();

    stream.defaultWriteObject();
  }
}




