import SOMA.agent.*;
import SOMA.naming.*;
import SOMA.utility.Chronometer;
import java.io.*;
import java.util.*;


/**
 * L'agente si segue le indicazioni date da console.
 */
public class Hopper extends Agent
{
  String[] Parameters = null;

  String Header = null;
  PlaceID AltroPlace = null, PlacePartenza = null;
  int nSalti, kPartenza, kIncremento;
  int ContaSalti = -1;    // Attenzione: valore di inizializzazione
  Chronometer Cronometri[] = null, CronometroTempoTotale = new Chronometer( "Tempo totale " );

  Vector Carico = null;

  public void putArgument(Object o)
  {
    Parameters = (String[])o;
  }

  public void run()
  {
    Header = "****" + getID() + "> ";
    PrintStream out = agentSystem.getOut();

    out.print( Header );

    for( int i = 0; i < Parameters.length; i++ )
    {
      out.print( Parameters[i] + " " );
    }

    out.println();

    if( Parameters.length != 4 )
    {
      out.println( Header + "Parametri: AltroPlace nSalti kPartenza kIncremento" );
      out.println( Header + "    AltroPlace: place verso cui saltare." );
      out.println( Header + "    nSalti: numero di salti (andata e ritorno) da effettuare" );
      out.println( Header + "    kPartenza: Kilobytes trasportati alla parteza" );
      out.println( Header + "    kIncremento: Kilobytes aggiunti ad ogni migrazione." );
    }
    else
    {
      try
      {
        //AltroPlace = new PlaceID( Parameters[0] );
        AltroPlace = SOMA.mobilePlace.MobilePlaceID.parsePlaceID( Parameters[0] );
        PlacePartenza = agentSystem.getPlaceID();

        nSalti = Integer.parseInt( Parameters[1] );
        kPartenza = Integer.parseInt( Parameters[2] );
        kIncremento = Integer.parseInt( Parameters[3] );

        Carico = new Vector( 2 * nSalti + 1 );
        Carico.add( new Byte[kPartenza * 1000] );
            // Il carico da trasportare contiene il pacchetto di partenza
            // e due pacchetti per ogni rimbalzo, che comprende due salti.
        Cronometri = new Chronometer[nSalti];    // Misuro la durata di ogni rimbalzo.

        out.println( Header );
        out.println( Header );
        out.println( Header + "    Effettuer " + nSalti + " salti" );
        out.println( Header + "    fra i place: " + PlacePartenza + " e " + AltroPlace );
        out.println( Header + "    dimensione iniziale in kbytes: " + kPartenza );
        out.println( Header + "    ad ogni salto verranno aggiunti kbytes: " + kIncremento );
        out.println( Header );
        CronometroTempoTotale.Start();
        out.println( Header + CronometroTempoTotale );

        Andata();
      }
      catch( Exception e )
      {
        e.printStackTrace();
      }
    }

  }

  public void Andata()
  {
    PrintStream out = agentSystem.getOut();

    ContaSalti++;
    if( ContaSalti > 0 )
    {
      Cronometri[ContaSalti - 1].Stop();
      out.println( Header + " ARRIVO " + Cronometri[ContaSalti - 1] );
    }

    if( ContaSalti < nSalti )
    {
      Cronometri[ContaSalti] = new Chronometer( "Salto " + ContaSalti );
      Cronometri[ContaSalti].Start();
      out.println( Header + " PARTENZA " + Cronometri[ContaSalti] );

      Salto( AltroPlace, "Ritorno" );
    }
    else
    {
      CronometroTempoTotale.Stop();

      out.println( Header + " Fine test:" );
      out.println( Header );

      int TempoTotaleSalti = 0;

      for( int i = 0, Carico = kPartenza + kIncremento; i < nSalti; i ++, Carico += 2 * kIncremento )
      {
        TempoTotaleSalti += (Cronometri[i].StopTime - Cronometri[i].StartTime);
        out.println( Header + Cronometri[i] + " CARICO: " + Carico + " e " + (Carico + kIncremento) + " Totale: " + TempoTotaleSalti );
      }

      out.println( Header );
      out.println( Header + CronometroTempoTotale );
      // Visualizza statistiche;
    }
  }

  public void Ritorno()
  {
    Salto( PlacePartenza, "Andata" );
  }

  void Salto( PlaceID Destinazione, String Metodo )
  {
    try
    {
      Carico.add( new Byte[kIncremento * 1000] );

      go( Destinazione, Metodo );
    }
    catch( Exception e )
    {
      e.printStackTrace( agentSystem.getOut() );
    }
  }
}

