package SOMA.utility;

import java.io.PrintStream;

/** Oggetto di sincronizzazione: attesa di un evento con timeout.
*
* <P> E' progettato in modo che piu' oggetti possano attendere il DONE.
* Puo' essere utilizzato una sola volta.
*
* @author Livio Profiri
*/
public class WaitAndTimeout
{
  /** Dove spedisco i messaggi di debug!*/
  public PrintStream out = System.out;

  /** Nome usato per il debug: {@link toString()}*/
  public String name = "";

  private int status;
  private long timeout;

  public static final int WAITING = 0;
  public static final int DONE = 1;
  public static final int TIMEOUT = 2;

  /** Costruttore:
  * @param timeout Timeout: Timeout = 0 ==> no timeout.
  */
  public WaitAndTimeout( long timeout )
  {
    this.timeout = timeout;
  }

  /** Costruttore:
  * @param timeout Timeout.
  */
  public WaitAndTimeout( long timeout, String name, PrintStream out )
  {
    this.timeout = timeout;
    this.name = name;
    this.out = out;
  }


  /** Descrive completamente lo stato dell'oggetto. */
  public String toString()
  {
    return "[WaitAndTimeout " + name + "(" + timeout  + " ms) " +
      (status == WAITING ? "WAITING]" :
      (status == DONE ?    "DONE]" :
                           "TIMEOUT]")) ;
  }

  /** Aspetta. */
  public synchronized int Wait()
  {
    while( status == WAITING )
    {
      //out.println( "wait: WAITING " + this );
      try
      {
        wait( timeout );
      }
      catch( InterruptedException e )
      {
        out.println( "wait: INTERRUPTED " + this );
      }

      if( status != DONE )
        status = TIMEOUT;
    }

    //out.println( "wait: EXITING " + this );

    return status;
  }

  /** Fine del lavoro. Sblocca i {@link #wait()}. */
  public synchronized void Done()
  {
    if( status == WAITING )
    {
      status = DONE;
      notifyAll();
    }
    else
      notifyAll();


    //out.println( "done: " + this );
  }

  /** Restituisce lo stato. */
  public int getStatus()
  {
    return status;
  }
}
