package SOMA.utility;

import java.io.*;
import java.util.*;

/** Stampa l'elenco dei threads attivi.
*
* @author Livio Profiri
*/
public class ThreadsExplorerItem extends SOMA.explorer.ExplorerItem
{
  ThreadGroup mainThreadGroup;

  public ThreadsExplorerItem()
  {
    super( "List all active threads in this ThreadGroup" );

    mainThreadGroup = Thread.currentThread().getThreadGroup();
  }

  public Object Execute( Collection Parameters, PrintStream out )
  {
    Enumerate( mainThreadGroup, out );

    /*
    Thread[] tarray = new Thread[Thread.activeCount()];

    Thread.enumerate( tarray );

    out.println( "There are " + tarray.length + " active threads in this ThreadGroup: " );
    out.println();

    for( int i = 0; i < tarray.length; i++ )
      out.println( "  " + i + ") " + tarray[i] );

    out.println();
    */

    return null;
  }

  public static void Enumerate( ThreadGroup threadGroup, PrintStream out )
  {
    out.println( "ROOT GROUP: " + threadGroup );
    //out.println( " | " );
    if( threadGroup != null )
      out.println( "TOTAL: " + Enumerate( threadGroup, "", out ) + " threads." );
  }

  public static int Enumerate( ThreadGroup threadGroup, String prefix, PrintStream out )
  {
    int count = threadGroup.activeCount();

    Thread[] tarray = new Thread[count];

    count = threadGroup.enumerate( tarray, false );

    ClassLoader systemClassLoader = ClassLoader.getSystemClassLoader();

    for( int i = 0; i < count; i++ )
    {
      out.println( prefix + " + " + (i + 1) + ") " + tarray[i] );

      ClassLoader classLoader = tarray[i].getContextClassLoader();

      if( classLoader != null ) //&& !classLoader.equals( systemClassLoader ) )
        out.println( prefix + " |   " + classLoader );
      else
        out.println( prefix + " |   null ClassLoader" );
    }

    int countGroups = threadGroup.activeGroupCount();
    ThreadGroup[] tgarray = new ThreadGroup[countGroups];

    countGroups = threadGroup.enumerate( tgarray, false );

    for( int i = 0; i < countGroups; i++ )
    {
      out.println(                    prefix + " | " );
      out.println(                    prefix + " +-GROUP " + i + ") " + tgarray[i] );
      count += Enumerate( tgarray[i], prefix + " | ", out );
    }

    //out.println( prefix + " | " );
    out.println( prefix + " +--------------- " + count + " threads." );
    //out.println( prefix );

    return count;
  }
}