package SOMA.utility;

import java.util.*;

/**
*
* @author Livio Profiri
*/
public class IndexHashtable extends Hashtable
{
  private int counter;

  public IndexHashtable()
  {
    counter = 0;
  }
  /** Costruttore.
  * @param counter Punto di partenza del contatore.
  */
  public IndexHashtable( int counter )
  {
    this.counter = counter;
  }

  public Object get( int index )
  {
    return get( new Integer( index ) );
  }

  public Object put( int index, Object obj )
  {
    return put( new Integer( index ), obj );
  }

  public int put( Object obj )
  {
    put( new Integer( ++counter ), obj );
    return counter;
  }

  public Object remove( int index )
  {
    return remove( new Integer( index ) );
  }

  public int getCounter()
  {
    return counter;
  }

  public String toString()
  {
    return "[IndexHashtable: counter:" + counter + ", " + size() + " objects]";
  }
}
