package SOMA.utility;

import java.util.*;
import java.io.*;

/** Voce di menu per la gestione di un {@link SOMA.utility.Chronometer}.
*
* @author Livio Profiri
*/
public class ChronometerExplorerItem extends SOMA.explorer.ExplorerItem
{
  /** @serial*/
  public Chronometer chrono;

  public ChronometerExplorerItem( String Description )
  {
    super( "[start | stop]" );
    chrono = new Chronometer( Description );
  }

  public Object Execute( Collection Parameters, PrintStream out )
  {
    if( Parameters.size() == 0 )
    {
      out.println( chrono.toString() );
    }
    else
    {
      String Param = (String)Parameters.iterator().next();
      if( Param.equals( "start" ) )
      {
        chrono.Start();
        out.println( "Started-->" + chrono );
      }
      else if( Param.equals( "stop" ) )
      {
        chrono.Stop();
        out.println( "Stopped-->" + chrono );
      }
      else
      {
        out.println( "Unknown operation: " + Param );
      }
    }

    return chrono;
  }

  public String Help( PrintStream out )
  {
    out.println( chrono.toString() );
    return chrono.toString();
  }
}