package SOMA.telnet;

import java.util.*;
import java.io.*;
import java.net.*;
import java.awt.*;

import SOMA.explorer.*;
import SOMA.network.*;
import SOMA.network.connection.*;
import SOMA.output.*;

/** Voce di menu per la creazione di una finestra di amministrazione da remoto.
*
*  @author Livio Profiri
*/

public class TelnetExplorerItem extends ExplorerItem
{
  public TelnetExplorerItem()
  {
    super( "<host> <port>" );
  }

  /** Metodo di esecuzione del comando: apre la finestra.
  */

  public Object Execute( Collection Parameters, PrintStream out )
  {
    if( Parameters.size() == 2 )
    {
      Iterator i = Parameters.iterator();
      String host = (String)i.next();
      String Param = (String)i.next();

      int port = 0;
      try
      {
        port = Integer.parseInt( Param );
      }
      catch( Exception e )
      {
        out.println( "ERROR: incorrect port number" + Param );
        return null;
      }

      try
      {
        final OutputFrame window = new OutputFrame( "Telnet: " + host + " " + port );
        window.ListOut.Target.setBackground(new Color(12632256));

        final Connection conn = new Connection( new java.net.Socket( host, port ), null );

        window.OnExitCommand = new OutputFrame.Listener() //Stabilisco il comportamento all'uscita
        {
  		    public void run()
  		    {
            window.out.println( "  Exiting!" );
            window.setVisible( false );
            window.dispose();

            try
            {
              conn.stop();
            }
            catch( Exception e )
            {}
          }
        };

        //conn.start();
        // Quickcommand in modo da bloccare la ricezione di altri comandi
        //   spediti erroneamente.
        conn.send( new QuickCommand()
          {
            public void run()
            {
              // L'input viene dalla socket.
              Thread thread = new ExplorerThread( env.dir, ReturnConnection.getIn(),
                                     env.out, true );

              thread.start();

              // L'output va anche alla socket.
              env.multiOut.add( ReturnConnection.getOut() );

              env.out.println();
              env.out.println( "Connection " + ReturnConnection + " used for telnet!!!" );
              env.out.println();

              try
              {
                thread.join();  // Blocco il tread in attesa di oggetti sulla socket.
              }
              catch( InterruptedException e )
              {
                e.printStackTrace( env.out );
              }
            }
          });

        new Pipetta( window.in, conn.getOut() ).start();
        new Pipetta( conn.getIn(), window.out ).start();

        window.show();
        window.toFront();

        out.println( "Amministrazione avviata!" );
      }
      catch( Exception e )
      {
        e.printStackTrace( out );
      }
    }
    return null;
  }
}