package SOMA.security.utility;

import java.security.cert.*;


/** This class implements a set of java.security.cert.X509Certificate

  */

class SetX509Certificate
{

        X509Certificate cert = null;
        SetX509Certificate next = null;

        public SetX509Certificate(){
             this.cert = null;
             this.next = null;
        }

        public SetX509Certificate(X509Certificate obj){
             this.cert = obj;
             this.next = null;
        }

        public SetX509Certificate(X509Certificate obj,SetX509Certificate next){
             this.cert = obj;
             this.next = next;
        }

        public boolean in (X509Certificate obj){
            if (this.cert == null) return false;
            if ((this.cert.getSubjectDN()).equals(obj.getSubjectDN())) return true;
            if (this.next == null) return false;
            return this.next.in(obj);
        }

        public boolean in (String obj){
            if (this.cert == null) return false;
            if ((this.cert.getSubjectDN()).equals(obj)) return true;
            if (this.next == null) return false;
            return this.next.in(obj);
        }

        public void put (X509Certificate obj){
            if (this.cert == null || (this.cert.getSubjectDN()).equals(obj.getSubjectDN()))
                this.cert = obj;
            else if (this.next == null)  this.next = new SetX509Certificate(obj);
                 else this.next.put(obj);
        }

        public boolean empty(){
            return this.cert == null;
        }

        public X509Certificate head(){
            if (this.cert == null) return null;
            return this.cert;
        }
        public SetX509Certificate tail(){
            if (this.cert == null || this.next == null) return null;
            return this.next;
        }
        public SetX509Certificate delete (String dn){
            if (this.in(dn)){
               SetX509Certificate newset = new SetX509Certificate();
               SetX509Certificate tempset = this;
               X509Certificate tempcert;
               while (! tempset.empty()){
                    tempcert = tempset.head();
                    tempset = tempset.tail();
                    if (!(tempcert.getSubjectDN()).equals(dn))
                       newset.put(tempcert);
               }
               return newset;
            }
            else return null;
        }

        public X509Certificate get (String dn){
            if (this.cert == null) return null;
            if ((this.cert.getSubjectDN()).equals(dn)) return this.cert;
            return this.next.get(dn);
        }

        public void println(){
            if (this.cert != null)
                System.out.println("<SetX509Certificate;#" + this + ">" + this.cert.toString());
        }

}