package SOMA.security.net.ssl;


import java.net.*;
import java.io.*;
import java.security.*;
// import java.security.cert.X509Certificate;
import iaik.security.ssl.*;
// import iaik.asn1.structures.Name;
import com.entrust.util.*;
import com.entrust.security.provider.*;
import com.entrust.x509.directory.*;
import com.entrust.toolkit.*;

import SOMA.security.infrastructure.*;

public class SSLClientSocket extends Socket {

    //private profileManager ProfileManager;

    public Socket SSLClientSocket( InetAddress host, int port, ProfileManager profileManager  )
            throws SSLException  {
        EntrustProfile entrustProfile;
        Infrastructure infrastructure;

        if (( (profileManager == null) ) ||
            ( (entrustProfile = profileManager.getProfile()) == null  )) throw new SSLException("Null Profile.");

        // Initialize ciphers.
        //     com.entrust.util.Util.initCiphers();

        SSLClientContext sslClientContext = new SSLClientContext();

        // Accept only these strong ciphers
        CipherSuite [] suites = {
                    CipherSuite.SSL_RSA_WITH_3DES_EDE_CBC_SHA,
                    CipherSuite.SSL_RSA_WITH_RC4_SHA,
                    CipherSuite.SSL_RSA_WITH_RC4_MD5
                                };
        sslClientContext.setEnabledCipherSuites( suites );

        try {
            //System.out.println("Enter the IP address of the directory: ");
            //String addressDir = stdIn.readLine();
            JNDIDirectory directory;

            if ( (infrastructure = profileManager.getEntrustInfrastructure()) == null ||
                 (infrastructure.getInfrastructureAddress() == null) )
                directory = null;
            else directory = infrastructure.getInfrastructureAddress().getDirectory();

            //directory.connect();

            ETKCertificateVerifier verifier = new ETKCertificateVerifier( directory, entrustProfile );
            sslClientContext.setTrustDecider(verifier);
        } catch (Exception ex) {
            ex.printStackTrace();
        }

        System.out.println("ETKCertificateVerifier done.");
        System.out.println("Enter server name: ");
        SSLSocket clientSocket = null;


        try {
            clientSocket = new SSLSocket(host, port, sslClientContext);

            // Check which cipher was agreed upon.
            // Note that the cipher suite is only available after getting at
            // least one of the streams.
            // (See the SSL Javadocs for details).
            System.out.println("\n>> Active Cipher <<\n");
            CipherSuite cs = clientSocket.getActiveCipherSuite();

            if (cs == null) System.out.println("Suite is null!");
            else
                {
                    System.out.println("Active algorithm: " + cs.cipherAlgorithm());
                    System.out.println("Key material: " + cs.keyMaterial());
                    System.out.println("Exp. Key Material " + cs.expandedKeyMaterial() + "\n");
                }

            return clientSocket;
        } catch (Exception e) { System.out.println("Errore nella creazione del client socket"); }

        return null;

    }
}

