//package SOMA.security.net;
package SOMA.network;

import java.io.*;
import java.net.*;
import java.util.*;

import SOMA.network.*;
import SOMA.network.connection.*;
import SOMA.Environment;
import SOMA.explorer.*;
import SOMA.naming.*;
import SOMA.naming.place.*;
import SOMA.naming.domain.*;

import SOMA.security.net.ssl.*;

// Eliminare
import SOMA.agent.mobility.AgentManager;


/** Gestore delle comunicazioni di rete di un {@link SOMA.Environment place}.
*
* @author Livio Profiri
*/

public class NetworkManagerSecurity extends NetworkManager
{ /*
  Environment env;
  ConnectionServer connectionServer = null;
  private Hashtable permanentConnections = new Hashtable();  */

  /** Informazioni sul place. */
/*  public PlaceInfo placeInfo;

  DirExplorerItem networkManagerDir;
  DirExplorerItem connectionsDir;
  int connectionCount = 1;  */

  /** Memorizza le {@link SOMA.network.connection.Connection connessioni}
  * con gli altri place dello stesso dominio. */
  public ConnectionStore connectionStore = new ConnectionStore();

  /** Costruttore.
  * @param env L'environment del place.
  * @param port La porta su cui avviare il
  *   {@link SOMA.network.connection.ConnectionServer server} per le connessioni.
  */
  public NetworkManagerSecurity( Environment env, int port ) throws IOException, ConnectionServer.ConnectionServerException, NameException
  {

    super ( env );
    NetworkManagerInit ( port );

  }

  public void NetworkManagerInit( int port ) throws IOException, ConnectionServer.ConnectionServerException, NameException
  {

    if( env.placeID.isDomain() )
      placeInfo = new DomainInfo( env.placeID, InetAddress.getLocalHost(), port );
    else
      placeInfo = new PlaceInfo( env.placeID, InetAddress.getLocalHost(), port );

    //Aggiungo 2 voci alla struttura delle directory.
    networkManagerDir = new DirExplorerItem( "netManager" );
    env.dir.addItem( networkManagerDir );

    networkManagerDir.addItem( "placeInfo", new ObjectExplorerItem( placeInfo ) );

    // Eliminare questa: la lista si allunga ad ogni connessione.
    connectionsDir = new DirExplorerItem( "connections" );
    networkManagerDir.addItem( connectionsDir );

    // Aggiungo un'autoconnessione, in modo che i comandi spediti verso lo stesso place
    //   vengano eseguiti in loco
    Connection selfConnection = new SelfConnection( env );
    connectionStore.putConnection( env.placeID, selfConnection );
    connectionsDir.addItem( "selfConnection", new ConnectionExplorerItem( selfConnection ) );

    // Avvio il server per le connessioni
    connectionServer = new SSLConnectionServer( port, 100,
      new ExplorableConnectionFactory( env, connectionsDir, "servConn" ) );

    networkManagerDir.addItem( "server" , new DaemonExplorerItem( connectionServer ) );

    connectionServer.start();

    if( env.placeID.isDomain() )
    {
      env.domainNameService = new DomainNameService( env );
      env.dir.addItem( "dns", new DNSExplorerItem( env.domainNameService ) );

      env.domainNameService.putDomain( (DomainInfo)placeInfo );
    }

    env.placeNameService = new PlaceNameService( env );
    env.dir.addItem( "pns", new PNSExplorerItem( env.placeNameService ) );

    env.placeNameService.putPlace( placeInfo );

    networkManagerDir.addItem( "connList" , new ExplorerItem( "List of connections" )
      {
        public Object Execute( Collection Parameters, PrintStream out )
        {
          connectionStore.printConnections( out );
          return null;
        }
      });

    networkManagerDir.addItem( "send" , new ExplorerItem( "<PlaceID> <Message>" )
      {
        public Object Execute( Collection Parameters, PrintStream out )
        {
          if( Parameters.size() > 1 )
          {
            Iterator i = Parameters.iterator();

            PlaceID dest = null;
            try
            {
              dest = new PlaceID( (String)i.next() );
            }
            catch( NameException e )
            {
              out.println( e );
              return e;
            }

            SendMessageCommand Message = new SendMessageCommand( (String)i.next() );

            out.println( "Sending command " + Message + " to " + dest );

            if( sendCommand( dest, Message ) )
            {
              out.println( "Message " + Message + " sent!" );
              return new Boolean( true );
            }
            else
            {
              out.println( "ERROR: Message " + Message + " NOT SENT!" );
              return new Boolean( true );
            }
          }

          out.println( "incorrect number of parameters" );
          return null;
        }
      });

    networkManagerDir.addItem( "perm" , new PermanentConnectionsExplorerItem() );
  }

  /** Spedizione di un comando ad un place.
  *
  * @return <code>true</code> se la spedizione ha avuto successo.
  */
  public boolean sendCommand( PlaceID destID, Command aCommand )
  {
    // Questa va rifatta per bene

    //if( PlaceID.isDomain() )  Occhio al default palce

    boolean answer = false;

    // Stesso dominio
    if( env.placeID.sameDomain( destID ) )
    {
      // Sono gi nel place di destinazione
      //if( env.placeID.equals( destID ) )

      //  aCommand.start( new SelfConnection( env )

      //else
        answer = sendCommandToPlace( destID, aCommand );
    }
    else if( env.placeID.isDomain() ) // Sono in un default place
    {
      Command toSend;

      if( destID.isDomain() )  // destinazione: un altro dominio
        toSend = aCommand;
      else // destinazione: un place di un altro dominio
      {
        env.out.println( "Sending TRANSPORTCOMMAND with " + aCommand + " to " + destID.getDomainID() );
        toSend = new TransportCommand( destID, aCommand );
      }

      answer = sendCommandToDomain( destID.getDomainID(), toSend );
    }
    else // Sono in un place normale e devo spedire un messaggio ad un altro dominio
    {
      env.out.println( "Sending TRANSPORTCOMMAND with " + aCommand + " to default place" );
      answer = sendCommandToPlace( env.placeID.getDomainID(),
                                   new TransportCommand( destID, aCommand ) );
    }

    /*
    // Sono gi nel place di destinazione
    if( env.placeID.equals( placeID ) )
    {
      // Non  implementato, perch Return() fallisce;
      throw new RuntimeException( "Comando " + aCommand + " gi nel place! NON PUO' ERRERE ESEGUITO" );
    }

    // Destinazione  un dominio, ma non quello corrente
    if( placeID.isDomain() && !placeID.equals( env.placeID.getDomainID() ) )
    {
      // Ho un dns: sono in un default place
      if( env.domainNameService != null )
      {
        DomainInfo di = env.domainNameService.getDomain( placeID );

        if( di != null )
          answer = sendCommand( di.host, di.port, aCommand );
      }
      else // Non ho un dns: devo spedire in un default place
      {
        env.out.println( "Sending TRANSCOMMAND with " + aCommand + " to default place" );
        answer = sendCommandToPlace( env.placeID.getDomainID(),
                                     new TransCommand( placeID, aCommand ) );
      }
    }
    else
    { // place dello stesso dominio
      if( placeID.getDomainID.equals( env.placeID.getDomainID() )
        answer = sendCommandToPlace( placeID, aCommand );
      else // place di un altro dominio
      {
        env.out.println( "Sending TRANSCOMMAND with " + aCommand + " to default place" );
        answer = sendCommandToPlace( env.placeID.getDomainID(),
                                     new TransCommand( placeID, aCommand ) );
      }
    }
    */

    return answer;
  }

  // Sends a command to a place in the same domain.
  //  privato perch non testo il rispetto del vincolo di appartenenza allo stesso dominio.
  // occhio: la connessione rimane attiva e memorizzata nel PlaceNameService

  private boolean sendCommandToPlace( PlaceID placeID, Command aCommand )
  {
    boolean returnValue = false;

    Connection connection = connectionStore.getConnection( placeID );
    // Se la connessione non  c' o  disattiva, la riattivo
    if( connection == null ||
        connection.getStatus() != Daemon.ON )
    {
      PlaceInfo pi = env.placeNameService.getPlace( placeID );

      if( pi != null )
      {
        try
        {
          connection = new Connection( new Socket( pi.host, pi.port ), env );
          connectionStore.putConnection( placeID, connection );

          connectionsDir.addItem( placeID.place + connectionCount++,
                                  new ConnectionExplorerItem( connection ) );
          env.out.println( "STARTING CONNECTION: " + env.placeID + " <--> " + placeID );
          connection.start();
          connection.send( new ConnectionCommand( env.placeID ) );
        }
        catch( Exception e )
        {
          e.printStackTrace( env.err );
          returnValue = false;
        }
      }
    }

    // Se ora  attiva, procedo alla spedizione del comando
    if( connection != null && connection.getStatus() == Daemon.ON )
    {
      synchronized( connection )
      {
        try
        {
          connection.send( aCommand );
          returnValue = (connection.getStatus() == Daemon.ON );
        }
        catch( Exception e )
        {
          e.printStackTrace( env.err );
          returnValue = false;
        }
      }
    }

    return returnValue;
  }

  // Spedisco un comando ad un Dominio:
  // - creo una connessione
  // - NON avvio il thread in ascolto
  // - spedisco il comando
  // - chiudo la connessione = le SOCKET

  // - Restituisco true se la connessione non  in ERROR, ossia se il messaggio  arrivato.

  private boolean sendCommandToDomain( PlaceID domainID, Command aCommand )
  {
    boolean returnValue = false;

    Connection connection = connectionStore.getConnection( domainID );
    boolean isPermanent = isPermanentConnection( domainID ) > 0;
    boolean connectionCreated = false;

    // Se la connessione non  c' o  disattiva, la riattivo
    if( connection == null ||
        connection.getStatus() != Daemon.ON )
    {
      DomainInfo di = env.domainNameService.getDomain( domainID );

      if( di != null )
      {
        try
        {
          connection = new Connection( new Socket( di.host, di.port ), env );

          connectionsDir.addItem( domainID.domain + connectionCount++,
                                new ConnectionExplorerItem( connection ) );

          // Solo se la connessione  permanente
          if( isPermanent )
          {
            connectionStore.putConnection( domainID, connection );
            env.out.println( "STARTING DOMAIN PERMANENT CONNECTION: " + env.placeID + " <--> " + domainID );
            connection.start();  // La avvio solo se  permanente
            connection.send( new ConnectionCommand( env.placeID ) );
          }

          connectionCreated = true;
        }
        catch( Exception e )
        {
          e.printStackTrace( env.err );
          returnValue = false;
        }
      }
    }

    // Se ora  attiva, procedo alla spedizione del comando
    //if( connection != null && connection.getStatus() == Daemon.ON )
    if( connection != null )
    {
      synchronized( connection )
      {
        try
        {
          connection.send( aCommand );
          returnValue = (connection.getStatus() != Daemon.ERROR );

          if( !isPermanent && connectionCreated )
            connection.stop();
            // Interrompo la connessione solo se non  permanente e l'ho creata io.
            // Se non  permanente e non l'ho creata io, qualcun altro si occuper di chiuderla,
            //  ad esempio l'altro pari.
        }
        catch( Exception e )
        {
          e.printStackTrace( env.err );
          returnValue = false;
        }
      }
    }

    env.err.println( "NetworkManagerSecurity.sendCommandToDomain " + domainID + " " + aCommand + " DONE. OK?" + returnValue );

    return returnValue;
  }

  // Utilizzata per spedire un comando ad una coppia host: port
  // In questo caso la connessione viene attivata e dovr essere disattivata
  // in seguito, magari da un comando apposito:
  // - creo una connessione
  // - avvio il thread in ascolto
  // - spedisco il comando
  // - NON chiudo la connessione

  /** Spedizione di un comando ad un server di indirizzo: <B>host:port</B>.
  *
  * @return <code>true</code> se la spedizione ha avuto successo.
  */
  public boolean sendCommand( InetAddress host, int port, Command aCommand )
  {
    boolean returnValue = true;

    try
    {
      Connection connection = new Connection( new Socket( host, port ), env );
      connectionsDir.addItem( "clientConn" + connectionCount++,
                              new ConnectionExplorerItem( connection ) );

      synchronized( connection )
      {
        connection.start();
        connection.send( aCommand );
        returnValue = (connection.getStatus() == Daemon.ON );
      }
    }
    catch( Exception e )
    {
      e.printStackTrace( env.err );
      returnValue = false;
    }

    return returnValue;
  }

  /** <P>Richiede una connessione stabile con il place specificato.
  *
  * <P> Questo metodo altera la politica di gestione delle connessioni fra domini.
  * Normalemnte le connessioni fra domini vengono attivate al momento della spedizione di un messaggio
  * e disattivate subito dopo. Dopo una chiamata a startPermanentConnection, se siamo
  * in un default place e se il place specificato appartiene ad un altro dominio, allora
  * la connessione diretta a quel dominio non verra' interrotta dopo la spedizione di un messaggio,
  * ma rimarra' attiva, pronta per la spedizione di eventuali successivi messaggi.
  *
  * <P> E' possibile ritornare al funzionamento normale con una chiamata a
  * {@link #stopPermanentConnection(placeID)}.
  *
  * <P> E' previsto un meccanismo per gestire pi chiamate successive al metodo
  * startPermanentConnection: ad ogni connessione e' associato un intero
  * uguale a (NUMERO di start) - (NUMERO di stop). Questo intero corrisponde al numero
  * di "procedure" che hanno fatto richiesta di connessione stabile e non hanno ancora
  * terminato il loro compito. Quando l'intero va a zero si comunica all'altro pari
  * la possiiblit di interrompere la connessione. Se anche all'altro capo della connessione
  * nessuno ne ha piu' bisogno, la connessione viene terminata.
  *
  * @returns (NUMERO di start effettuati) - (NUMERO di stop)
  */
  public int startPermanentConnection( PlaceID placeID )
  {
    int returnValue = 0;

    if( env.placeID.isDomain() && !env.placeID.sameDomain( placeID ) )
    {
      PlaceID domainID = placeID.getDomainID();

      Integer i = (Integer)permanentConnections.get( domainID );

      if( i != null )
        returnValue = i.intValue() + 1;
      else
        returnValue = 1;

      permanentConnections.put( domainID, new Integer( returnValue ) );
    }

    return returnValue;
  }

  /**
  * <P>Avvia una connessione stabile con il place specificato.
  * <P>
  * @see #startPermanentConnection( placeID )
  * <P>
  * @returns (NUMERO di start effettuati) - (NUMERO di stop)
  */
  public int stopPermanentConnection( PlaceID placeID )
  {
    PlaceID domainID = placeID.getDomainID();

    int returnValue = isPermanentConnection( domainID );

    // Se ci sono ancora threads che hanno bisogno della connessione
    if( returnValue > 1 )
    {
      returnValue--;
      permanentConnections.put( domainID, new Integer( returnValue ) );
    }
    else // Se la conessione non serve a nessuno
    {
      if( returnValue == 1 )
      {
        returnValue--;
        permanentConnections.remove( domainID );  // Rimuovo il contatore.
      }

      Connection connection = connectionStore.getConnection( domainID );

      // Se la connessione c', la elimino
      if( connection != null )
      {
        // Se la connessione  attiva, chiedo all'altro pari se  il caso di disattivarla.
        if( connection.getStatus() == Daemon.ON )
        {
          try
          {
            // Chiedo all'altro pari se  il caso di disattivare la connessione stabile
            connection.send( new StopConnectionCommand( env.placeID ) );
          }
          catch( Exception e )
          {
            e.printStackTrace( env.err );
          }
        }
        else  // Rimuovo la connessione solo se  inattiva
          connectionStore.removeConnection( domainID );
      }
    }

    return returnValue;
  }

  /**
  * <P>Restituisce l'intero relativo alla connessione stabile con il place specificato.
  * <P>
  * @see #startPermanentConnection( placeID )
  * <P>
  * @returns (NUMERO di start effettuati) - (NUMERO di stop)
  */
  public int isPermanentConnection( PlaceID placeID )
  {
    int returnValue = 0;

    Integer i = (Integer)permanentConnections.get( placeID.getDomainID() );

    if( i != null )
      returnValue = i.intValue();

    return returnValue;
  }

  public String toString()
  {
    return "[netManager]";
  }

  /** Gestisce le connessioni permanenti fra domini.
  * @author Livio Profiri
  */
  public class PermanentConnectionsExplorerItem extends ExplorerItem
  {
    public PermanentConnectionsExplorerItem()
    {
      super( "[\"placeID\" [start | stop]]" );
    }

    public Object Execute( Collection Parameters, PrintStream out )
    {
      if( Parameters.size() == 0 )
      {
        out.println( "List of domain permanent connections:" );
        out.println();

        Iterator i = permanentConnections.entrySet().iterator();

        for( int j = 1; i.hasNext(); j++ )
        {
          Map.Entry e = (Map.Entry)i.next();
          out.println( "  " + j + ") " + e.getKey() + " --> " + e.getValue() );
        }

        out.println();
      }
      else
      {
        Iterator i = Parameters.iterator();

        PlaceID placeID = null;

        try
        {
          placeID = new PlaceID( (String)i.next() );
        }
        catch( NameException e )
        {
          out.println( "Invalid place ID: " + e );
          return e;
        }

        int result = 0;

        if( i.hasNext() )
        {
          String operation = (String)i.next();

          if( "start".equals( operation ) )
            result = startPermanentConnection( placeID );
          else if( "stop".equals( operation ) )
            result = stopPermanentConnection( placeID );
          else
          {
            out.println( "Unknown operation: " + operation );
            return null;
          }
        }
        else
          result = isPermanentConnection( placeID );

        out.println( "Number of pocesses using connection to " + placeID + ": " + result );
        return new Integer( result );
      }

      return null;
    }
  }
}