package SOMA.security.infrastructure.updatePolicy;


import java.io.PrintStream;

import SOMA.network.connection.Daemon;
import SOMA.security.infrastructure.Infrastructure;
import SOMA.security.infrastructure.ProfileManager;


public class UpdateDaemon implements Runnable, Daemon
{
  Thread myServerDaemon;
  private Object status = OFF;

  private UpdatePolicy policy;
  private Infrastructure pki;
  private PrintStream out;
  private ProfileManager profile;


  public UpdateDaemon ( ProfileManager profile, UpdatePolicy policy , Infrastructure pki , PrintStream out )
  { this.profile=profile;
    this.policy = policy;
    this.pki = pki;
    this.out = out;
  }

  /** Modifica la politica di aggiornamento dei certificati in locale. **/
  public synchronized void setUpdatePolicy ( UpdatePolicy policy )
        throws PolicyException
  {
    Object currentStatus = this.status;

    if ( policy == null ) throw new PolicyException ( "Null policy value." );

    if ( status == ON )
      this.status = OFF;

    this.policy = policy;
    this.status = currentStatus;
  }

    /** Avvio del demone. */
  public synchronized void start()
      throws PolicyException
  {
    if( status != ON )
    {
      myServerDaemon = new Thread( this, toString() );
      status = ON;
      myServerDaemon.start();
    }
    else throw new PolicyException( "Server already ON" );
  }



  /** Arresto del demone. */
  public synchronized void stop()
        throws PolicyException
  {
    if( status != OFF ) status = OFF;
    else throw new PolicyException( "Server already OFF" );
  }

  public Object getStatus()
  {
    return status;
  }

  public String toString()
  {
     return "<UpdateDaemon: status = " + status + "\n  Policy = " + policy + ">";
  }

  /** Metodo eseguito dal demone: attende richieste ed attiva connessioni finche' lo stato rimane ON e la ServerSocket attiva. */
  public void run()
  {

    while( status == ON )
    {
      try{

        if ( this.policy.update() )

          if ( pki.getInfrastructureAddress().onLine )
          {
            out.println("Updating certificate into local list.");
            long t0 = System.currentTimeMillis();
            pki.updateCertificateCRLList(profile);
            long t1 = System.currentTimeMillis();
            out.println("Update certificate into local list t = " + (t1 - t0) + " ms");
          }
          Thread.sleep( this.policy.getSleepTime() );
      } catch ( Exception e ) { out.println( "Certificate update error." ); }

    }
  }


}