package SOMA.security.infrastructure.explorer;

import java.util.*;
import java.io.*;

import SOMA.explorer.ExplorerItem;
import SOMA.explorer.DirExplorerItem;
import SOMA.security.infrastructure.ProfileManager;
import SOMA.security.infrastructure.CertificateCRLList;

/** Voce di menu per la gestione di un {@link SOMA.utility.Chronometer}.
*
* @author Luca Ghetti
*/
public class CRLsExplorerItem extends SOMA.explorer.ExplorerItem
{
  /** @serial*/
  public ProfileManager profile;

  //  Current directory.
  public DirExplorerItem currentDir;

  public Object myKey;

  public CRLsExplorerItem( Object myKey, ProfileManager profile, DirExplorerItem currentDir )
  {
    super( "Show CRLs" );
    this.profile = profile;
    this.currentDir = currentDir;
    this.myKey = myKey;
  }

  public Object Execute( Collection Parameters, PrintStream out )
  {
    CertificateCRLList CRLs;
    Enumeration [] enCRL;

    out.println( "CRLs:" );

    if (( this.profile != null ) &&
        ( this.profile.getEntrustInfrastructure() != null ) &&
        ( (CRLs = this.profile.getEntrustInfrastructure().getCertificateCRLList()) != null ) &&
        ( (enCRL = CRLs.listRevockedCertificates()) != null ))
        for (int i=0; i<enCRL.length; i++)
          while ( enCRL[i].hasMoreElements() )
            out.println( enCRL[i].nextElement().toString() );
    else
        out.println("   return null value.");

    return profile;
  }

  public String Help( PrintStream out )
  {
    out.println( profile.toString() );
    return profile.toString();
  }
}