package SOMA.security.infrastructure.explorer;

import java.util.*;
import java.io.*;

import SOMA.explorer.ExplorerItem;
import SOMA.explorer.DirExplorerItem;
import SOMA.security.infrastructure.*;

/** Voce di menu per la gestione di un {@link SOMA.utility.Chronometer}.
*
* @author Luca Ghetti
*/
public class AddressExplorerItem extends ExplorerItem    // implements SOMA.security.infrastructure.NetAddress
{
  /** @serial*/

  InfrastructureAddress address = null;
  ProfileManager profile = null;

  DirExplorerItem currentDir;
  Object myKey;

  public AddressExplorerItem( Object myKey, DirExplorerItem currentDir , ProfileManager profile )
  {
    super( "[ localhost | caAddress caIP dirIP | default | showDefault | setOnLine | setOffLine ) | setManagerIP caIP | setManagerPort caPort | setDirectoryIP dirIP | setDirectoryPort dirPort | connect ]" );

    this.profile = profile;

    this.currentDir = currentDir;

    this.myKey = myKey;
  }

  public Object Execute( Collection Parameters, PrintStream out )
  {
    try {

    if( Parameters.size() == 0 )
    {
      out.println( currentDir.toString() + "\n" + (address == null ? "" : address.toString() ));
    }
    else
    {
      Iterator parametri = Parameters.iterator();
      System.out.println (" Create parametri ");
      String Param = (String)parametri.next();
      System.out.println (" Created parametri ");
      parametri.remove();
      System.out.println (" remove parametri ");

      if( Param.equals( "localhost" ) )
      {
        out.println("localhost");
        address = new InfrastructureAddress();
      }
      else if (Param.equals( "caAddress" ) && (Parameters.size() == 3))
      {

        String caIP = (String)parametri.next();
        parametri.remove();
        String dirIP = (String)parametri.next();


        out.println( "Connect to CA" );
        address = new InfrastructureAddress( caIP ,  // caIP
                                             dirIP ); // dirIP
      }
      else if (Param.equals( "setOnLine" ) )
      {
        if (address == null) out.println( "Address = null" );
        else
        {
          out.println( "Init onLine value" );
          address.setOnLine( true );
        }
      }
      else if (Param.equals( "setOnLine" ) )
      {
        if (address == null) out.println( "Address = null" );
        else
        {
          out.println( "Set onLine" );
          address.setOnLine( true );
        }
      }
      else if (Param.equals( "setOffLine" ) )
      {
        String newKey = "ProfileLogon";

        out.println( "Set offLine" );
        address.setOnLine( false );

        if ( this.currentDir.getItem( newKey ) == null  )
        {
            Infrastructure pki = new Infrastructure ( address );
            profile.setEntrustInfrastructure( pki );


            this.currentDir.addItem( newKey , new ProfileLoginExplorerItem( profile , newKey , currentDir ) );
            // Toglie dalla directory il corrente men e ne aggiunge uno nuovo.
            this.currentDir.removeItem(this.myKey);
        }

      }
      else if (Param.equals( "setManagerPort" ) && (Parameters.size() == 2))
      {
        if (address == null) out.println( "Address = null" );
        else
        {
          out.println( "Set Manager Port" );
          address.setManagerPort( (new Integer( (String)parametri.next() )).intValue() ); // caPort
        }
      }
      else if (Param.equals( "setDirectoryIP" ) && (Parameters.size() == 2))
      {
        if (address == null) out.println( "Address = null" );
        else
        {
          out.println( "Set Directory IP" );
          address.setDirectoryIP( (String)parametri.next() );  // dirIP
        }
      }
      else if (Param.equals( "setDirectoryPort" ) && (Parameters.size() == 2))
      {
        if (address == null) out.println( "Address = null" );
        else
        {
            out.println( "Set Manager Port" );
            address.setDirectoryPort( (new Integer( (String)parametri.next())).intValue() ); // dirPort
        }
      }
      else if ( Param.equals( "default" ) )
      {
        out.println( "Init Default CA" );
        address = new InfrastructureAddress( InfrastructureAddress.CA_IP, InfrastructureAddress.DIR_IP ); //  NetAddress.CA_IP, NetAddress.DIR_IP
        address.setManagerPort( InfrastructureAddress.DEFAULT_CA_PORT );
        address.setDirectoryPort( InfrastructureAddress.DEFAULT_LDAP_PORT );
      }
      else if ( Param.equals( "showDefault" ) )
      {
        if (address == null) out.println( "Address = null" );
        out.println( "Show Default CA value" );
        out.println( " caIP:     " + InfrastructureAddress.CA_IP +
                     " caPort:   " + InfrastructureAddress.DEFAULT_CA_PORT + "\n" +
                     " ldapIP:   " + InfrastructureAddress.DIR_IP +
                     " ldapPort: " + InfrastructureAddress.DEFAULT_LDAP_PORT  + "\n" );

      }
      else if ( Param.equals( "connect" ) )
      {
        if (address == null) out.println( "Address = null" );
        else
        {
            out.println( "Connect and init CA" );
            address.checkCiphers();
            address.connectDirectory();
            Infrastructure pki = new Infrastructure ( address );
            profile.setEntrustInfrastructure( pki );

            String newKey = "ProfileLogon";
            this.currentDir.addItem( newKey , new ProfileLoginExplorerItem( profile , newKey , currentDir ) );
            // Toglie dalla directory il corrente men e ne aggiunge uno nuovo.
            this.currentDir.removeItem(this.myKey);
        }
      }
      else
      {
        out.println( "Unknown operation: " + Param );  // showDefault
      }

    }
    return address;

    } catch ( Exception e ) { out.println( "Error exception: " + e ); }

    return null;
  }

  public String Help( PrintStream out )
  {
    if (address == null) return "null address";
    out.println( address.toString() );
    return address.toString();
  }
}