package SOMA.security.infrastructure.entrust;

import java.util.StringTokenizer;
import javax.naming.directory.SearchResult;

import SOMA.naming.PlaceID;
import SOMA.naming.NameException;
import SOMA.security.utility.CreateSOMAName;


public class EntrustToSoma extends CreateSOMAName
{
  public EntrustToSoma ()
  {
    super();
  }

  public String getAgentPrincipal ( String dn )
  {
    StringTokenizer token = new StringTokenizer( dn, ",", false );
    String out = "";

    while ( token.hasMoreElements() )
    {
      StringTokenizer stoken = new StringTokenizer( token.nextToken(), ":", false );

      if ( stoken.hasMoreElements() )
        if  ( ! stoken.nextToken().trim().equals("serialNumber") )
        {
          if ( stoken.hasMoreElements() )
            out = out + "/" + stoken.nextToken().trim();
        }
        else if ( stoken.hasMoreElements() )
             {
               stoken.nextToken();
               if ( stoken.hasMoreElements() )
                  out = out + "/" + stoken.nextToken().trim();
             }

    }

    return out;
  }

  public PlaceID getPlaceID (SearchResult in)
        throws NameException
  {
    StringTokenizer st = new StringTokenizer(in.getName() , "=" , false);
    st.nextToken();
    String domain, place = "";

    if ((domain = (new StringBuffer(st.nextToken(" "))).deleteCharAt(0).toString()) == null)
      throw new NameException("Not found domain name.");

    if (st.hasMoreTokens() && (place = st.nextToken("+")) == null)
      place = "";

    return new PlaceID( domain , place );
  }



  public Object clone()
  {
    EntrustToSoma ets = new EntrustToSoma();
    ets.place = (PlaceID) place.clone();
    return ets;
  }

  public boolean equals ( Object obj )
  {
    if( !(obj instanceof EntrustToSoma) )
      return false;
    else
    {
      EntrustToSoma p = (EntrustToSoma) obj;
      return place.equals( p.place );
    }
  }

}