package SOMA.security.infrastructure;

import com.entrust.*;
import com.entrust.util.*;
import com.entrust.x509.directory.*;
import com.entrust.security.provider.*;
import com.entrust.toolkit.*;
import iaik.x509.*;
import iaik.x509.X509CRL;
import iaik.pkcs.pkcs7.*;
import iaik.pkcs.PKCS7CertList;

import java.io.*;
import java.security.Principal;

import SOMA.security.utility.ControlPassword;
import SOMA.security.utility.ControlPasswordException;



/**
 * This class is at a more higher level than the Entrust Java Toolkit.
 * It will give the basic functionality for managing one's profile.
 * @author Luca Ghetti  (modificato da Angelo per gestire l'errore del login nella gui)
 * @version
 */
public class ProfileManager implements InfrastructureConst
{

        protected String pkcs7FileName = System.getProperty( "user.dir" ) +
                                                             File.separator +
                                                             "ProfileManagerTemp";
        protected String extension = ".pkcs7";
        protected int cont = 0;
        protected String CRLFileName = System.getProperty( "user.dir" ) +
                                                             File.separator + "CRLs" +
                                                             File.separator +
                                                             "crl.dat";
        // The pki the profile belongs to
        Infrastructure pki;

        // The managed profile
        EntrustProfile profile;

        public boolean errlogin = false;

        public void setProfile(EntrustProfile profile) {
            this.profile = profile;
        }

        /**
         * Sets the pki
         */

        public void setEntrustInfrastructure(Infrastructure pki) {
                this.pki = pki;
        }

        /**
         * Gets the pki
         */

        public Infrastructure getEntrustInfrastructure() {
                return pki;
        }

        /**
         * Return current EntrustProfile value
         */

        public EntrustProfile getProfile(){
            return profile;
        }

        /**
         * To create the profile as a bean.
         */

        public ProfileManager() {
        }

        /**
         * To create a new profile manager you need an EntrustInfrastructure
         * object.
         * @param pki   is the pki the managed profile belongs to.
         */

        public ProfileManager ( Infrastructure pki )
        {
                this.pki = pki;
        }

        /**
         * This method is used to create a new profile from scratch. One must
         * provide the two secrets needed by the entrust PKI.
         * @param refnum        is the reference number,
         * @param authcode      is the authentication code,
         * @param password      is the profile password,
         * @param filename      the file where the profile is being stored.
         */

        public void createProfile(String refnum, String authcode, String password,String filename)
                throws  java.io.FileNotFoundException,
                        com.entrust.security.exceptions.EntrustBaseException,
                        ControlPasswordException
        {
               // if (ControlPassword.Control(password,ControlPassword.getFileName(filename)))
                //    throw new ControlPasswordException(ControlPassword.toString(password,ControlPassword.getFileName(filename)));

                profile = new EntrustProfile();
                profile.setPKIXVersion(EntrustProfile.PKIXforEntrust4);
                pki.setEntrustProfile( profile );

                pki.createOrRecoverProfile(refnum,authcode,password,profile,EntrustProfile.RSASignature,filename,Infrastructure.CREATE_PROFILE);
        }

        /**
         * This method is used to recover a profile. One must
         * provide the two secrets needed by the entrust PKI.
         * @param refnum        is the reference number,
         * @param authcode      is the authentication code,
         * @param password      is the profile password,
         * @param filename      the file where the profile is being stored.
         */

        public void recoverProfile(String refnum, String authcode, String password,String filename)
                throws  java.io.FileNotFoundException,
                        com.entrust.security.exceptions.EntrustBaseException,
                        ControlPasswordException
        {
                if (ControlPassword.Control(password,ControlPassword.getFileName(filename)))
                    throw new ControlPasswordException(ControlPassword.toString(password,ControlPassword.getFileName(filename)));

                profile = new EntrustProfile();

                profile.setPKIXVersion(EntrustProfile.PKIXforEntrust4);

                // Recover the profile
                pki.createOrRecoverProfile(refnum,authcode,password,profile,EntrustProfile.RSASignature,filename,Infrastructure.RECOVER_PROFILE);
        }


        /**
         * Logs on an existing profile stored in a file.
         * @param filename      the file name,
         * @param password      the password.
         */
        public void logonProfile(String filename, String password)
                throws  java.io.FileNotFoundException,
                        com.entrust.security.exceptions.EntrustBaseException
        {
                this.logonProfile( filename, password, true );
        }


        public void logonProfile(String filename, String password, boolean onLineLogon)
                throws  java.io.FileNotFoundException,
                        com.entrust.security.exceptions.EntrustBaseException
                      //  iaik.pkcs.PKCSParsingException,
                      //  java.io.IOException
        {
          try {
            FileInputStream epf = new FileInputStream(filename);
            if ( pki == null )
                pki = new Infrastructure( new InfrastructureAddress() );
            if ( pki.directoryAddress == null )
                pki.directoryAddress = new InfrastructureAddress();

            pki.directoryAddress.checkCiphers();

            profile = new EntrustProfile();
            profile.logon(epf,new StringBuffer(password));

            if ( onLineLogon && pki != null && pki.directoryAddress != null &&
                 pki.directoryAddress.onLine) // OnLine
            {
                // Update if necessary the random seed
                if (profile.randomSeedRequired()) {
                        FileOutputStream opf = new FileOutputStream(filename);
                        profile.randomSeedUpdate(null);
                        profile.write(opf);
                }
                // Update the keys if necessary
                if (pki != null) pki.updateProfile(profile,filename);
            }
            this.errlogin = false;  // modificato da Angelo
          } catch ( Exception e ) {
                 this.errlogin = true;  // modificato da Angelo
                 System.out.println(" Error creating profile." + e);
                 }

        }

        /**
         *  This method is used for logoff the profile.
         */
        public void logoffProfile() {
            if (profile != null) profile.logoff();
        }


/*********************************************************************************/

        /**
         *  This method is used for signed message
         *   @param data  the data to sign,
         *   @return the signed data.
         **/
        public byte[] signedData (byte[] inData)
                throws  java.security.NoSuchAlgorithmException,
                        iaik.asn1.CodingException,
                        com.entrust.security.exceptions.EntrustBaseException,
                        iaik.pkcs.PKCSException,
                        java.io.IOException
        {
            String tempFileName = getCurrentFileName();

            ETKPKCS7 pkcs7 = new ETKPKCS7(profile);

            SignedData sgn = pkcs7.encodeSignedData(pkcs7.encodeData( inData ),
                                                                      ETKPKCS7.SIGNED_CONTENT );
            //System.out.println ("firma codice begin");
            ContentInfo cntInf = pkcs7.encodeContentInfo(sgn);
            FileOutputStream fos = new FileOutputStream( tempFileName );
            cntInf.writeTo( fos );
            fos.close();

            FileInputStream fis = new FileInputStream( tempFileName );
            byte buffer [] = new byte [fis.available()];
            byte Signature [] = new byte [fis.available()];
            int destPos = 0;
            int len;

            while ( (len = fis.read( buffer ))> 0 )
            {
              System.arraycopy( buffer, 0  ,Signature ,destPos , len );
              destPos = destPos + len;
            }
            fis.close();

            // System.out.println ("firma codice end");
            return Signature;
            //returns this PKCS#7 ContentInfo as DER encoded byte array.

        }


        /**
         *  This method is used for signed message
         *   @param data  the data to sign,
         *   @return the signed data.
         **/
        public void signedData (java.io.InputStream inData,java.io.OutputStream outData)
                throws  java.security.NoSuchAlgorithmException,
                        iaik.asn1.CodingException,
                        com.entrust.security.exceptions.EntrustBaseException,
                        iaik.pkcs.PKCSException,
                        java.io.IOException
        {
            ETKPKCS7 pkcs7 = new ETKPKCS7(profile);
            SignedData sgn = pkcs7.encodeSignedData(new Data(inData), ETKPKCS7.SIGNED_CONTENT);
                                                  // pkcs7.encodeData(inData)
            ContentInfo cntInf = pkcs7.encodeContentInfo(sgn);
            cntInf.writeTo(outData);
            System.out.println ( "       OutData : " + outData.toString() );
        }

        //metodo di verifica utilizzato
        public  boolean verifySignedData ( byte [] in, X509Certificate cert )
                throws  java.security.NoSuchAlgorithmException,
                        iaik.asn1.CodingException,
                        com.entrust.security.exceptions.EntrustBaseException,
                        java.security.SignatureException,
                        iaik.pkcs.PKCSException,
                        java.io.IOException
        {

                String tempFileName = getCurrentFileName();

                if ( cert == null )
                       {
                        System.out.println(" Errore certificato non incluso.");
                        return false;
                       }

                ETKPKCS7 pkcs7 = new ETKPKCS7(profile);
                SignedData signedData = null;

                //SignedData sign=null;
                FileOutputStream fos = new FileOutputStream( tempFileName );
                fos.write(in);
                fos.close();

                FileInputStream fis = new FileInputStream( tempFileName );

                ContentInfo contentInfo = pkcs7.decodeInputStream(fis);
                signedData    = (SignedData) contentInfo.getContent( );
                //X509Certificate certs[] = signedData.getCertificates(); ritorna null
                //System.out.println("      9");

                try {
                     //System.out.println("     12");
                     //tolto da rebecca il 18 novembre PKCS7Content ret = pkcs7.decodeSignedData(sign,cert,data);
                     //PKCS7Content ret = pkcs7.decodeSignedData(sign,certs,null);
                    JNDIDirectory directory;

                    //aggiunto il 25 novembre
                    /*X509CRL[] newCRL = pki.directoryAddress.getCRL(profile);
                    boolean bb = false;
                    for (int i=0; (i<newCRL.length) && (! (bb=(newCRL[i].isRevoked(cert))) ); i++);

                    System.out.println("  Verifica  certificato: " + (bb ? "vero!!!" : "falso!!!"));
                    */

                    if ( pki == null || pki.directoryAddress == null || ! pki.directoryAddress.onLine ) // OffLine
                    {
                        directory = null; // null
                        //aggiunto da rebecca il 23 novembre
                        //X509CRL crl[] = pki.localCertificateCRLList.getCRLList();
                        //if (crl==null) System.out.println ("in localcertlist le crl sono nulle");
                        System.out.println("verifica in locale delle liste di revoca");

                        PKCS7CertList listaCRL = new PKCS7CertList(new FileInputStream(CRLFileName));
                        //System.out.println("loc3");
                        X509CRL[] CRL= listaCRL.getCRLList();
                        //System.out.println("loc4");

                        if (
                             //qui ci andrebbe un for sull'array di crl, per ora per semplicit ne ho uno solo
                             CRL[0].isRevoked( cert ))
                            {System.out.println(" Errore certificato non valido nelle liste locali di CRL");
                            return false;}
                    }
                    else  // OnLine
                    {
                       //System.out.println("      12,1");
                       directory = pki.directoryAddress.connectDirectory();
                       //pkcs7.setVerifier( new ETKCertificateVerifier( directory, profile ) );

                       X509Certificate certs [] = new X509Certificate[1];
                       certs[0] = cert;

                       X509Certificate validCerts[] = pki.getValidCertificates( profile, certs );
                       if ( validCerts == null || validCerts.length<1 )
                       {
                        //aggiunto da rebecca il 23 novembre
                        System.out.println(" Errore certificato non valido.");
                        fis.close();
                        ( new File( tempFileName )).delete();
                        return false;

                       }
                    }

                    //System.out.println("      12,2");
                    //modifica di rebecca al 23 novembre
                    Data ret =(Data)pkcs7.decodeSignedData(signedData,cert,null);

                    //System.out.println("     13");

                } catch (Exception e){ System.out.println("     16");
                                       fis.close();
                                       ( new File( tempFileName )).delete();
                                       return false; }//false;}
                fis.close();
                ( new File( tempFileName )).delete();
                //System.out.println("     17");
                return true; //true;
      }

      /**
         *  This method is used for verify signed message
         *   @param data  the signed data,
         *   @return the data.
         **/
        /* public byte[] verifySignedData ( byte [] in ,X509Certificate cert)
                throws  java.security.NoSuchAlgorithmException,
                        iaik.asn1.CodingException,
                        com.entrust.security.exceptions.EntrustBaseException,
                        java.security.SignatureException,
                        iaik.pkcs.PKCSException,
                        java.io.IOException
        {

                //if ( pki == null || pki.directoryAddress == null || ! pki.directoryAddress.onLine ) // OffLine
                if ( ( pki != null ) &&
                     ( pki.localCertificateCRLList != null ) &&
                     ( pki.localCertificateCRLList.certInCRL( cert ) ) )
                  return null;


                ETKPKCS7 pkcs7 = new ETKPKCS7(profile);
                X509Certificate certs[] = null;
                SignedData sign=null;
                ContentInfo ci = pkcs7.decodeInputStream( new ByteArrayInputStream(in) );
                PKCS7Content cont = pkcs7.decodeContentInfo(ci);

                if (ci.getContentType().equals(iaik.asn1.ObjectID.pkcs7_signedData)) {
                        sign = (SignedData) cont;
                        // Extract the signature cert if there is one
                        certs = sign.getCertificates();
                }
                else if (!ci.getContentType().equals(iaik.asn1.ObjectID.pkcs7_envelopedData))
                       {
                         // System.err.println("Che mi hai dato ?");
                         return null; //false;
                       }

                EnvelopedData env = (EnvelopedData) cont;
                Data data = pkcs7.encodeData("non-PKCS#7");

                try {
                     PKCS7Content ret = pkcs7.decodeSignedData(sign,cert,data);
                     String msg = pkcs7.decodeData(data);  // (Data)ret ???
                     // new java.io.DataOutputStream(out).writeBytes(msg);
                     return msg.getBytes();
                } catch (Exception e){ return null; }  //false;}

                // return null;
                //return certs; //true;
        }
        */

        /**
         *  This method is used for verify signed message
         *   @param data  the signed data,
         *   @return the data.
         metodo non utilizzato
         **/

        public  X509Certificate [] verifySignedData (java.io.InputStream in,java.io.OutputStream out,X509Certificate cert)
                throws  java.security.NoSuchAlgorithmException,
                        iaik.asn1.CodingException,
                        com.entrust.security.exceptions.EntrustBaseException,
                        java.security.SignatureException,
                        iaik.pkcs.PKCSException,
                        java.io.IOException
        {

                //if ( pki == null || pki.directoryAddress == null || ! pki.directoryAddress.onLine ) // OffLine
                /* if ( ( pki != null ) &&
                     ( pki.localCertificateCRLList != null ) &&
                     ( pki.localCertificateCRLList.certInCRL( cert ) ) )
                  return null;
                */


                ETKPKCS7 pkcs7 = new ETKPKCS7(profile);

                X509Certificate certs []= null;

                SignedData signedData = null;

                //SignedData sign=null;

                ContentInfo contentInfo = pkcs7.decodeInputStream(in);
                signedData    = (SignedData) contentInfo.getContent( );
                //modifica di rebecca al 19 novembre
                //PKCS7Content cont=ci.getContent();
               // if (ci.getContent()== null)
                    //System.out.println("      non c'e' contenuto ");
                //PKCS7Content cont = pkcs7.decodeContentInfo(ci);

                //sign = (SignedData) cont;
                //certs= sign.getCertificates();
                certs= signedData.getCertificates();
                /*
                if (ci.getContentType().equals(iaik.asn1.ObjectID.pkcs7_signedData)) {
                        System.out.println("      7");
                        sign = (SignedData) cont;
                        // Extract the signature cert if there is one
                       // certs = sign.getCertificates();
                }
                else if (!ci.getContentType().equals(iaik.asn1.ObjectID.pkcs7_envelopedData))
                       {
                        System.out.println("      8");
                         // System.err.println("Che mi hai dato ?");
                         return null; //false;
                       }
                */
               // System.out.println("      9");

                /* modifica di rebecca al 18 novembre
                EnvelopedData env = (EnvelopedData) cont;
                System.out.println("     10");
                Data data = pkcs7.encodeData("non-PKCS#7");
                System.out.println("     11");
                */
                try {
                     //System.out.println("     12");

                     //tolto da rebecca il 18 novembre PKCS7Content ret = pkcs7.decodeSignedData(sign,cert,data);
                     //PKCS7Content ret = pkcs7.decodeSignedData(sign,certs,null);
                    JNDIDirectory directory;


                    if ( pki == null || pki.directoryAddress == null || ! pki.directoryAddress.onLine ) // OffLine
                       directory = null;
                    else  // OnLine
                       directory = pki.directoryAddress.connectDirectory();

                    //System.out.println("      12,1");
                    pkcs7.setVerifier( new ETKCertificateVerifier( directory, profile ) );

                    //System.out.println("      12,2");
                    Data ret =(Data)pkcs7.decodeSignedData(signedData,null,null);

                    //System.out.println("     13");
                     /* modifica di rebecca al 18 novembre
                     String msg = pkcs7.decodeData(data);  // (Data)ret ???
                     System.out.println("     14");
                     new java.io.DataOutputStream(out).writeBytes(msg);
                     System.out.println("     15");
                     */
                } catch (Exception e){ //System.out.println("     16");
                                       return null; }//false;}

                //System.out.println("     17");
                return certs; //true;


        }

/*************************************************************************************/

        /**
         *  This method is used for encrypt message
         *   @param data  the data to encrypt,
         *   @return the encrypt data,
         *   @param  certificate name to encrypt.
         **/


        public void encryptData(java.io.InputStream in,java.io.OutputStream out,X509Certificate certs)
                throws  java.security.NoSuchAlgorithmException,
                        iaik.pkcs.PKCSException,
                        java.io.IOException

        {
                encryptData(in,out,new X509Certificate[] {certs});
        }

        public void encryptData(java.io.InputStream in,java.io.OutputStream out,X509Certificate certs[])
                throws  java.security.NoSuchAlgorithmException,
                        iaik.pkcs.PKCSException,
                        java.io.IOException

        {
                ETKPKCS7 pkcs7 = new ETKPKCS7(profile);
                Data encdata = new Data(in,0);
//                Data encdata = pkcs7.encodeData(data);
                EnvelopedData envdata = pkcs7.encodeEnvelopedData(encdata,certs);
                ContentInfo continfo = pkcs7.encodeContentInfo(envdata);
                continfo.writeTo(out);
       }


        /**
         *  This method is used for encrypt message
         *   @param data  the data to encrypt,
         *   @return the decrypt data,
         *   @param  certificate name to encrypt.
         **/

        public void decryptData(java.io.InputStream in,java.io.OutputStream out)
                throws  java.security.NoSuchAlgorithmException,
                        iaik.pkcs.PKCSException,
                        java.security.InvalidKeyException,
                        iaik.pkcs.PKCSException,
                        java.io.IOException

        {
               ETKPKCS7 pkcs7 = new ETKPKCS7(profile);
               //   ContentInfo  data type
               (pkcs7.encodeContentInfo(pkcs7.decodeContentInfo(pkcs7.decodeInputStream(in)))).writeTo(out);
        }

/*****************************************************************************/

        public void signAndEncryptData(java.io.InputStream in,java.io.OutputStream out,X509Certificate certs[])
                throws  java.security.NoSuchAlgorithmException,
                        iaik.pkcs.PKCSException,
                        java.io.IOException,
                        iaik.asn1.CodingException,
                        com.entrust.security.exceptions.EntrustBaseException

        {

                ETKPKCS7 pkcs7 = new ETKPKCS7(profile);
                Data encdata = new Data(in,0);
//                Data encdata = pkcs7.encodeData(data);
                EnvelopedData envdata = pkcs7.encodeEnvelopedData(encdata,certs);
                SignedData signed = pkcs7.encodeSignedData(envdata,ETKPKCS7.SIGNED_CONTENT);
                ContentInfo continfo = pkcs7.encodeContentInfo(signed);
                System.out.println("The resulting object is:"+continfo.getContentType());
                continfo.writeTo(out);
        }



        /**
         * Decrypts and verify data.
         * @param in    the input stream containing the DER encoded encrypted data
         * @param out   the output stream where to put the encoded data
         * @return the signing certificates
         */

        public X509Certificate[] decryptAndVerifyData(java.io.InputStream in,java.io.OutputStream out)
                throws  java.security.NoSuchAlgorithmException,
                        iaik.pkcs.PKCSException,
                        java.io.IOException,
                        java.security.InvalidKeyException

        {
                ETKPKCS7 pkcs7 = new ETKPKCS7(profile);

                ContentInfo ci = pkcs7.decodeInputStream(in);

                PKCS7Content cont = pkcs7.decodeContentInfo(ci);
                EnvelopedData env;
                X509Certificate certs[] = null;
                if (ci.getContentType().equals(iaik.asn1.ObjectID.pkcs7_signedAndEnvelopedData)) {
                        SignedData sign = (SignedData) cont;
                        // Extract the signature cert if there is one

                        certs = sign.getCertificates();
                        //if (certs!=null)
                          //      certs = pki.getValidCertificates(profile,certs);

                } else if (!ci.getContentType().equals(iaik.asn1.ObjectID.pkcs7_envelopedData)) {
                        System.err.println("Che mi hai dato ?");
                        return null;
                }

                env = (EnvelopedData) cont;

                Data msg = (Data) pkcs7.decodeEnvelopedData(env);

                new java.io.DataOutputStream(out).writeBytes(pkcs7.decodeData(msg));

                return certs;
        }

        /**
         *   Return the the Distinguish Name
         */
        public String getDistinguishName()
                throws InfrastructureException
        {
            if (this.profile == null) throw new InfrastructureException("Profile is null");
            return ((this.profile.getSigningCertificate()).getSubjectDN()).getName();
        }



        public ETKCertificateVerifier getETKCertificateVerifier()
                throws InfrastructureException
        {
            JNDIDirectory directory = null;

            if (pki == null) throw new InfrastructureException("Infrastructure is null");

            if ((pki.getInfrastructureAddress()).onLine)
            {
                pki.connectDirectory();
                directory = (pki.getInfrastructureAddress()).getDirectory();
            }
            ETKCertificateVerifier verifier = new ETKCertificateVerifier( directory, profile );
            verifier.getContext().setCrlsRequired( (pki.getInfrastructureAddress()).onLine);

            return verifier;
        }


        public String toString()
        {
            try {
                return ( (profile ==  null) ?
                           ("Profile user: logoff\n") :
                           ("Profile user: " + profile.toString()) );
            } catch ( Exception e ) { System.err.println("Cannot read Distinguish Name." + e); }

            return "ProfileManager";
        }

        public void update ( ProfileManager profile )
        {
          // The pki the profile belongs to
          this.pki = profile.pki;

          // The managed profile
          this.profile = profile.profile;
        }


        protected String getCurrentFileName()
        {
            return ( pkcs7FileName + ( cont++ ) + extension );
        }


}