package SOMA.security.infrastructure;

import com.entrust.*;
import com.entrust.util.*;
import com.entrust.security.provider.*;
import com.entrust.toolkit.*;
import com.entrust.x509.X509Exception;

import iaik.x509.*;
import iaik.x509.X509CRL;
import iaik.x509.extensions.*;
import iaik.asn1.*;
import iaik.asn1.structures.*;


import java.security.cert.CRLException;
import java.io.*;
import java.util.*;
import SOMA.security.utility.StringList;

/**

 */

public class InfrastructureAddress implements NetAddress, InfrastructureConst, java.io.Serializable {

        // directory
        com.entrust.x509.directory.JNDIDirectory directory = null;

        javax.naming.directory.DirContext DirectoryContext = null;

        // directory online
        public boolean onLine = true;

        // The CA IP address
        String managerIP = CA_IP;
        // The CA port
        int managerPort = DEFAULT_CA_PORT;

        // The directory IP address
        String directoryIP = DIR_IP;
        // The directory port number
        int directoryPort = DEFAULT_LDAP_PORT;

        // This flag is true only if cyphers aren't yet initialized
       boolean need_ciphers_init = true;


        /**
         * Checks if there is a need to init the ciphers.
         */
      public void checkCiphers() {
                if (need_ciphers_init) {
                        com.entrust.util.Util.initCiphers();
                        need_ciphers_init = false;
                }
        }


        /**
         * Creates an new objects that rappresents an Entrust PKI
         * @param caIP  the ip address or hostname of the entrust authority,
         * @param dirIP the ip address or hostname of the ldap directory
         */

        public InfrastructureAddress(String caIP,String dirIP) {
                this.managerIP = caIP;
                this.directoryIP = dirIP;
        }

        /**
         * Creates an new objects that rappresents an Entrust PKI
         * @param caIP  the ip address or hostname of the entrust authority,
         * @param dirIP the ip address or hostname of the ldap directory
         * @param onLine the directory is on line.
         */

        public InfrastructureAddress(String caIP,String dirIP,boolean onLine) {
                this.managerIP = caIP;
                this.directoryIP = dirIP;
                this.onLine = onLine;
        }

        /**
         * Creates an new objects that rappresents an Entrust PKI
         */

        public InfrastructureAddress() {
                this.managerIP = "localhost";
                this.directoryIP = "localhost";
        }

        /**
         * This method return onLine state
         */

        public synchronized boolean getOnLine(){
            return this.onLine;
        }

         /**
         * This method sets the onLine parameter
         * @param onLine  it's the new value
         */

        public synchronized void setOnLine (boolean onLine){
            this.onLine = onLine;
            if (onLine) this.connectDirectory();
        }



        /**
         * This method sets the CA IP
         * @param caIP  it's the ip address of the CA
         */

        public void setManagerIP(String caIP) {
                this.managerIP = caIP;
        }

        /**
         * Returns the ip address of the entrust CA
         * @return the ip address of the antrust CA
         */

        public String getManagerIP() {
                return managerIP;
        }

        /**
         * This method sets the CA port number
         * @param caPort  it's the port number of the CA
         */

        public void setManagerPort(int caPort) {
                this.managerPort = caPort;
        }

        /**
         * Returns the port number of the entrust CA
         * @return the port address of the antrust CA
         */

        public int getManagerPort() {
                return managerPort;
        }

        /**
         * This method sets the Directore IP
         * @param caIP  it's the ip address of the directory
         */

        public void setDirectoryIP(String dirIP) {
                this.directoryIP = dirIP;
        }

        /**
         * Returns the ip address of the entrust CA
         * @return the ip address of the antrust CA
         */

        public String getDirectoryIP() {
                return directoryIP;
        }

        /**
         * This method sets the directory port number
         * @param caPort  it's the port number of the directory
         */

        public void setDirectoryPort(int dirPort) {
                this.directoryPort = dirPort;
        }

        /**
         * Returns the port number of the  directory
         * @return the port address of the directory
         */

        public int getDirectoryPort() {
                return directoryPort;
        }

        public EntrustManagerTransport getTransport() {
                // Creates the transport object
                 System.out.println ("!!!! Create EntrustManagerTransport managerIP = " + managerIP + "  managerPort = " + managerPort );
                return new EntrustManagerTransport(managerIP,managerPort);
        }

        // return the directory context.
        public javax.naming.directory.DirContext getDirectoryContext(){
            return this.DirectoryContext;
        }

        public com.entrust.x509.directory.JNDIDirectory connectDirectory() {

                // Creates the directory and connects

                this.directory = new com.entrust.x509.directory.JNDIDirectory(directoryIP,directoryPort);
                try {
                        //this.DirectoryContext =
                        this.directory.connect();

                        return this.directory;
                } catch (com.entrust.x509.X509Exception ex) {
                        System.out.println("Error cannot connect to directory: " + ex);
                }
                return null;
        }

        public com.entrust.x509.directory.JNDIDirectory getDirectory() {
                return this.directory;
        }




public X509CRL[] getCRL(EntrustProfile profile)throws CRLException, X509Exception {

 if (this.onLine) checkCiphers();

            X509CRL[] array = null;

            try {

            // prende il certificato di firma
            System.out.println("0");

            X509Certificate cert = profile.getSigningCertificate();
            System.out.println("1");

            // recupera l'estensione "CRLdistributionPoints" dal certificato

            CRLDistributionPoints dist = (CRLDistributionPoints)cert.getExtension(CRLDistributionPoints.oid);

            System.out.println("2");

            // fa un ciclo sui distribution points

            for(Enumeration e = dist.getDistributionPoints(); e.hasMoreElements();) {

            DistributionPoint point = (DistributionPoint)e.nextElement();

            ASN1Type asn1Type = point.getDistributionPointName();

            if(asn1Type instanceof GeneralNames) {

            // fa il cast alla struttura general names

            GeneralNames generalNames = (GeneralNames)asn1Type;

            for(Enumeration n = generalNames.getNames(); n.hasMoreElements();) {

            GeneralName generalName = (GeneralName)n.nextElement();

            // il general name deve essere un directoryName

            if(generalName.getType() == GeneralName.directoryName) {

            Name name = (Name)generalName.getName();

	        System.out.println("\nCRL Distribution Point = " + name.toDirectoryString());

            // estrae il vettore di crl

            array = this.connectDirectory().getCRLs(name.toDirectoryString(), false);

            if(array == null || array.length < 1)

            System.out.println("Non si sono trovete CRL");

            else {

            //for( int i = 0; i < array.length; i++ )
            //System.out.println( "CRL[" + i + "] = " + array[i].toString( true ) );

            }

            } // if

            }  // for

            } // if

            } // for

            } // try

            catch (Exception ecc) {

            System.out.println("Processo di estrazione delle CRL fallito");
            }

            return array;

            }


}

        // Search about directory
        //    DirSearch("o=Wiz,c=US","sn=Fox");


      /*  public StringList DirSearch(java.lang.String searchBase,java.lang.String searchExpr){

            if (this.directory == null) return null;

            try{
              try {
                javax.naming.NamingEnumeration NameList = directory.Search(searchBase,searchExpr);
                StringList StrRtrn = new StringList();

                while (NameList.hasMore())
                   StrRtrn.cons(NameList.next().toString());

                return StrRtrn;

              } catch (com.entrust.x509.X509Exception x509e){
                  System.out.println("Search exception: " + x509e);}
            } catch (javax.naming.NamingException ne){
                System.out.println("Naming exception: " + ne);}

            return null;
        }

        public String toString(){
            return ("\n<directory online: " + this.onLine + " >\n" +
                    "<The CA IP address: " + this.managerIP + " >\n" +
                    "<The CA port: " + this.managerPort + " >\n" +
                    "<The directory IP address: " + this.directoryIP + " >\n" +
                    "<The directory port number: " + this.directoryPort + " >\n");
        }



}

 */