package SOMA.security.infrastructure;

/* This class extends the class PKCS7CertList.
 *  Add same method to access to the directory.
 */

class CertList extends iaik.pkcs.PKCS7CertList implements java.io.Serializable {

    // default constructors
    public CertList()throws
           java.io.IOException,
           iaik.pkcs.PKCSParsingException
    {
    // Default constructor.
        super();
    }

    /**
     * Constructor a CertList with an input; see the method
     *       void writeTo(java.io.OutputStream os) for the output
     * @param is   is the imput stream for load a cerification list.
     */
    public CertList(java.io.InputStream is) throws
           java.io.IOException,
           iaik.pkcs.PKCSParsingException
    {
    //  Creates a PKCS7CertList form an input stream.
        super(is);
    }


    public boolean CertificateInList(iaik.x509.X509Certificate cert){
        iaik.x509.X509Certificate[] certs = this.getCertificateList();
        boolean find = false;

        for (int i=0;!find && i<certs.length; i++)
            find = cert.equals(certs[i]);

        return find;
    }


    public boolean CertificateInList(String dn){
        iaik.x509.X509Certificate[] certs = this.getCertificateList();
        boolean find = false;

        for (int i=0;!find && i<certs.length; i++)
            find = dn.equals(certs[i].getSubjectDN());

        return find;
    }

    public CertList putCertificate(iaik.x509.X509Certificate cert) throws
                java.io.IOException,
                iaik.pkcs.PKCSParsingException {
        iaik.x509.X509Certificate cl[]  = this.getCertificateList();
        iaik.x509.X509Certificate rCL[] = new iaik.x509.X509Certificate[cl.length + (this.CertificateInList(cert) ? 0 : 1)];

        for(int i=0; i<cl.length; i++)
            rCL[i]=cl[i];
        if(! this.CertificateInList(cert)) rCL[rCL.length-1] = cert;

        CertList retcl = new CertList();
        retcl.setCertificateList(rCL);

        return retcl;
    }

    public iaik.x509.X509Certificate getCertificate (String dn){
        iaik.x509.X509Certificate[] certs = this.getCertificateList();
        int i;

        for (i=0;!dn.equals(certs[i].getSubjectDN()) && i<certs.length; i++){}

        if (i >= certs.length) return null;
        else return certs[i];
    }


    public iaik.x509.X509Certificate getCertificate (iaik.x509.X509Certificate cert){
        iaik.x509.X509Certificate[] certs = this.getCertificateList();
        int i;

        for (i=0;!cert.equals(certs[i]) && i<certs.length; i++){}

        if (i >= certs.length) return null;
        else return certs[i];
    }


    public boolean isEmpty() {
        return (((this.getCertificateList()) == null) ||
                ((this.getCertificateList()).length == 0));
    }


    public long length() {
        iaik.x509.X509Certificate[] certs = this.getCertificateList();

        return (certs==null ? 0 : certs.length);
    }


    public boolean certInCRL(iaik.x509.X509Certificate cert) {
        iaik.x509.X509CRL crl[] = this.getCRLList();
        if (crl==null) return false;
        boolean Revoked = false;

        for (int i=0; (i<crl.length) && !(Revoked=crl[i].isRevoked(cert)); i++){}

        return Revoked;
    }


 /** Methods inherited from class iaik.pkcs.PKCS7CertList
  *
  *   X509Certificate[] getCertificateList()
  *        Returns the certificates included in this PKCS7CertList object.
  *   X509CRL[] getCRLList()
  *        Returns the CRLs included in this PKCS7CertList object.
  *   void setCertificateList(X509Certificate[] certificateList)
  *        Set the certificates for this PKCS#7 SignedData object.
  *   void setCRLList(X509CRL[] crlList)
  *        Set the CRLs for this PKCS#7 SignedData object.
  *   byte[] toByteArray()
  *        Returns this PKCS7CertList object as DER encoded byte array.
  *   java.lang.String toString()
  *        Returns a string giving some information about the contents of this
  *        PKCS7CertList object.
  *   void writeTo(java.io.OutputStream os)
  *        Writes the certificate chain to the given output stream.
  *
  *
  ** Methods inherited from class java.lang.Object
  *
  *   equals, getClass, hashCode, notify, notifyAll, wait, wait, wait
  *
  **/
}