package SOMA.security.auth;

import java.util.*;
import java.io.IOException;

import javax.security.auth.*;
import javax.security.auth.callback.*;
import javax.security.auth.login.*;
import javax.security.auth.spi.*;

/*
  Modulo di login.

  Verifico username e password (per ora in modo fittizio) e nel caso
  siano corretti associo i ruoli scelti dall'utente al soggetto da creare.

  L'implementazione e' quella standard di un modulo di login del JAAS

*/

public class SomaUserLoginModule implements LoginModule {

  // initial state
  private Subject subject;
  private CallbackHandler callbackHandler;
  private Map sharedState;
  private Map options;

  // configurable option
  private boolean debug = false;

  // the authentication status
  private boolean succeeded = false;
  private boolean commitSucceeded = false;

  // username and password
  private String username;
  private char[] password;
  private String[] allRoles;
  private String[] selectedRoles;

  //  Principals
  private UserPrincipal user;
  private RolePrincipal[] roles;


  public void initialize(Subject subject, CallbackHandler callbackHandler,Map sharedState, Map options) {

    this.subject = subject;
    this.callbackHandler = callbackHandler;
    this.sharedState = sharedState;
    this.options = options;

    // initialize any configured options
    debug = "true".equalsIgnoreCase((String)options.get("debug"));

  }

  public boolean login() throws LoginException {

    // prompt for a username and password
    if (callbackHandler == null)
      throw new LoginException("Errore: nessun CallBackHandler per richiedere informzioni");

    Callback[] callbacks = new Callback[2];
    callbacks[0] = new NameCallback("Username: ");
    callbacks[1] = new PasswordCallback("Password: ", false);

    try {

      callbackHandler.handle(callbacks);

      username = ((NameCallback)callbacks[0]).getName();
      char[] tmpPassword = ((PasswordCallback)callbacks[1]).getPassword();
      if (tmpPassword == null) {
        // treat a NULL password as an empty password
        tmpPassword = new char[0];
      }
      password = new char[tmpPassword.length];
      System.arraycopy(tmpPassword, 0,password, 0, tmpPassword.length);
      ((PasswordCallback)callbacks[1]).clearPassword();

    } catch (java.io.IOException ioe) {

      throw new LoginException(ioe.toString());

    } catch (UnsupportedCallbackException uce) {

      throw new LoginException("Error: " + uce.getCallback().toString() +
        "impossibile ottenere le informazioni di autenticazione.");
    }

    // print debugging information
    if (debug) {
      System.out.println("\t\t[SomaUserLoginModule] " +
        "user entered username: " +
        username);
      System.out.print("\t\t[SomaUserLoginModule] " +
        "user entered password: ");
      for (int i = 0; i < password.length; i++)
        System.out.print(password[i]);
      System.out.println();
    }

    // verify the username/password
    // per ora sono fittizzi: testUser e testPassword
    if (username.equals("testUser") &&
      password.length == 12 &&
      password[0] == 't' &&
      password[1] == 'e' &&
      password[2] == 's' &&
      password[3] == 't' &&
      password[4] == 'P' &&
      password[5] == 'a' &&
      password[6] == 's' &&
      password[7] == 's' &&
      password[8] == 'w' &&
      password[9] == 'o' &&
      password[10] == 'r' &&
      password[11] == 'd') {

      // authentication succeeded!!!
      if (debug)
        System.out.println("\t\t[SomaUserLoginModule] " +
        "authentication succeeded");

    } else {

      // authentication failed -- clean out state
      if (debug)
        System.out.println("\t\t[SomaUserLoginModule] " +
        "authentication failed");
      succeeded = false;
      username = null;
      for (int i = 0; i < password.length; i++)
        password[i] = ' ';
      password = null;
      throw new FailedLoginException("Password Incorrect");
    }

    // Chiedo i ruoli all'utente
    // per ora getUserRoles() torna dei valori fittizzi
    // con cui si possono comunque fare delle prove.
    allRoles=getUserRoles();

    callbacks = new Callback[1];
    callbacks[0] = new ChoiceCallback("Select Roles",allRoles,0,true);

    try {

        callbackHandler.handle(callbacks);

        int[] selectedIndexes=((ChoiceCallback)callbacks[0]).getSelectedIndexes();

        selectedRoles=new String[selectedIndexes.length];

        for (int i=0;i<selectedIndexes.length;i++)
          selectedRoles[i]=allRoles[selectedIndexes[i]];

    } catch (java.io.IOException ioe) {

      throw new LoginException(ioe.toString());

    } catch (UnsupportedCallbackException uce) {

      throw new LoginException("Error: " + uce.getCallback().toString() +
        "impossibile ottenere le informazioni di autenticazione.");
    }

    succeeded = true;
    return true;


  }

  public boolean commit() throws LoginException {

    if (succeeded == false) {
      return false;
    } else {

      // assume the user we authenticated is the SamplePrincipal
      user=new UserPrincipal(username);
      roles=new RolePrincipal[selectedRoles.length];
      for (int i=0;i<selectedRoles.length;i++)
        roles[i]=new RolePrincipal(selectedRoles[i]);

      final Subject s = subject;
      final UserPrincipal up=user;
      final RolePrincipal[] rp=roles;

      java.security.AccessController.doPrivileged
        (new java.security.PrivilegedAction() {

          public Object run() {
            if (!s.getPrincipals().contains(up))
              s.getPrincipals().add(up);
            for (int i=0;i<rp.length;i++) {
              if (!s.getPrincipals().contains(rp[i]))
                s.getPrincipals().add(rp[i]);
            }
            return null;
          }
        });

      if (debug) {
        System.out.println("\t\t[SomaUserLoginModule] " +
        "added UserPrincipal and RolePrincipals to Subject");
      }

      // in any case, clean out state
      username = null;
      for (int i = 0; i < password.length; i++)
      password[i] = ' ';
      password = null;
      for (int i=0;i<roles.length;i++)
        roles[i]=null;

      commitSucceeded = true;
      return true;

    }

  }

  public boolean abort() throws LoginException {

    if (succeeded == false) {
      return false;
    } else if (succeeded == true && commitSucceeded == false) {

      // login succeeded but overall authentication failed
      succeeded = false;
      username = null;

      if (password != null) {
      for (int i = 0; i < password.length; i++)
        password[i] = ' ';
      password = null;
      for (int i=0;i<roles.length;i++)
        roles[i]=null;
      }
      user=null;
      for (int i=0;i<roles.length;i++)
        roles[i]=null;
    } else {
      // overall authentication succeeded and commit succeeded,
      // but someone else's commit failed
      logout();
    }

    return true;

  }

  public boolean logout() throws LoginException {

    final Subject s = subject;
    final UserPrincipal up=user;
    final RolePrincipal[] rp=roles;

    java.security.AccessController.doPrivileged
      (new java.security.PrivilegedAction() {

        public Object run() {
          s.getPrincipals().remove(up);
          for (int i=0;i<rp.length;i++)
            s.getPrincipals().remove(rp[i]);

          return null;
        }

      });

    succeeded = false;
    succeeded = commitSucceeded;
    username = null;
    if (password != null) {
      for (int i = 0; i < password.length; i++)
        password[i] = ' ';
      password = null;
    }

    user=null;
    for (int i=0;i<roles.length;i++)
      roles[i]=null;

    return true;
  }

  private String[] getUserRoles() {

    String[] allRoles={ "Admin","Printers","Domain Admin","Place Admin","Users" };

    return allRoles;

  }

  // End of Class

}
