package SOMA.network.connection;

import SOMA.explorer.*;
import SOMA.Environment;

/** {@link SOMA.network.connection.ConnectionFactory ConnectionFactory}
* che aggiunge ad un {@link SOMA.explorer.DirExplorerItem menu}
* una nuova {@link SOMA.explorer.ExplorerItem voce} per ogni connessione creata.
* <BR>
* Questa permette all'utente di controllare tutte le connessioni create.
* E' possibile ad esempio interromperle, monitorarne lo stato o spedire messaggi.
*
* @author Livio Profiri
*/
public class ExplorableConnectionFactory extends ConnectionFactory
{
  DirExplorerItem store;
  String prefixString;
  int count;

  /** Costruttore.
  * @param env L'environment del place.
  * @param store Il menu a cui aggiungere le nuove {@link SOMA.explorer.ExplorerItem voci}.
  * @param prefixString Prefisso di ogni {@link SOMA.explorer.ExplorerItem voce} creata.
  */
  public ExplorableConnectionFactory( Environment env, DirExplorerItem store, String prefixString )
  {
    super( env );
    this.store = store;
    this.prefixString = prefixString;
    count = 1;
  }

  /** Crea la connessione ed aggiunge la nuova
  * {@link SOMA.explorer.ExplorerItem voce di menu}.
  */
  public Connection createConnection( java.net.Socket s )
  {
    Connection c = super.createConnection( s );

    store.addItem( prefixString + Integer.toString( count++ ), new ConnectionExplorerItem( c ) );

    return c;
  }
}