package SOMA.network.connection;

import java.util.*;
import java.io.*;

import SOMA.explorer.*;

/** Voce di menu per gestire un {@link SOMA.network.connection.Daemon demone generico}.
* @author Livio Profiri
*/

public class DaemonExplorerItem extends ExplorerItem
{
  /** Il demone da gestire.
  * @serial*/
  public Daemon daemon;

  /** Costruttore. */
  public DaemonExplorerItem( Daemon daemon )
  {
    super( "{start | stop | status}" );
    this.daemon = daemon;
  }

  /** Metodo di esecuzione.
  * <BR>
  * Vengono accettati 3 parametri: <code>start</code>, <code>stop</code>
  * e <code>status</code>.
  */
  public Object Execute( Collection Parameters, PrintStream out )
  {
    if( Parameters.size() == 0 )
    {
      out.println( daemon.toString() );
    }
    else
    {
      String Param = (String)Parameters.iterator().next();
      if( Param.equals( "start" ) )
      {
        try
        {
          daemon.start();
          out.println( "Started-->" + daemon );
        }
        catch( Exception e )
        {
          e.printStackTrace( out );
          return null;
        }
      }
      else if( Param.equals( "stop" ) )
      {
        try
        {
          daemon.stop();
          out.println( "Stopped-->" + daemon );
        }
        catch( Exception e )
        {
          e.printStackTrace( out );
          return null;
        }
      }
      else if( Param.equals( "status" ) )
      {
        out.println( "Status: " +  getStatusString() );
      }
      else
      {
        out.println( "Unknown operation: " + Param );
      }
    }

    return daemon;
  }

  public String Help( PrintStream out )
  {
    out.println( "  start: starts the daemon." );
    out.println( "  stop: stops the daemon." );
    out.println( "  status: returns the daemon's status." );

    return daemon.toString();
  }

  /** Restituisce una stringa che rappresenta lo stato del demone.
  * <BR>
  * Richiama il metodo {@link #StatusToString( int status )}.
  */
  public String getStatusString()
  {
    return daemon.getStatus().toString();
  }

  // Attenzione: accanto alla sintassi del  demona appare il suo stato.
  /** Restituisce la sintassi della voce di menu.
  * <BR>
  * Ridefinita in modo da far apparire lo stato attuale del demone
  * accanto alla sintassi.
  */

  public String getSyntax()
  {
    return Syntax + "  (Status " + getStatusString() + ")";
  }
}