package SOMA.network.connection;

import java.util.*;
import java.io.*;

import SOMA.explorer.*;

/** Aggiunge a {@link SOMA.network.connection.DaemonExplorerItem DaemonExplorerItem}
* la spedizione di messaggi attraverso una
* {@link SOMA.network.connection.Connection connessione}.
*
* @author Livio Profiri
*/
public class ConnectionExplorerItem extends DaemonExplorerItem
{
  public ConnectionExplorerItem( Connection c )
  {
    super( c );
    Syntax = "{start | stop | status | send <Message>}";
  }

  /** Si appoggia alla Execute della superclasse {@link SOMA.network.connection.DaemonExplorerItem DaemonExplorerItem} ed aggiunge solo la
  * funzionalit di spedizione messaggi (<B>send "Message"</B>).
  *
  * @see SOMA.network.connection.SendMessageCommand
  */
  public Object Execute( Collection Parameters, PrintStream out )
  {
    if( Parameters.size() > 1 )
    {
      Iterator i = Parameters.iterator();
      String Param = (String)i.next();
      if( Param.equals( "send" ) )
      {
        SendMessageCommand Message = new SendMessageCommand( (String)i.next() );
        try
        {
          ((Connection)daemon).send( Message );
          out.println( "Message sent: " + Message );
        }
        catch( Exception e )
        {
          e.printStackTrace( out );
          return null;
        }
      }
      else
      {
        out.println( "Unknown operation: " + Param );
      }
      return ((Connection)daemon);
    }
    else
      return super.Execute( Parameters, out );
  }

  public String Help( PrintStream out )
  {
    out.println( "  send <Message>: Sends a <Message>" );

    return super.Help( out );
  }
}