package SOMA.naming.place;

import SOMA.Environment;
import SOMA.naming.*;
import SOMA.network.connection.Command;

import java.util.Hashtable;

/** Comando di aggiornamento della tabella dei place di un {@link PlaceNameService PNS}.
*
* @author Livio Profiri
*/
public class PlaceRefreshCommand extends Command
{
  /** @serial*/
  Hashtable places;
  /** @serial*/
  PlaceID sender;

  /** Costruttore. */
  public PlaceRefreshCommand( Environment env )
  {
    this.places = env.placeNameService.places;
    this.sender = env.placeID;
    System.out.println( toString() + " created." );
  }

  /** Aggiorna la tabella. */
  public void run()
  {
    env.placeNameService.places = places;

    //!!!!!!!!!!!!!!!!!!!!!!!
    // Memorizzo la connessione nel caso in cui sia stata effettuata per spedire il comando.
    env.networkManager.connectionStore.putConnection( sender, ReturnConnection );

    env.out.println( toString() + " completed!!!" );
  }

  public String toString()
  {
    return "PlaceRefreshCommand";
  }

  // Questa classe  stata messa qui per non moltiplicare il numero di file
  // del package e perch  una classe di supporto per l'altra.

  /** Comando di richiesta di refresh della tabella dei place.
  *
  * @author Livio Profiri
  */
  public static class Request extends Command
  {
    /** Viene spedito un {@link PlaceRefreshCommand} con la nuova tabella.
    */
    public void run()
    {
      //Return( new PlaceRefreshCommand( env.placeNameService.places, env.placeID ) );
      Return( new PlaceRefreshCommand( env ) );
    }
  }
}
