package SOMA.naming.place;

import SOMA.naming.*;

/** Memorizza informazioni relative ad un place.
*
* @author Livio Profiri
*/
public class PlaceInfo implements java.io.Serializable
{
  // L'oggetto  sempre costante a meno della connessione: ricrearne uno nuovo per cambiarne propriet.
  /** Identificatore del place.
  * @serial*/
  public final PlaceID placeID;

  /** Indirizzo del {@link SOMA.network.connection.ConnectionServer server} del place.
  * @serial*/
  public final java.net.InetAddress host;

  /** Porta del {@link SOMA.network.connection.ConnectionServer server} del place.
  @serial*/
  public final int port;

  /** Costruttore.
  */
  public PlaceInfo( PlaceID placeID, java.net.InetAddress host, int port )
  {
    this.placeID = placeID;
    this.host = host;
    this.port = port;
  }

  public String toString()
  {
    return "[" + placeID + "-->" + host + " : " + port +"]";
  }

  public boolean equals(Object obj)
  {
    if( !(obj instanceof PlaceInfo) )
    {
      return false;
    }
    else
    {
      PlaceInfo p = (PlaceInfo) obj;
      return placeID.equals( p.placeID ) &&
             host.equals( p.host ) &&
             port == p.port;
    }
  }
}