package SOMA.naming.domain;

import SOMA.naming.*;
import SOMA.network.connection.Command;

//import java.util.Hashtable;

/** Comando di eliminazione di un dominio da un {@link DomainNameService DNS}.
*
* @author Livio Profiri
*/
public class RemoveDomainCommand extends Command
{
// Attenzione: funziona sia per place aggiunti, che per place modificati.
  /** @serial*/
  PlaceID toRemove;

  /** Costruttore. */
  public RemoveDomainCommand( PlaceID toRemove )
  {
    this.toRemove = toRemove;
    System.out.println( toString() + " created " );
  }

  /** Rimuove il dominio. */
  public void run()
  {
    env.domainNameService.removeDomain( toRemove );

    try
    {
      ReturnConnection.stop();
    }
    catch( Exception e )
    {
      e.printStackTrace( env.err );
    }
    env.out.println( toString() + " Completed!" );
  }

  public String toString()
  {
    return "[RemoveDomainCommand " + toRemove + "]";
  }
}
