package SOMA.naming.domain;

import SOMA.naming.*;
import SOMA.network.connection.Command;

//import java.util.Hashtable;

/** Comando di aggiornamento di un {@link DomainNameService DNS}.
*
* <P>Viene aggiunto o modificato un dominio.
*
* @author Livio Profiri
*/
public class PutDomainCommand extends Command
{
  // Attenzione: funziona sia per domain aggiunti, che per domain modificati.
  /** @serial*/
  DomainInfo toPut;

  /** Costruttore. */
  public PutDomainCommand( DomainInfo toPut )
  {
    this.toPut = toPut;
    System.out.println( toString() + " created " );
  }

  /** Aggiunge o modifica il dominio. */
  public void run()
  {
    env.domainNameService.putDomain( toPut );

    try
    {
      ReturnConnection.stop();
    }
    catch( Exception e )
    {
      e.printStackTrace( env.err );
    }
    env.out.println( toString() + " Completed!" );
  }

  public String toString()
  {
    return "[PutDomainCommand " + toPut + "]";
  }
}

