package SOMA.naming.domain;

import SOMA.naming.*;
import SOMA.network.connection.Command;

import java.util.Hashtable;

/** Comando di registrazione di un {@link DomainNameService DNS} presso una altro DNS che diventera' il padre.
*
* @author Livio Profiri
*/
public class DomainRegisterCommand extends Command
{
  /** @serial*/
  DomainInfo myDomainInfo;

  /** Costruttore */
  public DomainRegisterCommand( DomainInfo myDomainInfo )
  {
    this.myDomainInfo = myDomainInfo;
    System.out.println( "Register command " + myDomainInfo + " created " );
  }

  /** Registra il dominio e gli spedisce un {@link DomainRefreshCommand}.
  *
  * <P> Se un dominio con lo stesso nome era gia' presente, gli viene spedito un messaggio di errore.
  */
  public void run()
  {
    env.out.println( "Register command " + myDomainInfo + " running " );
    //env.out.println( "Environment: " + env );

    // Attenzione: la registrazione  immediata e non passa atrtraverso la gerarchia
    //  per se ci sono nomi doppi il dominio rischia di rimanere escluso!

    // Verifico che non sia gi presente il nome!
    if( env.domainNameService.getDomain( myDomainInfo.placeID ) == null )
    {
      env.domainNameService.putDomain( myDomainInfo );
      env.domainNameService.childrenDNS.add( myDomainInfo.placeID );

      //Return( new DomainRefreshCommand( env.placeID, env.domainNameService.domains ));
      Return( new DomainRefreshCommand( env, true ));
    }
    else
    {
      Return( new Command()
        {
          public void run()
          {
            env.err.println( "ERROR: Domain " + myDomainInfo + " already exists!" );
            try
            {
              ReturnConnection.stop();
            }
            catch( Exception f )
            {
              f.printStackTrace( env.err );
            }
          }
        });

      env.err.println( "ERROR: Domain " + myDomainInfo + " already exists!" );
    }
  }
}