package SOMA.naming.domain;

import SOMA.naming.*;
import SOMA.network.connection.Command;
import SOMA.Environment;

import java.util.Hashtable;

/** Comando di aggiornamento della tabella dei domini di un {@link DomainNameService DNS}.
*
* @author Livio Profiri
*/
public class DomainRefreshCommand extends Command
{
  /** @serial*/
  PlaceID fatherDomainID;
  /** @serial*/
  Hashtable domains;
  /** @serial*/
  boolean closeConnection;

  /** Costruttore. */
  public DomainRefreshCommand( Environment env )
  {
    this( env, false );
  }

  /** Costruttore. */
  public DomainRefreshCommand( Environment env, boolean closeConnection )
  {
    this.fatherDomainID = env.placeID;
    this.domains = env.domainNameService.domains;
    this.closeConnection = closeConnection;

    System.out.println( toString() + " (" + domains.size() + " domains) created." );
  }

  /** Aggiorna la tabella e spedisce l'aggiornamento ai figli. */
  public void run()
  {
    //env.out.println( toString() + " running." );
    env.domainNameService.fatherDNS = fatherDomainID;
    env.domainNameService.domains = domains;
    env.domainNameService.sendToChildrenDomains( new DomainRefreshCommand( env ) );

    if( closeConnection )
    {
      try //!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!?????????????????????????
      {
        ReturnConnection.stop();
      }
      catch( Exception e )
      {
        e.printStackTrace( env.err );
      }
    }

    env.out.println( toString() + " completed (" + domains.size() + " domains) !!!" );
  }

  public String toString()
  {
    return "[RefreshCommand from " + fatherDomainID + " disconnect: " + closeConnection + "]";
  }

  // Questa classe  stata messa qui per non moltiplicare il numero di file
  // del package e perch  una classe di supporto per l'altra.

  /** Comando di richiesta di refresh della tabella dei domini.
  *
  * @author Livio Profiri
  */
  public static class Request extends Command
  {
    boolean closeConnection = false;

    public Request()
    {}

    public Request( boolean closeConnection )
    {
      this.closeConnection = closeConnection;
    }

    /** Viene spedito un {@link DomainRefreshCommand} con la nuova tabella.
    */
    public void run()
    {
      Return( new DomainRefreshCommand( env, closeConnection ) );
    }
  }
}
