package SOMA.naming.domain;

import SOMA.naming.*;
import SOMA.naming.place.PlaceInfo;

/** <P>Memorizza informazioni relative ad un dominio.
*
* <P> Le informazioni memorizzate sono le stesse di un {@link SOMA.naming.place.PlaceInfo PlaceInfo},
* quindi non sono stati aggiunti campi. L'unico vincolo in piu' e' che
* {@link SOMA.naming.place.PlaceInfo#placeID placeID} deve rappresentare l'identificatore
* di un default place, ossia deve essere:<BR>
* <code>{@link SOMA.naming.PlaceID#isDomain()} == true</code><BR>
* Questo controllo viene effettuato dai due costruttori.
*
* @author Livio Profiri
*/
public class DomainInfo extends SOMA.naming.place.PlaceInfo
{
  /** Costruttore.
  * <BR>
  * @throws NameException se <code>{@link SOMA.naming.PlaceID#isDomain()} != true</code>
  */
  public DomainInfo( PlaceID domainID, java.net.InetAddress host, int port ) throws NameException
  {
    super( domainID, host, port );

    // Non creo l'istanza se si tratta dell'ID di un place
    if( ! domainID.isDomain() )
      throw( new NameException( "PlaceID " + domainID + " is not a domain ID" ) );
  }

  /** Costruttore: copia tutti i campi di <code>pi</code>.
  * <BR>
  * @throws NameException se <code>{@link SOMA.naming.PlaceID#isDomain()} != true</code>
  */
  public DomainInfo( PlaceInfo pi ) throws NameException
  {
    super( pi.placeID, pi.host, pi.port );

    // Non creo l'istanza se si tratta dell'ID di un place
    if( ! placeID.isDomain() )
      throw( new NameException( "PlaceID " + placeID + " is not a domain ID" ) );
  }
}