package SOMA.naming.domain;

import java.util.*;
import java.io.*;
import java.net.*;

import SOMA.explorer.*;
import SOMA.naming.*;
import SOMA.naming.place.*;
import SOMA.naming.domain.*;

/** Voce di menu per la gestione di un {@link DomainNameService DNS}.
* @author Livio Profiri
*/
public class DNSExplorerItem extends ExplorerItem
{
  /** @serial*/
  DomainNameService dns;

  /** Costruttore. */
  public DNSExplorerItem( DomainNameService dns )
  {
    this.dns = dns;
    Syntax = "{list | put <domain> <host> <port> | del <domain> | register <host> <port> | refresh {<host> <port>} }";
  }

  /** Effettua tutte le possibili operazioni su un PNS.
  * <P>
  * Le opzioni sono:<BR>
  * {list | put "domain" "host" "port" | del "domain" | register "host" "port" | refresh {"host" "port"} }
  */
  public Object Execute( Collection Parameters, PrintStream out )
  {
    try
    {
      Iterator i = Parameters.iterator();

      if( !i.hasNext() )
        return Help();

      String Param = (String)i.next();

      if( Param.equals( "list" ) )
      {
        dns.listDomains( out );
        return dns.domains;
      }
      else if( Param.equals( "put" ) )
      {
        String domain = (String)i.next();
        String host = (String)i.next();
        String portString = (String)i.next();

        try
        {
          int port = Integer.parseInt( portString );
          DomainInfo newDI = new DomainInfo( new PlaceID( domain, "" ),
                                          InetAddress.getByName( host ),
                                          port );
          DomainInfo oldDI = dns.putDomain( newDI );
          out.println( "  Old Domain: " + oldDI );
          out.println( "  New Domain:" + newDI );

          return oldDI;
        }
        catch( Exception e )
        {
          e.printStackTrace( out );
          return null;
        }
      }
      else if( Param.equals( "del" ) )
      {
        try
        {
          PlaceID aDomainID = new PlaceID( (String)i.next() );
          DomainInfo oldDI = dns.removeDomain( aDomainID );

          out.println( "  Domain " + oldDI + " REMOVED" );
          return oldDI;
        }
        catch( Exception e )
        {
          e.printStackTrace( out );
          return null;
        }
      }
      else if( Param.equals( "register" ) )
      {
        String host = (String)i.next();
        String portString = (String)i.next();

        try
        {
          if( dns.register( InetAddress.getByName( host ), Integer.parseInt( portString ) ) )
            out.println( "  Registration COMPLETED!" );
          else
            out.println( "  Registration FAILED!" );
        }
        catch( Exception e )
        {
          e.printStackTrace( out );
        }
        return null;
      }
      else if( Param.equals( "refresh" ) )
      {
        if( i.hasNext() )
        {
          String host = (String)i.next();
          String portString = (String)i.next();

          try
          {
            if( dns.refresh( InetAddress.getByName( host ), Integer.parseInt( portString ) ) )
              out.println( "  Refresh REQUESTED" );
            else
              out.println( "  Refresh FAILED!" );
          }
          catch( UnknownHostException e )
          {
            e.printStackTrace( out );
            return null;
          }
        }
        else
        {
          if( dns.refresh() )
            out.println( "  Refresh REQUESTED" );
          else
            out.println( "  Refresh FAILED!" );
        }

        return null;
      }
    }
    catch( NoSuchElementException e )
    {
      out.println( "Wrong number of parameters" );
    }
    return null;
  }
}