package SOMA.naming;

/** Identificatore di un {@link SOMA.Environment place}.
*
* @author Livio Profiri
*/
public class PlaceID implements java.io.Serializable
{
  /** Dominio di appartenenza.
  * @serial*/
  public final String domain;

  /** Nome del place, unico nell'ambito dello stesso dominio.
  * @serial*/
  public final String place;

  /** Costruisce un identificatore a partire dalle sue componenti. */
  public PlaceID (String domain, String place)
  {
      this.domain = domain;
      this.place = place;
  }

  /** Costruisce un identificatore a partire da una stringa.
  * <BR> E' l'inversa di {@link #toString()}.
  */
  public PlaceID (String s) throws NameException
  {
    java.util.StringTokenizer stok  = new java.util.StringTokenizer( s );

    if( stok.hasMoreTokens() )
      domain = stok.nextToken();
    else
      throw new NameException( "Empty Place Name string" );

    if( stok.hasMoreTokens() )
      place = stok.nextToken();
    else
      place = "";

    if( stok.hasMoreTokens() )
      throw new NameException( "Place Name has more than two tokens" );
  }

  /** Restituisce <code>true</code> se l'identificatore rappresenta un <B>default place</B>.
  * <BR> L'identificatore di un <B>default place</B> ha il campo {@link #place} uguale a "".
  * In altre parole viene specificato solo il dominio.
  */
  public boolean isDomain()
  {
    return place.equals( "" );
  }

  /** Restituisce <code>true</code> se <code>other</code> e' un place dello stesso dominio.
  */
  public boolean sameDomain( PlaceID other )
  {
    return this.domain.equals( other.domain );
  }

  /** Restituisce l'identificatore del <B>default place</B> dello stesso dominio.
  * @see #isDomain()
  */
  public PlaceID getDomainID()
  {
    return new PlaceID( domain, "" );
  }

  /** Restituisce il PlaceID stesso.
  *
  * @see SOMA.mobilePlace.MobilePlaceID
  */
  public PlaceID getHome()
  {
    return this;
  }


  /** Rappresentazione dell'identificatore sotto forma di stringa.
  * <BR> E' l'inversa di {@link #PlaceID(String s) PlaceID(String s)}.
  */
  public String toString()
  {
    return domain + " " + place;
  }

  public boolean equals(Object obj)
  {
    if( !(obj instanceof PlaceID) )
      return false;
    else
    {
      PlaceID p = (PlaceID) obj;
      return domain.equals( p.domain ) &&
             place.equals( p.place);
    }
  }

  public int hashCode()
  {
    return (domain + place).hashCode();
  }

  public Object clone()
  {
    return new PlaceID(domain,place);
  }
}