package SOMA.mobilePlace;

import java.util.*;
import java.io.*;

import SOMA.explorer.*;
import SOMA.naming.*;
import SOMA.naming.domain.*;
import SOMA.network.*;
import SOMA.Environment;

/** Voce di menu per la creazione di un place mobile.
*
* @see SOMA.NewDomainExplorerItem
* @author Livio Profiri
*/
public class NewMobilePlaceExplorerItem extends ExplorerItem
{
  /** @serial*/
  DirExplorerItem dir;

  public NewMobilePlaceExplorerItem( DirExplorerItem dir )
  {
    super( "<domain_name> <place_name> <port>" );
    this.dir = dir;
  }

  /** Metodo di esecuzione del comando: crea il place mobile.
  * <br>
  * I parametri richiesti sono il <B>nome del dominio</B>, il <B>nome del place</B>  e la <B>porta</B> del server del place.<BR>
  * Vengono creati l'{@link SOMA.Environment Environment} del place ed un
  * {@link SOMA.explorer.DirExplorerItem sottomenu} chiamato <B>nome del place</B>.
  */
  public Object Execute( Collection Parameters, PrintStream out )
  {
    if( Parameters.size() == 3 )
    {
      Iterator i = Parameters.iterator();
      PlaceID placeID = new MobilePlaceID( (String)i.next(), (String)i.next() );

      String Param = (String)i.next();

      int port = 0;
      try
      {
        port = Integer.parseInt( Param );
      }
      catch( Exception e )
      {
        out.println( "ERROR: incorrect port number" + Param );
        return null;
      }

      DirExplorerItem placeDir = new DirExplorerItem( placeID.place );
      placeDir.setSyntax( "Mobile Place " + placeDir.getSyntax() ); // Syntax: Place Directory
      Environment env = null;

      try
      {
        env = new MobileEnvironment( placeID, placeDir, port, System.in, out, out );
        dir.addItem( placeDir );

        out.println( "Environment " + env + " created" );
      }
      catch( Exception e )
      {
        e.printStackTrace( out );
      }

      return env;
    }
    return null;
  }

  public String Help( PrintStream out )
  {
    String help = "place_name port: Creates a new mobile place using the specified port.";

    out.println( help );

    return help;
  }
}