package SOMA.mobilePlace;

import SOMA.naming.*;
import SOMA.naming.place.*;
import SOMA.naming.domain.*;
import SOMA.network.connection.Command;

import java.util.Hashtable;

/** Comando di registrazione del {@link MobilePlaceNameService PNS} di un place mobile presso il PNS del default place.
*
* @author Livio Profiri
*/
public class MobilePlaceRegisterCommand extends PlaceRegisterCommand
{
  /** Costruttore */
  public MobilePlaceRegisterCommand ( PlaceInfo myPlaceInfo )
  {
    super( myPlaceInfo );
  }

  /** Registra il place e gli spedisce un {@link PlaceRefreshCommand}.
  *
  * <P> Se un place con lo stesso nome era gia' presente, gli viene spedito un messaggio di errore.
  */
  public void run()
  {
    super.run();

    // Se la registrazione  andata in porto ...
    // (questo  un trucchetto per sapere quale  stato l'esito dell'operazione!
    //
    // Inizializza la posizione del place mobile che si  appena registrato.
    // Spedisce l'elenco dei domini.
    if( myPlaceInfo.equals(
          env.placeNameService.getPlace( myPlaceInfo.placeID )))
    {
      // Aggiorno la posizione del place mobile sulla Home
      env.mobilePlaceManager.putPosition( myPlaceInfo.placeID, env.placeID );

      // Spedisco l'elenco dei place del dominio
      env.networkManager.sendCommand( myPlaceInfo.placeID,
        new DomainRefreshCommand( env ) );

      // Aggiorno la posizione del place mobile sul place mobile
      env.networkManager.sendCommand( myPlaceInfo.placeID,
          new MobilePlaceConnectionCommand.UpdateMobilePlacePositionCommand( env.placeID ) );
    }
  }
}