package SOMA.mobilePlace;

import java.io.*;
import java.util.*;
import java.net.InetAddress;

import SOMA.naming.*;
import SOMA.naming.place.*;
import SOMA.network.connection.*;

/** Servizio di nomi di place mobile, <B>PNS</B>.
* in somasecurity
*
* @see SOMA.naming.place.MobilePlaceNameService
*
* @author Angelo Colantonio
*/

public class MobilePlaceNameServiceSecurity extends PlaceNameService
{
  /** Costruttore.
  * @param env L'environment del place.
  */
  public MobilePlaceNameServiceSecurity( SOMA.Environment env )
  {
    super( env );
  }

  /** Registrazione presso il PNS del default place del dominio.
  *
  * <P>Viene inviato un {@link PlaceRegisterCommand} al default place, individuato dalla coppia
  * <B>host:port</B>.
  */
  public boolean register( InetAddress host, int port )
  {
    boolean answer = env.networkManager.sendCommand( host, port,
      new MobilePlaceRegisterCommandSecurity( env.networkManager.placeInfo ) );

    //env.domainNameService.refresh( host, port );

    return answer;
  }

  /** Elimina tutti i place tranne il place mobile. */
  public void clear()
  {
    places = new Hashtable();

    putPlace( env.networkManager.placeInfo );
  }

  public String toString()
  {
    return "[mobile " + super.toString() + "]";
  }
}