package SOMA.mobilePlace;

import java.io.*;
import java.util.*;

import SOMA.explorer.*;

/** Voce di menu per la gestione di un {@link MobilePlaceManager MPM}.
* @author Livio Profiri
*/
public class MobilePlaceManagerExplorerItem extends ExplorerItem
{
  /** @serial*/
  MobilePlaceManager mpm;

  /** Costruttore. */
  public MobilePlaceManagerExplorerItem( MobilePlaceManager mpm )
  {
    super( "[remove \"MobilePlaceID\"]" );
    this.mpm = mpm;
    //Syntax = "{list | put <place> <host> <port> | del <place> | register <host> <port> | refresh {<host> <port>} }";
  }

  public Object Execute( Collection Parameters, PrintStream out )
  {
    Iterator i = Parameters.iterator();

    if( !i.hasNext() )
    {
      mpm.printStatus( out );
      return mpm;
    }

    try
    {
      String Param = (String)i.next();

      if( Param.equals( "remove" ) )
      {
        MobilePlaceID aPlaceID = new MobilePlaceID( (String)i.next() );

        Object result = mpm.removePosition( aPlaceID );

        if( result != null )
          out.println( "  Place (" + aPlaceID + " --> " + result + ") REMOVED" );
        else
          out.println( "  Place " + aPlaceID + " NOT FOUND" );

        return result;
      }
    }
    catch( Exception e )
    {
      e.printStackTrace( out );
    }

    return null;
  }
}