package SOMA.mobilePlace;

import SOMA.naming.*;
import SOMA.naming.place.*;
import SOMA.network.connection.Command;

import java.util.Hashtable;

/** Comando di registrazione del {@link MobilePlaceNameService PNS} di un place mobile presso il PNS del default place.
* in somasecurity
*
* @author Angelo Colantonio
*/
public class MobilePlaceDisconnectionCommandSecurity extends Command
{
  PlaceID myPlaceID;

  /** Costruttore */
  public MobilePlaceDisconnectionCommandSecurity( PlaceID myPlaceID )
  {
    this.myPlaceID = myPlaceID;
  }

  public void run()
  {
    // Mancano i Controlli di sicurezza!!!

    // Aggiorno la posizione del place mobile sulla home
    env.networkManager.sendCommand( ((MobilePlaceID)(myPlaceID)).getHome(),
        new MobilePlaceConnectionCommandSecurity.UpdateHomePositionCommand(
           myPlaceID,
           MobilePlaceManager.DISCONNECTED ) );

    env.placeNameService.removePlace( myPlaceID );
  }
}