/**  AppletPlace
 *     Applet (eseguibile in una pagina web) che usa un "DelegatePlace" per interfacciarsi
 *     al sito di origine (da cui  stata scaricata l'applet) e comunicare col Place su essa
 *     residente.
 *     PARAMETRI PASSABILI NEL FILE HTML:
 *       Host = indirizzo del computer a cui connettersi (su cui risiede il Place)
 *       Port = numero di porta dello SportelloPlace associato al Place.
 *     @author     Luigi Antenucci
 *     @version    3.3
 *     @language   jdk 1.2.2
 */

package SOMA.gui.remoteapplet;

import SOMA.gui.remotegui.*;  // Ho bisogno solo dei Messaggi (classi che iniziano con "Mess")
import SOMA.naming.PlaceID;

import java.io.File;
import java.net.URL;
import java.net.InetAddress;
import java.util.Vector;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.io.InputStream;
import java.io.IOException;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.border.*;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeSelectionModel;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;


public class AppletPlace extends JApplet {

      /**
       *  COSTANTI PRIVATE per le azioni di comando fatte dai bottoni
       */
  protected static final  String AZIONE_LAUNCH    = "LaunchAgent";
  protected static final  String AZIONE_MODIF     = "ModifRem";
  protected static final  String AZIONE_UPTHR     = "UpDateThree";
  protected static final  String AZIONE_UPWRK     = "UpDateWorker";
  protected static final  String AZIONE_UPPOS     = "UpDatePosit";
  protected static final  String AZIONE_LAFJ      = "L&FJava";
  protected static final  String AZIONE_LAFW      = "L&FWindows";
  protected static final  String AZIONE_LAFM      = "L&FMotif";

  protected static final  String STR_OK       = "(ready)";
  protected static final  String STR_CONTACT  = "Contacting Place...";
  protected static final  String STR_GET_DATA = "Retrieving Place Data...";

      /**
       *  Il percorso del file system da cui caricare le immagini.
       */
  public static final String PICTURE_PATH = "SOMA"+File.separator+"gui"+File.separator+"remoteapplet"+File.separator+"picture"+File.separator;

      /**
       *  La forma del cursore quando  sopra un bottone.
       */
  public static final  Cursor cursoreBottone = new Cursor (Cursor.HAND_CURSOR);

      /**
       *  RIFERIMENTO AL PROPRIO "DelegatePlace".
       */
  protected DelegatePlace mioDelegatePlace;

      /**
       *  L'URL di base dell'Applet.
       */
  protected URL codeBase; //used for applet version only

      /**
       *  Oggetti contenenti del testo dipendente dalla lingua.
       */
  protected JLabel     labAddr, labPort, labPlace;
  protected JTextField txtAddr, txtPort, txtPlace;
  protected JButton    botModif;
  protected ImageIcon  icoPlaDef, icoPlaNor;

  protected JLabel     labAgent, labAgPar;
  protected JComboBox  comAgent;
  protected JTextField txtAgPar;
  protected JButton    botLancia;

  protected JLabel     labPNS, labDNS;
  protected JList      lstPNS, lstDNS;

  protected JLabel     labThread;
  protected JTree      albThread;

  protected JLabel     labWork;
  protected JTable     tabWork;

  protected JLabel     labPos;
  protected JTable     tabPos;

  protected JButton    botUpTh, botUpWo, botUpPo;

  protected JRadioButton radJ, radW, radM;
    
  protected JLabel     debugTxt = null;

  protected String[] tabHeadWo = {"AgentID", "ClassName", "Status"};
  protected String[] tabHeadPo = {"AgentID", "PlaceID"};


      /**
       *  Costruttore dell'applet.
       */
  public AppletPlace () {
    getRootPane().putClientProperty("defeatSystemEventQueueCheck", Boolean.TRUE);
    try {
      UIManager.setLookAndFeel ("javax.swing.plaf.metal.MetalLookAndFeel");
    }
    catch (Exception e) { }
  } //costruttore


  protected void debug (final String messaggio) {
    if (debugTxt != null) {
      SwingUtilities.invokeLater (new Runnable () {
          public void run () {
            debugTxt.setText(messaggio);
          } //run
      }); //invokeLater
    }  
  } //debug

      /**
       *  Metodo per leggere le IMMAGINI da un URL o dal file JAR.
       */
  public ImageIcon caricaImmagineURLoJAR (String nomeFile) {
    ImageIcon imageIcon = null;
    try {

      URL url = null;
      if (codeBase == null)
        codeBase = getCodeBase();   // MEMORIZZA IL "CODE-BASE" UNA VOLTA PER TUTTE

      try {

        // PROVO A CARICARE L'IMMAGINE DAL FILE "JAR"
        InputStream in = AppletPlace.class.getResourceAsStream(PICTURE_PATH+nomeFile);
        final byte[] buffer = toByteArray(in);
        in.close();
        imageIcon = new ImageIcon(buffer);

      }
      catch (Exception e) {
        try {

          // PROVO A CARICARE L'IMMAGINE DALL'URL DI RESIDENZA
          url = new URL(codeBase, PICTURE_PATH+nomeFile);
          imageIcon = new ImageIcon(url);

        }
        catch (Exception e1) { 
          System.out.println(e1.toString());
        }
      }
    }
    catch (Exception e2) {
      System.out.println(e2.toString());
    }
    return imageIcon;
  } //caricaImmagineURLoJAR

      /**
       *  Inizializzazione dell'applet (fatta dopo il caricamento e prima dello "start").
       *  Esegue la creazione dell'interfaccia grafica dell'applet.
       */
  public void init () {

    // CREO IL DELEGATORE PER IL PLACE.
    mioDelegatePlace = new DelegatePlace (this);
    mioDelegatePlace.defPortaPlace (DelegatePlace.PORTA_DEFAULT);

    try {

      // richiedendo URL
      String indHost;
      try {
      	indHost = getParameter("Host");
      }
      catch (Exception e) {
        URL mioURL = getCodeBase();
        indHost = mioURL.getHost();
      }
      mioDelegatePlace.defIndirPlace (indHost);   // IMPOSTO IL DELEGATORE!

      // richiedo N.Porta
      int numPorta;
      try {
        String npStr = getParameter("Port");
        numPorta = Integer.parseInt(npStr);
      }
      catch (Exception e) {
        numPorta = DelegatePlace.PORTA_DEFAULT;
      }
      mioDelegatePlace.defPortaPlace (numPorta);

    }
    catch (Exception e) {
      JLabel scritta = new JLabel("!!! CAN'T OBTAIN THE REMOTE URL !!!");
      Container contentPane = getContentPane();
      contentPane.add (scritta, BorderLayout.NORTH);
    }

    try {

      costruisciInterfacciaGrafica ();
      aggiornaCampiInfo ();
    }
    catch (Exception e) {
      debug(e.toString());
    }

  } //init

      /**
       *  Esecuzione dell'applet.
       */
  public void start ()  { 
    // nulla da fare
  } //start

      /**
       *  Definisce/modifica tutte le frasi mostrate a video (nella GUI).
       */
  protected void costruisciInterfacciaGrafica () {
    Container contentPane = getContentPane();

    icoPlaDef = caricaImmagineURLoJAR ("PlaDef.gif");
    icoPlaNor = caricaImmagineURLoJAR ("PlaNor.gif");

    GridBagLayout GBL     = new GridBagLayout();
    GridBagConstraints CC = new GridBagConstraints();
    contentPane.setLayout (GBL);
    // AGGIUNGO SPAZIO VUOTO ATTORNO AL CONTENT-PANE

    ((JPanel)contentPane).setBorder (BorderFactory.createEmptyBorder(4, 6, 4, 6));   // alto,sx,basso,dx

    debugTxt = new JLabel ();
    CC.gridx = 1;   CC.gridy = 20;
    CC.gridwidth = 3;
    CC.anchor = GridBagConstraints.CENTER;
    GBL.setConstraints (debugTxt, CC);
    contentPane.add (debugTxt);
    debug ("building GUI...");
    Component debUp = Box.createRigidArea (new Dimension(2,2));
    CC.gridx = 1;   CC.gridy = 19;
    GBL.setConstraints (debUp, CC);
    contentPane.add (debUp);
    CC.gridwidth = 1;

    labAddr   = new JLabel();
    labPort   = new JLabel();
    txtAddr   = new JTextField(8);
    txtPort   = new JTextField(5);

    botModif  = new JButton ();

    labPlace  = new JLabel();
    txtPlace  = new JTextField(10);
    txtPlace.setEditable(false);

    labAgent  = new JLabel();
    comAgent  = new JComboBox();
    labAgPar  = new JLabel();
    txtAgPar  = new JTextField(25);
    botLancia = new JButton ();

    labPNS = new JLabel();
    lstPNS = new JList ();
    lstPNS.setEnabled(false);
    lstPNS.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
    JScrollPane scrLstPNS = new JScrollPane(lstPNS);
    scrLstPNS.setPreferredSize (new Dimension(90,120));

    labDNS = new JLabel();
    lstDNS = new JList ();
    lstDNS.setEnabled(false);
    lstDNS.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
    JScrollPane scrLstDNS = new JScrollPane(lstDNS);
    scrLstDNS.setPreferredSize (new Dimension(90,120));

    labThread = new JLabel();
    albThread = new JTree ();
    albThread.getSelectionModel().setSelectionMode (TreeSelectionModel.SINGLE_TREE_SELECTION);
    albThread.setShowsRootHandles (true);
    albThread.putClientProperty("JTree.lineStyle", "Angled");
    albThread.setScrollsOnExpand (true);
    DefaultTreeCellRenderer myRenderer = new DefaultTreeCellRenderer();
    myRenderer.setClosedIcon (caricaImmagineURLoJAR ("ThreadVari.gif"));
    ImageIcon IconaTT = caricaImmagineURLoJAR ("ThreadSolo.gif");
    myRenderer.setOpenIcon   (IconaTT);
    myRenderer.setLeafIcon   (IconaTT);
    myRenderer.setFont (new Font("DialogInput", Font.PLAIN, 12));
    albThread.setCellRenderer (myRenderer);
    JScrollPane scrAlbThread = new JScrollPane (albThread);
    scrAlbThread.setPreferredSize (new Dimension(400,80));

    labWork = new JLabel();
    Object[][] datiNulli = { {"", "", ""} };
    tabWork = new JTable (datiNulli,    //rowData
                          tabHeadWo);   //columnNames
    tabWork.setSelectionMode (ListSelectionModel.SINGLE_SELECTION);
    JScrollPane scrTabWork = new JScrollPane (tabWork);
    scrTabWork.setPreferredSize (new Dimension(210,100));

    labPos = new JLabel();
    tabPos = new JTable (datiNulli,    //rowData
                         tabHeadPo);   //columnNames
    tabPos.setSelectionMode (ListSelectionModel.SINGLE_SELECTION);
    JScrollPane scrTabPos = new JScrollPane (tabPos);
    scrTabPos.setPreferredSize (new Dimension(210,100));

    botUpTh = new JButton();
    botUpWo = new JButton();
    botUpPo = new JButton();

    radJ    = new JRadioButton();
    radW    = new JRadioButton();
    radM    = new JRadioButton();

    ButtonGroup gruppo = new ButtonGroup();
    gruppo.add (radJ);
    gruppo.add (radW);
    gruppo.add (radM);
    radJ.setSelected(true);

    impostaFrasi ();

    ListBottoni bottoniera = new ListBottoni(this, mioDelegatePlace);

    botLancia.setIcon (caricaImmagineURLoJAR ("Agente.gif"));
    botLancia.setCursor (cursoreBottone);
    botLancia.addActionListener (bottoniera);
    botLancia.setActionCommand (AZIONE_LAUNCH);

    botModif.setIcon (caricaImmagineURLoJAR ("GetData.gif"));
    botModif.setCursor (cursoreBottone);
    botModif.addActionListener (bottoniera);
    botModif.setActionCommand (AZIONE_MODIF);

    botUpTh.setIcon (caricaImmagineURLoJAR ("ThreadVari.gif"));
    botUpTh.setCursor (cursoreBottone);
    botUpTh.addActionListener (bottoniera);
    botUpTh.setActionCommand (AZIONE_UPTHR);

    botUpWo.setIcon (caricaImmagineURLoJAR ("UpAgent.gif"));
    botUpWo.setCursor (cursoreBottone);
    botUpWo.addActionListener (bottoniera);
    botUpWo.setActionCommand (AZIONE_UPWRK);

    botUpPo.setIcon (caricaImmagineURLoJAR ("UpPosiz.gif"));
    botUpPo.setCursor (cursoreBottone);
    botUpPo.addActionListener (bottoniera);
    botUpPo.setActionCommand (AZIONE_UPPOS);

    radJ.setCursor (cursoreBottone);
    radJ.addActionListener (bottoniera);
    radJ.setActionCommand(AZIONE_LAFJ);

    radW.setCursor (cursoreBottone);
    radW.addActionListener (bottoniera);
    radW.setActionCommand(AZIONE_LAFW);

    radM.setCursor (cursoreBottone);
    radM.addActionListener (bottoniera);
    radM.setActionCommand(AZIONE_LAFM);

    Component spazio;

    Border borderello = BorderFactory.createBevelBorder(BevelBorder.RAISED,
                                                        Color.white,  Color.lightGray,
                                                        Color.gray,   Color.lightGray);

    Border bordino = BorderFactory.createCompoundBorder(
                       borderello,
                       BorderFactory.createEmptyBorder(2, 2, 2, 2) );   // alto,sx,basso,dx

    Border bordone = BorderFactory.createCompoundBorder(
                       borderello,
                       BorderFactory.createEmptyBorder(10, 8, 10, 8) );   // alto,sx,basso,dx

    JPanel panIP = new JPanel ();                        // INDIRIZZO IP & PORTA
      GridBagLayout GBL1     = new GridBagLayout();
      GridBagConstraints CC1 = new GridBagConstraints();
      panIP.setLayout (GBL1);
      panIP.setBorder (bordone);

      CC1.gridx = 1;   CC1.gridy = 1;
      CC1.anchor = GridBagConstraints.EAST;
      GBL1.setConstraints (labAddr, CC1);
      panIP.add (labAddr);
      CC1.gridx = 2;
      CC1.anchor = GridBagConstraints.WEST;
      GBL1.setConstraints (txtAddr, CC1);
      panIP.add (txtAddr);

      spazio = Box.createRigidArea (new Dimension(2,6));
      CC1.gridx = 2;   CC1.gridy = 2;
      GBL1.setConstraints (spazio, CC1);
      panIP.add (spazio);

      CC1.gridx = 1;   CC1.gridy = 3;
      CC1.anchor = GridBagConstraints.EAST;
      GBL1.setConstraints (labPort, CC1);
      panIP.add (labPort);
      CC1.gridx = 2;
      CC1.anchor = GridBagConstraints.WEST;
      GBL1.setConstraints (txtPort, CC1);
      panIP.add (txtPort);

      spazio = Box.createRigidArea (new Dimension(2,6));
      CC1.gridx = 2;   CC1.gridy = 4;
      GBL1.setConstraints (spazio, CC1);
      panIP.add (spazio);

      CC1.gridx = 1;   CC1.gridy = 5;
      CC1.gridwidth = 2;
      CC1.anchor = GridBagConstraints.CENTER;
      GBL1.setConstraints (botModif, CC1);
      panIP.add (botModif);

    CC.anchor = GridBagConstraints.WEST;
    CC.fill   = GridBagConstraints.BOTH;
    CC.gridx = 1;   CC.gridy = 1;
    GBL.setConstraints (panIP, CC);
    contentPane.add (panIP);

    JPanel panPla = new JPanel ();                       // PLACE ID
      GridBagLayout GBL2     = new GridBagLayout();
      GridBagConstraints CC2 = new GridBagConstraints();
      panPla.setLayout (GBL2);
      panPla.setBorder (bordino);

      CC2.gridx = 1;   CC2.gridy = 1;
      CC2.anchor = GridBagConstraints.EAST;
      GBL2.setConstraints (labPlace, CC2);
      panPla.add (labPlace);
      CC2.gridx = 2;
      CC2.anchor = GridBagConstraints.WEST;
      GBL2.setConstraints (txtPlace, CC2);
      panPla.add (txtPlace);

    CC.gridx = 1;   CC.gridy = 2;
    GBL.setConstraints (panPla, CC);
    contentPane.add (panPla);

    JPanel panAge = new JPanel ();                       // LANCIO AGENTE
      GridBagLayout GBL3     = new GridBagLayout();
      GridBagConstraints CC3 = new GridBagConstraints();
      panAge.setLayout (GBL3);
      panAge.setBorder (bordino);

      CC3.gridx = 1;   CC3.gridy = 1;
      CC3.anchor = GridBagConstraints.EAST;
      GBL3.setConstraints (labAgent, CC3);
      panAge.add (labAgent);
      CC3.gridx = 2;
      CC3.anchor = GridBagConstraints.WEST;
      GBL3.setConstraints (comAgent, CC3);
      panAge.add (comAgent);

      spazio = Box.createRigidArea (new Dimension(2,4));
      CC3.gridx = 1;   CC3.gridy = 3;
      GBL3.setConstraints (spazio, CC3);
      panAge.add (spazio);

      CC3.gridx = 1;   CC3.gridy = 4;
      CC3.anchor = GridBagConstraints.EAST;
      GBL3.setConstraints (labAgPar, CC3);
      panAge.add (labAgPar);
      CC3.gridx = 2;
      CC3.anchor = GridBagConstraints.WEST;
      GBL3.setConstraints (txtAgPar, CC3);
      panAge.add (txtAgPar);

      spazio = Box.createRigidArea (new Dimension(2,4));
      CC3.gridx = 1;   CC3.gridy = 6;
      GBL3.setConstraints (spazio, CC3);
      panAge.add (spazio);

      CC3.gridx = 1;   CC3.gridy = 7;
      CC3.gridwidth = 2;
      CC3.anchor = GridBagConstraints.CENTER;
      GBL3.setConstraints (botLancia, CC3);
      panAge.add (botLancia);

    CC.gridx = 1;   CC.gridy = 3;
    CC.gridwidth = 2;
    GBL.setConstraints (panAge, CC);
    contentPane.add (panAge);
    CC.gridwidth = 1;

    JPanel panXNS = new JPanel ();                       // DNS & PNS
      GridBagLayout GBL4     = new GridBagLayout();
      GridBagConstraints CC4 = new GridBagConstraints();
      panXNS.setLayout (GBL4);
      panXNS.setBorder (bordino);
      CC4.anchor = GridBagConstraints.WEST;
      CC4.fill   = GridBagConstraints.BOTH;

      CC4.gridx = 1;   CC4.gridy = 1;
      GBL4.setConstraints (labDNS, CC4);
      panXNS.add (labDNS);
      CC4.gridx = 1;   CC4.gridy = 2;
      GBL4.setConstraints (scrLstDNS, CC4);
      panXNS.add (scrLstDNS);

      spazio = Box.createRigidArea (new Dimension(6,2));  // spazio tra liste
      CC4.gridx = 2;   CC4.gridy = 1;
      GBL4.setConstraints (spazio, CC4);
      panXNS.add (spazio);

      CC4.gridx = 3;   CC4.gridy = 1;
      GBL4.setConstraints (labPNS, CC4);
      panXNS.add (labPNS);
      CC4.gridx = 3;   CC4.gridy = 2;
      GBL4.setConstraints (scrLstPNS, CC4);
      panXNS.add (scrLstPNS);

    CC.gridx = 2;   CC.gridy = 1;
    CC.gridheight = 2;
    CC.anchor = GridBagConstraints.NORTH;
    GBL.setConstraints (panXNS, CC);
    contentPane.add (panXNS);
    CC.gridheight = 1;

    JPanel panAlbT = new JPanel ();                      // ALBERO THREAD
      panAlbT.setLayout (new BorderLayout());
      panAlbT.setBorder (bordino);

      panAlbT.add (labThread,    BorderLayout.NORTH);
      panAlbT.add (scrAlbThread, BorderLayout.CENTER);

    CC.gridx = 1;   CC.gridy = 4;
    CC.gridwidth  = 2;
    CC.gridheight = 2;
    CC.fill = GridBagConstraints.BOTH;
    GBL.setConstraints (panAlbT, CC);
    contentPane.add (panAlbT);
    CC.gridwidth  = 1;
    CC.gridheight = 1;

    JPanel panTabW = new JPanel ();                      // TABELLA WORKER
      panTabW.setLayout (new BorderLayout());
      panTabW.setBorder (bordino);

      panTabW.add (labWork,    BorderLayout.NORTH);
      panTabW.add (scrTabWork, BorderLayout.CENTER);

    CC.gridx = 3;   CC.gridy = 1;
    CC.gridheight = 2;
    CC.fill = GridBagConstraints.VERTICAL;
    GBL.setConstraints (panTabW, CC);
    contentPane.add (panTabW);
    CC.gridheight = 1;

    JPanel panTabP = new JPanel ();                      // TABELLA POSIZIONI
      panTabP.setLayout (new BorderLayout());
      panTabP.setBorder (bordino);

      panTabP.add (labPos,    BorderLayout.NORTH);
      panTabP.add (scrTabPos, BorderLayout.CENTER);

    CC.gridx = 3;   CC.gridy = 3;
    CC.gridheight = 2;
    CC.fill = GridBagConstraints.VERTICAL;
    GBL.setConstraints (panTabP, CC);
    contentPane.add (panTabP);
    CC.gridheight = 1;

    JPanel panUpdate = new JPanel ();                    // BOTTONI UPDATE & LAF
      GridBagLayout GBL5     = new GridBagLayout();
      GridBagConstraints CC5 = new GridBagConstraints();
      panUpdate.setLayout (GBL5);
      panUpdate.setBorder (bordino);

      CC5.fill = GridBagConstraints.HORIZONTAL;

      CC5.gridx = 1;   CC5.gridy = 1;
      GBL5.setConstraints (botUpWo, CC5);
      panUpdate.add (botUpWo);

      CC5.gridx = 1;   CC5.gridy = 2;
      CC5.fill = GridBagConstraints.HORIZONTAL;
      GBL5.setConstraints (botUpPo, CC5);
      panUpdate.add (botUpPo);

      CC5.gridx = 1;   CC5.gridy = 3;
      GBL5.setConstraints (botUpTh, CC5);
      panUpdate.add (botUpTh);

      spazio = Box.createRigidArea (new Dimension(6,2));
      CC5.gridx = 2;   CC5.gridy = 1;
      GBL5.setConstraints (spazio, CC5);
      panUpdate.add (spazio);

      JPanel panLAF = new JPanel (new GridLayout(3,1));
        panLAF.add(radJ);
        panLAF.add(radW);
        panLAF.add(radM);
      CC5.gridx = 3;   CC5.gridy = 1;
      CC5.gridheight = 3;
      GBL5.setConstraints (panLAF, CC5);
      panUpdate.add (panLAF);

    CC.gridx = 3;   CC.gridy = 5;
    CC.fill = GridBagConstraints.HORIZONTAL;
    CC.anchor = GridBagConstraints.SOUTH;
    GBL.setConstraints (panUpdate, CC);
    contentPane.add (panUpdate);

    debug ("GUI completed");

  } //costruisciInterfacciaGrafica

      /**
       *  Definisce/modifica tutte le frasi mostrate a video (nella GUI).
       */
  protected void impostaFrasi () {

    labAddr  .setText ("Remote Address: ");
    labPort  .setText ("Remote Port No.: ");
    botModif .setText ("Gets all data");

    labPlace .setText ("Place ID: ");

    labAgent .setText ("Agent Class Name: ");
    labAgPar .setText ("Parameters: ");
    botLancia.setText ("Launches Agent");
    
    labPNS   .setText ("known Places:");
    labDNS   .setText ("known Domains:");

    labThread.setText ("Current Remote Threads:");
    labWork  .setText ("Agents Worker:");
    labPos   .setText ("Agents Position:");

    botUpTh  .setText ("Update Threads");
    botUpWo  .setText ("Update Workers");
    botUpPo  .setText ("Update Positions");

    radJ     .setText ("J");
    radW     .setText ("W");
    radM     .setText ("M");

    txtAddr.setToolTipText ("The IP Address of the computer where the Place is installed");
    txtPort.setToolTipText ("The Port Number of the computer where the Place is installed");
    txtPlace.setToolTipText ("This is the Place Identifier");
    txtAgPar.setToolTipText ("Parameters for the agent, as from command line - for a parameter with blanks use the double apexs (\")");
    lstPNS.setToolTipText ("The Places in the Place Name Service");
    lstDNS.setToolTipText ("The Places in the Domain Name Service");
    albThread.setToolTipText ("The Threads that belong to the Place ThreadGroup");
    tabWork.setToolTipText ("The 'workers' (threads that manage the agents) that are running in the Place");
    tabPos.setToolTipText ("The current position of the Agents created by the Place");
    botUpTh.setToolTipText ("Updates the threads list");
    botUpWo.setToolTipText ("Updates the agents workers list");
    botUpPo.setToolTipText ("Updates the agents positions list");
    radJ.setToolTipText ("Set the Java Look & Feel");
    radW.setToolTipText ("Set the Windows Look & Feel");
    radM.setToolTipText ("Set the Motif Look & Feel");
    debugTxt.setToolTipText ("This is the Status Line");
    botModif.setToolTipText ("Use the above data to make the connections with the Place");
    botLancia.setToolTipText ("Launches the agent!");
    comAgent .setToolTipText ("Choose the agent to launch (these are programs in the 'agents directory')");

    invalidate();      // RIVALIDAZIONE DELLA FINESTRA
  } //impostaFrasi

      /**
       *  Aggiorna il contenuto dei "campi di informazioni" della finestra.
       *  Tutti i dati sono richiesti al proprio "DelegatePlace".
       */
  protected void aggiornaCampiInfo () {
    
    debug (STR_CONTACT);

    // RICHIESTA DI DATI "LOCALI"
    final String  strAddr = mioDelegatePlace.cheIndirPlace().getHostAddress();
    final String  strPort = String.valueOf(mioDelegatePlace.chePortaPlace());

    // PRIMA CHIEDE un "ARE YOU ALIVE?"
    try {
      mioDelegatePlace.avvio_AreYouAlive();
    }
    catch (Exception e) {
      debug ("!!! THE REMOTE PLACE DOESN'T RESPOND !!!");
      SwingUtilities.invokeLater (new Runnable () {
          public void run () {
            txtAddr.setText (strAddr);
            txtPort.setText (strPort);
            txtPlace .setText ("???");
            try {
              comAgent.removeAllItems();  // BACO DI SWING SOTTO WIN95
            }
            catch (Exception e2) { }
            txtAgPar .setEnabled (false);
            botLancia.setEnabled (false);
            Vector lstNulla = new Vector();
            lstPNS.setListData(lstNulla);
            lstDNS.setListData(lstNulla);
            botUpTh.setEnabled(false);
            botUpWo.setEnabled(false);
            botUpPo.setEnabled(false);
            albThread.setModel (new DefaultTreeModel(new DefaultMutableTreeNode("?")));
          } //run
      }); //invokeLater
      return;
    }

    debug (STR_GET_DATA);
    // RICHIESTA DI TUTTI I DATI DAL PLACE REMOTO:

    final PlaceID placeID = mioDelegatePlace.chePlaceID ();
    final Vector  agenti  = mioDelegatePlace.cheElencoAgenti ();
    final Vector  vecPNS  = mioDelegatePlace.elencoPlaceInPNS ();
    final Vector  vecDNS  = mioDelegatePlace.elencoDominiiInDNS ();

    // AGGIORNAMENTO DEI DATI A VIDEO

    SwingUtilities.invokeLater (new Runnable () {
        public void run () {

          txtAddr.setText (strAddr);
          txtPort.setText (strPort);
          
          txtPlace.setText (placeID.toString());
          if (placeID.isDomain())
            labPlace.setIcon (icoPlaDef);
          else
            labPlace.setIcon (icoPlaNor);
          
          try {
            comAgent.removeAllItems();
            // BACO DI SWING SOTTO WIN95: genera eccezione se il combo-box  vuoto!
            // NB: sotto Win NT funziona tutto correttamente (no eccezione)
          }
          catch (Exception e) { }
          Enumeration enum = agenti.elements();
          boolean almenoUno = false;
          while (enum.hasMoreElements()) {
            comAgent.addItem ((String)enum.nextElement());
            almenoUno = true;
          }
          try {
            comAgent.setSelectedItem ("TheAgent");
          }
          catch (Exception e2) { }
          txtAgPar .setEnabled (almenoUno);
          botLancia.setEnabled (almenoUno);
          comAgent.revalidate();
          
          lstPNS.setListData(vecPNS);

          lstDNS.setListData(vecDNS);

          botUpTh.setEnabled(true);
          botUpWo.setEnabled(true);
          botUpPo.setEnabled(true);

        } //run
    }); //invokeLater

    aggiornaCampoThread (false);
    aggiornaCampoWorker (false);
    aggiornaCampoPosiz  (false);

    debug (STR_OK);

  } //aggiornaCampiInfo

      /**
       *  Aggiorna solo l'albero dei Thread
       */
  protected void aggiornaCampoThread (boolean stampaMess) {
    if (stampaMess)
      debug (STR_GET_DATA);

    final DefaultTreeModel modelloThread = mioDelegatePlace.alberoPlaceThread ();

    SwingUtilities.invokeLater (new Runnable () {
        public void run () {
          albThread.setModel (modelloThread);
          albThread.revalidate();
        } //run
    }); //invokeLater

    if (stampaMess)
      debug (STR_OK);
  } //aggiornaCampoThread

      /**
       *  Aggiorna solo la tabella dei Worker
       */
  protected void aggiornaCampoWorker (boolean stampaMess) {
    if (stampaMess)
      debug (STR_GET_DATA);

    Vector elencoElencoWorker = mioDelegatePlace.elencoAgentiInEsecuzione ();
    Vector tabHeader = new Vector();
    for (int i=0; i<tabHeadWo.length; i++) {
      tabHeader.addElement (tabHeadWo[i]);
    }
    final DefaultTableModel modTabWork = new DefaultTableModel (elencoElencoWorker,  //data
                                                                tabHeader);          //header
    SwingUtilities.invokeLater (new Runnable () {
        public void run () {
          
          tabWork.setModel (modTabWork);
          TableColumnModel modelloColonne = tabWork.getColumnModel();
          modelloColonne.getColumn(2).setPreferredWidth(20);
          tabWork.setPreferredScrollableViewportSize (new Dimension(230, 120));

          tabWork.revalidate();
        } //run
    }); //invokeLater

    if (stampaMess)
      debug (STR_OK);
  } //aggiornaCampoWorker

      /**
       *  Aggiorna solo la tabella delle Posizioni
       */
  protected void aggiornaCampoPosiz (boolean stampaMess) {
    if (stampaMess)
      debug (STR_GET_DATA);

    Vector elencoElencoPosiz = mioDelegatePlace.elencoPosizioneAgenti ();
    Vector tabHeader = new Vector();
    for (int i=0; i<tabHeadPo.length; i++) {
      tabHeader.addElement (tabHeadPo[i]);
    }
    final DefaultTableModel modTabPos = new DefaultTableModel (elencoElencoPosiz,  //data
                                                               tabHeader);          //header
    SwingUtilities.invokeLater (new Runnable () {
        public void run () {

          tabPos.setModel (modTabPos);
          tabPos.setPreferredScrollableViewportSize (new Dimension(230, 120));

          tabPos.revalidate();
        } //run
    }); //invokeLater

    if (stampaMess)
      debug (STR_OK);
  } //aggiornaCampoPosiz
  

      /**
       *  Metodo per leggere le IMMAGINI se sono in un file JAR.
       *  Copiato pari pari da JavaSoft: "Question of the Week No.76".
       */
  public byte[] toByteArray (final InputStream input) throws IOException {
    int status = 0;
    final int blockSize = 5000;
    int totalBytesRead = 0;
    int blockCount = 1;
    byte[] dynamicBuffer = new byte[blockSize*blockCount];
    final byte[] buffer = new byte[blockSize];

    boolean endOfStream = false;
    while (! endOfStream) {
      int bytesRead = 0;
      if (input.available() != 0) {  // data is waiting so read as much as is available
        status = input.read(buffer);
        endOfStream = (status == -1);
        if (! endOfStream)
          bytesRead = status;
      }
      else {   // no data waiting so use the  one character read to block until
              // data is available or the end of the input stream is reached
        status = input.read();
        endOfStream = (status == -1);
        buffer[0] = (byte)status;
        if (! endOfStream)
          bytesRead = 1;
      }
      if (! endOfStream) {
        if (totalBytesRead+bytesRead > blockSize*blockCount) {  // expand the size of the buffer
          blockCount++;
          final byte[] newBuffer = new byte[blockSize*blockCount];
          System.arraycopy(dynamicBuffer, 0, newBuffer, 0, totalBytesRead);
          dynamicBuffer = newBuffer;
        }
        System.arraycopy(buffer, 0,
        dynamicBuffer, totalBytesRead, bytesRead);
        totalBytesRead += bytesRead;
      }
    }

    // make a copy of the array of the exact length
    final byte[] result = new byte[totalBytesRead];
    if (totalBytesRead != 0)
    System.arraycopy(dynamicBuffer, 0, result, 0, totalBytesRead);

    return result;
  } //toByteArray


      /**
       *  Metodo "main", in caso si volesse eseguire l'applet COME SE fosse un'applicazione.
       *  Non fa altro che creare una finestra in cui inserirvi l'applet.
       */
  public static void main (String[] args) {

    AppletPlace appletPlace = new AppletPlace ();   // CREO UN'ISTANZA DELL'APPLET STESSA

    JFrame mioFrame = new JFrame ("Applet-Place");

    mioFrame.setDefaultCloseOperation (WindowConstants.DO_NOTHING_ON_CLOSE);
    mioFrame.addWindowListener (new WindowAdapter() {
        public void windowClosing (WindowEvent e) {
          System.exit(0);
        }
    });

    Container contentPane = mioFrame.getContentPane();
    contentPane.add (appletPlace);

    appletPlace.init ();
    appletPlace.start ();

    mioFrame.pack();
    mioFrame.setVisible (true);
  } //main


      /**
       *  CLASSE INTERNA PER ASCOLTARE LA PRESSIONE DEI BOTTONI DELLA FINESTRA.
       */
  class ListBottoni implements ActionListener {

    protected AppletPlace     appletPlace;
    protected DelegatePlace DelegatePlace;

    public ListBottoni (AppletPlace appletPlace, DelegatePlace DelegatePlace) {
      this.appletPlace     = appletPlace;
      this.DelegatePlace = DelegatePlace;
    } //costruttore

    public void actionPerformed (ActionEvent e) {

      final String azione = e.getActionCommand();   // PRELEVO L'AZIONE DA ESEGUIRE

      if (azione.equals(AZIONE_LAUNCH)) {
        // PRELEVO I DATI DELL'AGENTE DA LANCIARE
        final String nomeAgente = (String) comAgent.getSelectedItem();
        
        debug ("lanciando "+nomeAgente);
        
        String paramAgente = txtAgPar.getText();
        String[] arrTmp = new String [100];
        StringTokenizer separatore = new StringTokenizer (paramAgente);
        int i = 0;
        while (separatore.hasMoreTokens()) {
          arrTmp[i] = separatore.nextToken();                         //  (li devo mettere in un array!)
          i++;
        } //while
        final String[] arrParam = new String [i];
        for (int j=0; j<i; j++)
          arrParam[j] = arrTmp[j];

        Thread esecutore = new Thread ("Agent Launcher") {
          public void run() {
            try {
              mioDelegatePlace.lanciaAgente (nomeAgente, arrParam,
                                               false, //usaSysClassLoader
                                               true,  //rintracciabile
                                               false  //nonFarloPartire
                                               );
              debug ("agent launch successful ("+nomeAgente+")! "+STR_OK);

              aggiornaCampoWorker (false);
              aggiornaCampoThread (false);
              aggiornaCampoPosiz  (false);
            }
            catch (Exception eccez) {
              debug ("ERROR: "+eccez.toString());
            }

          } //run
        }; //esecutore (Thread)
        esecutore.start();
      }
      else if (azione.equals(AZIONE_MODIF)) {
        Thread esecutore = new Thread ("GetData") {
          public void run() {
            botModif.setEnabled(false);
            debug ("contacting remote host..");
            try {
              InetAddress indIP = InetAddress.getByName (txtAddr.getText());

              int porta = Integer.parseInt (txtPort.getText());

              mioDelegatePlace.defIndirPlace (indIP);
              mioDelegatePlace.defPortaPlace (porta);

              aggiornaCampiInfo ();
            }
            catch (Exception eccc) {
              debug ("ERROR! "+eccc.toString());
              txtAddr.setText (mioDelegatePlace.cheIndirPlace().getHostAddress());
              txtPort.setText (String.valueOf(mioDelegatePlace.chePortaPlace()));
            }
            botModif.setEnabled(true);
          } //run
        }; //esecutore (Thread)
        esecutore.start();
      }
      else if (azione.equals(AZIONE_UPTHR)) {
        Thread esecutore = new Thread ("UpDateThread") {
          public void run() {
            aggiornaCampoThread (true);
          } //run
        }; //esecutore (Thread)
        esecutore.start();
      }
      else if (azione.equals(AZIONE_UPWRK)) {
        Thread esecutore = new Thread ("UpDateWorker") {
          public void run() {
            aggiornaCampoWorker (true);
          } //run
        }; //esecutore (Thread)
        esecutore.start();
      }
      else if (azione.equals(AZIONE_UPPOS)) {
        Thread esecutore = new Thread ("UpDatePosiz") {
          public void run() {
            aggiornaCampoPosiz (true);
          } //run
        }; //esecutore (Thread)
        esecutore.start();
      }
      else if ( azione.equals(AZIONE_LAFJ) ||
                azione.equals(AZIONE_LAFW) ||
                azione.equals(AZIONE_LAFM)    ) {
        String PLAFfete;
        if (azione.equals(AZIONE_LAFJ))
          PLAFfete = "javax.swing.plaf.metal.MetalLookAndFeel";
        else
          if (azione.equals(AZIONE_LAFW))
            PLAFfete = "com.sun.java.swing.plaf.windows.WindowsLookAndFeel";
          else
            PLAFfete = "com.sun.java.swing.plaf.motif.MotifLookAndFeel";
        try {
          UIManager.setLookAndFeel (PLAFfete);

          SwingUtilities.updateComponentTreeUI (AppletPlace.this);  // RIDEFINIZIONE UI
        }
        catch (Exception eieiei) { 
          debug("ERROR: "+eieiei.toString());
        }
      }
      else
        debug ("ERROR: UNKNOWN ACTION '"+azione+"'");
    } //actionPerformed
  } //ListBottoni (classe)

} //AppletPlace