/**  GigiLookAndFeel
 *     Questo  il MIO Look & Feel.
 *     E` molto "caratteristico" e a tratti "psicadelico", ma a me piace molto.
 *     @author     Luigi Antenucci
 *     @version    3.2
 *     @language   jdk 1.2.2
 */

package SOMA.gui.gigi;

import java.awt.Color;
import java.awt.Font;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.plaf.*;
import javax.swing.plaf.metal.*;


public class GigiLookAndFeel extends MetalLookAndFeel {
  public String getID ()                  { return "Gigi"; }
  public String getName ()                { return "Gigi"; }
  public String getDescription()          { return "The Gigi Look and Feel"; }
  public boolean isNativeLookAndFeel()    { return false;  }
  public boolean isSupportedLookAndFeel() { return true;   }


  // SOVRASCRIVO I METODI DI INIZIALIZZAZIONE DELLA CLASSE "BasicLookAndFeel"

  protected void initClassDefaults (UIDefaults table) {
    super.initClassDefaults (table);  // invoca se stesso nella superclasse
  } //initClassDefaults


  protected void initSystemColorDefaults (UIDefaults table) {
    super.initSystemColorDefaults (table);
    String [] colori = {  "control" ,              "#0000FF",
                          "desktop",               "#FFFFFF"
        
                       };
    loadSystemColors (table, colori, false);   // PS: useNative=false
   
    
    /* potrei modificarle:
    String [] colori = {  "desktop",               "#005C5C",
                          "activeCaption",         "#000080",   // TITLE BAR
                          "activeCaptionText",     "#FFFFFF",
                          "activeCaptionBorder",   "#C0C0C0",
                          "inactiveCaption",       "#808080",
                          "inactiveCaptionText",   "#C0C0C0",
                          "inactiveCaptionBorder", "#C0C0C0",
                          "window",                "#FFFFFF",
                          "windowBorder",          "#000000",
                          "windowText",            "#000000",
                          "menu",                  "#C0C0C0",
                          "menuText",              "#000000",
                          "text",                  "#C0C0C0",
                          "textText",              "#000000",
                          "textHighlight",         "#000080",
                          "textHighlightText",     "#FFFFFF",
                          "textInactiveText",      "#808080",
                          "control" ,              "#C0C0C0",      BOTTONI & C.
                          "controlText",           "#000000",
                          "controlHighlight",      "#C0C0C0",
                          "controlLtHighlight",    "#FFFFFF",
                          "controlShadow",         "#808080",
                          "controlDkShadow",       "#000000",
                          "scrollbar",             "#E0E0E0",
                          "info",                  "#FFFFE1",   TIPS
                          "infoText",              "#000000"
    loadSystemColors (table, colori, false);   // PS: useNative=false
    */
  } //initSystemColorDefaults


  protected void initComponentDefaults (UIDefaults table) {
    super.initComponentDefaults (table);  // invoca se stesso nella superclasse

    // ATTENZIONE: TUTTI I COLORI, BORDI, FONT, ecc. DEVONO 
    // ESSERE INCAPSULATI IN UN OGGETTO "UIResource" !!!
    // (per l'esattezza in una SOTTOCLASSE specializzata)
    ColorUIResource colNero   = new ColorUIResource (Color.black);
    ColorUIResource colBianco = new ColorUIResource (Color.white);
    ColorUIResource colBlu    = new ColorUIResource (Color.blue);
    ColorUIResource colVerde  = new ColorUIResource (Color.green);
    ColorUIResource colTurch  = new ColorUIResource (Color.cyan);
    ColorUIResource colGiallo = new ColorUIResource (Color.yellow);
    ColorUIResource colGrigio = new ColorUIResource (Color.gray);
    ColorUIResource colGriCh  = new ColorUIResource (Color.lightGray);
    ColorUIResource colGriSc  = new ColorUIResource (Color.darkGray);
    ColorUIResource colRosso  = new ColorUIResource (Color.red);
    ColorUIResource colMarron = new ColorUIResource (new Color(128,  64,  64));  // R-G-B
    ColorUIResource colOcra   = new ColorUIResource (new Color(128, 128,   0));
    ColorUIResource colViola  = new ColorUIResource (new Color(128,   0, 255));
    ColorUIResource colViolet = new ColorUIResource (new Color(128, 128, 255));
    ColorUIResource colAranc  = new ColorUIResource (new Color(128, 128, 0));

    FontUIResource fontLab    = new FontUIResource ("Serif",       Font.PLAIN, 19);
    FontUIResource fontBot    = new FontUIResource ("SansSerif",   Font.PLAIN, 18);
    FontUIResource fontTxt    = new FontUIResource ("DialogInput", Font.BOLD,  18);
    FontUIResource fontMBar   = new FontUIResource ("Serif",       Font.BOLD,  14);
    FontUIResource fontMenu   = new FontUIResource ("SansSerif",   Font.PLAIN, 14);
    FontUIResource fontTip    = new FontUIResource ("SansSerif",   Font.PLAIN, 12);
    FontUIResource fontTabb   = new FontUIResource ("SansSerif",   Font.PLAIN, 13);
    FontUIResource fontTabl   = new FontUIResource ("DialogInput", Font.PLAIN, 12);
          // FONT POSSIBILI:  Dialog, DialogInput, Monospaced, Serif, SansSerif.

    Border bordoBott = new BorderUIResource.CompoundBorderUIResource( 
                       new BorderUIResource.BevelBorderUIResource (BevelBorder.RAISED,  Color.white,  Color.yellow, 
                                                                                        Color.gray,   Color.lightGray),
                       new BorderUIResource.BevelBorderUIResource (BevelBorder.LOWERED, Color.yellow, Color.white, 
                                                                                        Color.gray,   Color.lightGray) );

    Border bordoTesto= new BorderUIResource.BevelBorderUIResource (BevelBorder.RAISED,  Color.white,  Color.yellow, 
                                                                                        Color.gray,   Color.lightGray);
    Border bordoMBar = new BorderUIResource.BevelBorderUIResource (BevelBorder.RAISED,  Color.white,  new Color(180,64,64),
                                                                                        Color.gray,   new Color(120, 0, 0));
         // NB: i bordi sono di classe "Border" ma sono istanziati a "BorderUIResource"

    Icon icoRadioBut = GigiIconFactory.getRadioButtonIcon();
    Icon icoCheckBox = GigiIconFactory.getCheckBoxIcon();
    Icon icoPallina  = new IconUIResource (new ImageIcon(GigiIconFactory.GIGI_PIC_PATH+"Pallina.gif"));

    Object[] mioDef = { "Panel.background",               colBlu,
                        "Panel.foreground",               colBianco,

                        "OptionPane.background",          colBlu,
                        "OptionPane.messageForeground",   colBianco,

                        "Button.background",              colVerde,
                        "Button.foreground",              colNero,
                        "Button.font",                    fontBot,
                        "Button.border",                  bordoBott,

                        "Label.background",               colBlu,
                        "Label.foreground",               colBianco,
                        "Label.disabledForeground",       colGriCh,
                        "Label.disabledShadow",           colRosso,
                        "Label.font",                     fontLab,

                        "TextField.background",           colTurch,
                        "TextField.foreground",           colNero,
                        "TextField.inactiveForeground",   colBlu,
                        "TextField.selectionBackground",  colGiallo,
                        "TextField.selectionForeground",  colNero,
                        "TextField.font",                 fontTxt,
                        "TextField.border",               bordoTesto,
                        "TextField.caretForeground",      colNero,
                        // NOTA: textField *normale*   ha sfondo=TF.back  testo=TF.fore
                        //       textField.setEnabled  ha sfondo=TF.back  testo=TF.inactive
                        //       textField.setEditable ha sfondo=PANNELLO testo=TF.fore

                        "TextArea.background",            colTurch,
                        "TextArea.foreground",            colNero,
                        "TextArea.inactiveForeground",    colBlu,
                        "TextArea.selectionBackground",   colGiallo,
                        "TextArea.selectionForeground",   colNero,
                        "TextArea.font",                  fontTxt,
                        "TextArea.caretForeground",       colBlu,
//                        "TextArea.border",

                        "RadioButton.background",         colBlu,
                        "RadioButton.foreground",         colBianco,
                        "RadioButton.font",               fontLab,
                        "RadioButton.icon",               icoRadioBut,
                        "RadioButton.disabledText",       colGriCh,

                        "CheckBox.background",            colBlu,
                        "CheckBox.foreground",            colBianco,
                        "CheckBox.font",                  fontLab,
                        "CheckBox.icon",                  icoCheckBox,
                        "CheckBox.disabledText",          colGriCh,

                        "ComboBox.background",            colTurch,
                        "ComboBox.foreground",            colNero,
                        "ComboBox.selectedBackground",    colGiallo,
                        "ComboBox.listBackground",        colVerde,
                        "ComboBox.listForeground",        colNero,
                        "ComboBox.disabledBackground",    colBlu,
                        "ComboBox.disabledForeground",    colGriSc,
                        "ComboBox.font",                  fontTxt,

                        "MenuBar.background",             colMarron,        // MENU
                        "MenuBar.border",                 bordoMBar,

                        "Menu.background",                colMarron,
                        "Menu.foreground",                colBianco,
                        "Menu.acceleratorForeground",     colTurch,
                        "Menu.font",                      fontMBar,

                        "MenuItem.background",            colViola,
                        "MenuItem.foreground",            colBianco,
                        "MenuItem.selectionBackground",   colGiallo,
                        "MenuItem.selectionForeground",   colNero,
                        "MenuItem.acceleratorForeground", colTurch,
                        "MenuItem.font",                  fontMenu,

                        "RadioButtonMenuItem.background", colViola,
                        "RadioButtonMenuItem.foreground", colBianco,
                        "RadioButtonMenuItem.selectionBackground", colGiallo,
                        "RadioButtonMenuItem.selectionForeground", colNero,
                        "RadioButtonMenuItem.font",       fontMenu,
                        "RadioButtonMenuItem.checkIcon",  icoRadioBut,

                        "CheckBoxMenuItem.background",    colViola,
                        "CheckBoxMenuItem.foreground",    colBianco,
                        "CheckBoxMenuItem.selectionBackground", colGiallo,
                        "CheckBoxMenuItem.selectionForeground", colNero,
                        "CheckBoxMenuItem.font",          fontMenu,
                        "CheckBoxMenuItem.checkIcon",     icoCheckBox,

                        "Separator.highlight",            colViolet,
                        "Separator.shadow",               colGriCh,

                        "ToolTip.background",             colGiallo,        // TOOL TIP
                        "ToolTip.foreground",             colBlu,
                        "ToolTip.font",                   fontTip,

                        "Tree.line",                      "Angled",
                        "Tree.background",                colOcra,
                        "Tree.foreground",                colBianco,
                        "Tree.textBackground",            colOcra,
                        "Tree.textForeground",            colBianco,
                        "Tree.selectionBackground",       colGiallo,
                        "Tree.font",                      fontTxt,
 
                        "ScrollBar.background",           colGiallo,
                        "ScrollBar.foreground",           colBlu,
                        "ScrollBar.track",                colBianco,
                        "ScrollBar.trackHighlight",       colBianco,
                        "ScrollBar.thumb",                colVerde,
                        "ScrollBar.thumbHighlight",       colGiallo,
                        "ScrollPane.background",          colTurch,
                        "ScrollPane.foreground",          colVerde,
                        "ScrollPane.border",              bordoTesto,

                        "TabbedPane.background",          colVerde,
                        "TabbedPane.foreground",          colNero,
                        "TabbedPane.font",                fontTabb,
                        "TabbedPane.selected",            colBianco,

                        "Table.background",               colTurch,
                        "Table.foreground",               colNero,
                        "Table.font",                     fontTabl,
                        "Table.selectionBackground",      colGiallo,
                        "Table.selectionForeground",      colNero,
                        "TableHeader.background",         colViolet,
                        "TableHeader.foreground",         colBianco,
                        "TableHeader.font",               fontTabl,

                        "List.background",                colTurch,
                        "List.foreground",                colNero,
                        "List.font",                      fontTxt,
                        "List.selectionBackground",       colGiallo,
                        "List.selectionForeground",       colNero,

                        "ProgressBar.background",         colRosso,
                        "ProgressBar.foreground",         colVerde,
                        "ProgressBar.font",               fontLab,
                        "ProgressBar.backgroundHighlight", colNero,
                        "ProgressBar.foregroundHighlight", colBianco,
                        "ProgressBar.selectionBackground", colBianco,
                        "ProgressBar.selectionForeground", colNero,

                        "Slider.background",              colBlu,
                        "Slider.foreground",              colBianco,
                        "Slider.border",                  bordoTesto,
                        "Slider.horizontalThumbIcon",     icoPallina,
                        "Slider.verticalThumbIcon",       icoPallina
/*
TUTTE LE "RISORSE" DI <<METAL>>:
===============================
"TextField.border"
"TextField.font"
"TextField.caretForeground"
"PasswordField.border"
"PasswordField.font"
"PasswordField.caretForeground"
"TextArea.font"
"TextArea.caretForeground"
"TextPane.selectionBackground"
"TextPane.selectionForeground"
"TextPane.background"
"TextPane.foreground"
"TextPane.font"
"TextPane.caretForeground"
"EditorPane.selectionBackground"
"EditorPane.selectionForeground"
"EditorPane.background"
"EditorPane.foreground"
"EditorPane.font"
"EditorPane.caretForeground"
"TextField.keyBindings"
"PasswordField.keyBindings"
"TextArea.keyBindings"
"TextPane.keyBindings"
"EditorPane.keyBindings"
"Button.background"
"Button.foreground"
"Button.disabledText"
"Button.select"
"Button.border"
"Button.font"
"Button.focus"
"CheckBox.background"
"CheckBox.foreground"
"CheckBox.disabledText"
"Checkbox.select"
"CheckBox.font"
"CheckBox.focus"
"CheckBox.icon"
"RadioButton.background"
"RadioButton.foreground"
"RadioButton.disabledText"
"RadioButton.select"
"RadioButton.icon"
"RadioButton.font"
"RadioButton.focus"
"ToggleButton.background"
"ToggleButton.foreground"
"ToggleButton.select"
"ToggleButton.text"
"ToggleButton.disabledText"
"ToggleButton.disabledSelectedText"
"ToggleButton.disabledBackground"
"ToggleButton.disabledSelectedBackground"
"ToggleButton.focus"
"ToggleButton.border"
"ToggleButton.font"
"FileView.directoryIcon"
"FileView.fileIcon"
"FileView.computerIcon"
"FileView.hardDriveIcon"
"FileView.floppyDriveIcon"
"FileChooser.detailsViewIcon"
"FileChooser.homeFolderIcon"
"FileChooser.listViewIcon"
"FileChooser.newFolderIcon"
"FileChooser.upFolderIcon"
"FileChooser.lookInLabelMnemonic"
"FileChooser.fileNameLabelMnemonic"
"FileChooser.filesOfTypeLabelMnemonic"
"ToolTip.font"
"ToolTip.border"
"ToolTip.background"
"ToolTip.foreground"
"Slider.border"
"Slider.foreground"
"Slider.background"
"Slider.focus"
"Slider.focusInsets"
"Slider.trackWidth"
"Slider.majorTickLength"
"Slider.horizontalThumbIcon"
"Slider.verticalThumbIcon"
"ProgressBar.font"
"ProgressBar.foreground"
"ProgressBar.background"
"ProgressBar.foregroundHighlight"
"ProgressBar.backgroundHighlight"
"ProgressBar.selectionForeground"
"ProgressBar.selectionBackground"
"ProgressBar.border"
"ProgressBar.cellSpacing"
"ProgressBar.cellLength"
"ComboBox.background"
"ComboBox.foreground"
"ComboBox.selectionBackground"
"ComboBox.selectionForeground"
"ComboBox.listBackground"
"ComboBox.listForeground"
"ComboBox.font"
"InternalFrame.icon"
"InternalFrame.border"
"InternalFrame.paletteBorder"
"InternalFrame.paletteTitleHeight"
"InternalFrame.paletteCloseIcon"
"InternalFrame.closeIcon"
"InternalFrame.maximizeIcon"
"InternalFrame.iconizeIcon"
"InternalFrame.minimizeIcon"
"InternalFrame.font"
"DesktopIcon.border"
"DesktopIcon.font"
"DesktopIcon.foreground"
"DesktopIcon.background"
"TitledBorder.font"
"TitledBorder.titleColor"
"TitledBorder.border"
"Label.font"
"Label.background"
"Label.foreground"
"Label.disabledForeground"
"List.focusCellHighlightBorder"
"ScrollBar.background"
"ScrollBar.highlight"
"ScrollBar.shadow"
"ScrollBar.darkShadow"
"ScrollBar.thumb"
"ScrollBar.thumbShadow"
"ScrollBar.thumbHighlight"
"ScrollBar.width"
"ScrollPane.border"
"ScrollPane.background"
"TabbedPane.font"
"TabbedPane.tabAreaBackground"
"TabbedPane.background"
"TabbedPane.foreground"
"TabbedPane.highlight"
"TabbedPane.lightHighlight"
"TabbedPane.darkShadow"
"TabbedPane.focus"
"TabbedPane.selected"
"TabbedPane.selectHighlight"
"TabbedPane.tabAreaInsets"
"Table.font"
"Table.focusCellHighlightBorder"
"Table.focusCellBackground"
"Table.scrollPaneBorder"
"Table.gridColor"
"TableHeader.font"(
"TableHeader.cellBorder"
"MenuBar.border"
"MenuBar.font"
"MenuBar.foreground"
"MenuBar.background"
"Menu.border"
"Menu.borderPainted"
"Menu.font"
"Menu.foreground"
"Menu.background"
"Menu.selectionForeground"
"Menu.selectionBackground"
"Menu.disabledForeground"
"Menu.acceleratorFont"
"Menu.acceleratorForeground"
"Menu.acceleratorSelectionForeground"
"Menu.checkIcon"
"Menu.arrowIcon"
"MenuItem.border"
"MenuItem.borderPainted"
"MenuItem.font"
"MenuItem.foreground"
"MenuItem.background"
"MenuItem.selectionForeground"
"MenuItem.selectionBackground"
"MenuItem.disabledForeground"
"MenuItem.acceleratorFont"
"MenuItem.acceleratorForeground"
"MenuItem.acceleratorSelectionForeground"
"MenuItem.acceleratorDelimiter"
"MenuItem.checkIcon"
"MenuItem.arrowIcon"
"Separator.background"
"Separator.foreground"
"PopupMenu.background"
"PopupMenu.border"
"CheckBoxMenuItem.border"
"CheckBoxMenuItem.borderPainted"
"CheckBoxMenuItem.font"
"CheckBoxMenuItem.foreground"
"CheckBoxMenuItem.background"
"CheckBoxMenuItem.selectionForeground"
"CheckBoxMenuItem.selectionBackground"
"CheckBoxMenuItem.disabledForeground"
"CheckBoxMenuItem.acceleratorFont"
"CheckBoxMenuItem.acceleratorForeground"
"CheckBoxMenuItem.acceleratorSelectionForeground"
"CheckBoxMenuItem.checkIcon"
"CheckBoxMenuItem.arrowIcon"
"RadioButtonMenuItem.border"
"RadioButtonMenuItem.borderPainted"
"RadioButtonMenuItem.font"
"RadioButtonMenuItem.foreground"
"RadioButtonMenuItem.background"
"RadioButtonMenuItem.selectionForeground"
"RadioButtonMenuItem.selectionBackground"
"RadioButtonMenuItem.disabledForeground"
"RadioButtonMenuItem.acceleratorFont"
"RadioButtonMenuItem.acceleratorForeground"
"RadioButtonMenuItem.acceleratorSelectionForeground"
"RadioButtonMenuItem.checkIcon"
"RadioButtonMenuItem.arrowIcon"
"SplitPane.dividerSize"
"Tree.background"
"Tree.font"
"Tree.textForeground"
"Tree.textBackground"
"Tree.selectionForeground"
"Tree.selectionBackground"
"Tree.selectionBorderColor"
"Tree.openIcon"
"Tree.closedIcon"
"Tree.leafIcon"
"Tree.expandedIcon"
"Tree.collapsedIcon"
"Tree.line"
"Tree.hash"
"Tree.rowHeight"
"ToolBar.border"
"ToolBar.background"
"ToolBar.foreground"
"ToolBar.font"
"ToolBar.dockingBackground"
"ToolBar.floatingBackground"
"ToolBar.dockingForeground"
"ToolBar.floatingForeground"



TUTTE LE "RISORSE" DI <<BASIC>>:
===============================
"Button.font"
"Button.background"
"Button.foreground"
"Button.border"
"Button.margin"
"Button.textIconGap"
"Button.textShiftOffset"
"ToggleButton.font"
"ToggleButton.background"
"ToggleButton.foreground"
"ToggleButton.border"
"ToggleButton.margin"
"ToggleButton.textIconGap"
"ToggleButton.textShiftOffset"
"RadioButton.font"
"RadioButton.background"
"RadioButton.foreground"
"RadioButton.border"
"RadioButton.margin"
"RadioButton.textIconGap"
"RadioButton.textShiftOffset"
"RadioButton.icon"
"CheckBox.font"
"CheckBox.background"
"CheckBox.foreground"
"CheckBox.border"
"CheckBox.margin"
"CheckBox.textIconGap"
"CheckBox.textShiftOffset"
"CheckBox.icon"
"ColorChooser.font"
"ColorChooser.background"
"ColorChooser.foreground"
"ColorChooser.swatchesSwatchSize"
"ColorChooser.swatchesRecentSwatchSize"
"ColorChooser.swatchesDefaultRecentColor"
"ColorChooser.rgbRedMnemonic"
"ColorChooser.rgbGreenMnemonic"
"ColorChooser.rgbBlueMnemonic"
"ComboBox.font"
"ComboBox.background"
"ComboBox.foreground"
"ComboBox.selectionBackground"
"ComboBox.selectionForeground"
"ComboBox.disabledBackground"
"ComboBox.disabledForeground"
"FileChooser.cancelButtonMnemonic"
"FileChooser.saveButtonMnemonic"
"FileChooser.openButtonMnemonic"
"FileChooser.updateButtonMnemonic"
"FileChooser.helpButtonMnemonic"
"FileChooser.newFolderIcon"
"FileChooser.upFolderIcon"
"FileChooser.homeFolderIcon"
"FileChooser.detailsViewIcon"
"FileChooser.listViewIcon"
"FileView.directoryIcon"
"FileView.fileIcon"
"FileView.computerIcon"
"FileView.hardDriveIcon"
"FileView.floppyDriveIcon"
"InternalFrame.titleFont"
"InternalFrame.border"
"InternalFrame.icon"
"InternalFrame.maximizeIcon"
"InternalFrame.minimizeIcon"
"InternalFrame.iconifyIcon"
"InternalFrame.closeIcon"
"InternalFrame.activeTitleBackground"
"InternalFrame.activeTitleForeground"
"InternalFrame.inactiveTitleBackground"
"InternalFrame.inactiveTitleForeground"
"DesktopIcon.border"
"Desktop.background"
"Label.font"
"Label.background"
"Label.foreground"
"Label.disabledForeground"
"Label.disabledShadow"
"Label.border"
"List.font"
"List.background"
"List.foreground"
"List.selectionBackground"
"List.selectionForeground"
"List.focusCellHighlightBorder"
"List.border"
"List.cellRenderer"
"MenuBar.font"
"MenuBar.background"
"MenuBar.foreground"
"MenuBar.border"
"MenuItem.font"
"MenuItem.acceleratorFont"
"MenuItem.background"
"MenuItem.foreground"
"MenuItem.selectionForeground"
"MenuItem.selectionBackground"   
"MenuItem.disabledForeground"
"MenuItem.acceleratorForeground"
"MenuItem.acceleratorSelectionForeground"
"MenuItem.acceleratorDelimiter"
"MenuItem.border"
"MenuItem.borderPainted"
"MenuItem.margin"
"MenuItem.checkIcon"
"MenuItem.arrowIcon"
"RadioButtonMenuItem.font"
"RadioButtonMenuItem.acceleratorFont"
"RadioButtonMenuItem.background"
"RadioButtonMenuItem.foreground"
"RadioButtonMenuItem.selectionForeground"
"RadioButtonMenuItem.selectionBackground"
"RadioButtonMenuItem.disabledForeground"
"RadioButtonMenuItem.acceleratorForeground"
"RadioButtonMenuItem.acceleratorSelectionForeground"
"RadioButtonMenuItem.border"
"RadioButtonMenuItem.borderPainted"
"RadioButtonMenuItem.margin"
"RadioButtonMenuItem.checkIcon"
"RadioButtonMenuItem.arrowIcon"
"CheckBoxMenuItem.font"
"CheckBoxMenuItem.acceleratorFont"
"CheckBoxMenuItem.background"
"CheckBoxMenuItem.foreground"
"CheckBoxMenuItem.selectionForeground"
"CheckBoxMenuItem.selectionBackground"
"CheckBoxMenuItem.disabledForeground"
"CheckBoxMenuItem.acceleratorForeground"
"CheckBoxMenuItem.acceleratorSelectionForeground"
"CheckBoxMenuItem.border"
"CheckBoxMenuItem.borderPainted"
"CheckBoxMenuItem.margin"
"CheckBoxMenuItem.checkIcon"
"CheckBoxMenuItem.arrowIcon"
"Menu.font"
"Menu.acceleratorFont"
"Menu.background"
"Menu.foreground"
"Menu.selectionForeground"
"Menu.selectionBackground"
"Menu.disabledForeground"
"Menu.acceleratorForeground"
"Menu.acceleratorSelectionForeground"
"Menu.border"
"Menu.borderPainted"
"Menu.margin"
"Menu.checkIcon"
"Menu.arrowIcon"
"Menu.consumesTabs"
"PopupMenu.font"
"PopupMenu.background"
"PopupMenu.foreground"
"PopupMenu.border"
"OptionPane.font"
"OptionPane.background"
"OptionPane.foreground"
"OptionPane.messageForeground"
"OptionPane.border"
"OptionPane.messageAreaBorder"
"OptionPane.buttonAreaBorder"
"OptionPane.minimumSize"
"OptionPane.errorIcon"
"OptionPane.informationIcon"
"OptionPane.warningIcon"
"OptionPane.questionIcon"
"Panel.font"
"Panel.background"
"Panel.foreground"
"ProgressBar.font"
"ProgressBar.foreground"
"ProgressBar.background"
"ProgressBar.selectionForeground"
"ProgressBar.selectionBackground"
"ProgressBar.border"
"ProgressBar.cellLength"
"ProgressBar.cellSpacing"
"Separator.shadow"
"Separator.highlight"
"Separator.background"
"Separator.foreground"
"ScrollBar.background"
"ScrollBar.foreground"
"ScrollBar.track"
"ScrollBar.trackHighlight"
"ScrollBar.thumb"
"ScrollBar.thumbHighlight"
"ScrollBar.thumbDarkShadow"
"ScrollBar.thumbLightShadow"
"ScrollBar.border"
"ScrollBar.minimumThumbSize"
"ScrollBar.maximumThumbSize"
"ScrollPane.font"
"ScrollPane.background"
"ScrollPane.foreground"
"ScrollPane.border"
"ScrollPane.viewportBorder"
"Viewport.font"
"Viewport.background"
"Viewport.foreground"
"Slider.foreground"
"Slider.background"
"Slider.highlight"
"Slider.shadow"
"Slider.focus"
"Slider.border"
"Slider.focusInsets"
"SplitPane.background"
"SplitPane.highlight"
"SplitPane.shadow"
"SplitPane.border"
"SplitPane.dividerSize"
"TabbedPane.font"
"TabbedPane.background"
"TabbedPane.foreground"
"TabbedPane.lightHighlight"
"TabbedPane.highlight"
"TabbedPane.shadow"
"TabbedPane.darkShadow"
"TabbedPane.focus"
"TabbedPane.textIconGap"
"TabbedPane.tabInsets"
"TabbedPane.selectedTabPadInsets"
"TabbedPane.tabAreaInsets"
"TabbedPane.contentBorderInsets"
"TabbedPane.tabRunOverlay"
"Table.font"
"Table.foreground"
"Table.background"
"Table.selectionForeground"
"Table.selectionBackground"
"Table.gridColor"
"Table.focusCellBackground"
"Table.focusCellForeground"
"Table.focusCellHighlightBorder"
"Table.scrollPaneBorder"
"TableHeader.font"
"TableHeader.foreground"
"TableHeader.background"
"TableHeader.cellBorder"
"TextField.font"
"TextField.background"
"TextField.foreground"
"TextField.inactiveForeground"
"TextField.selectionBackground"
"TextField.selectionForeground"
"TextField.caretForeground"
"TextField.caretBlinkRate"
"TextField.border"
"TextField.margin"
"TextField.keyBindings"
"PasswordField.font"
"PasswordField.background"
"PasswordField.foreground"
"PasswordField.inactiveForeground"
"PasswordField.selectionBackground"
"PasswordField.selectionForeground"
"PasswordField.caretForeground"
"PasswordField.caretBlinkRate"
"PasswordField.border"
"PasswordField.margin"
"PasswordField.keyBindings"
"TextArea.font"
"TextArea.background"
"TextArea.foreground"
"TextArea.inactiveForeground"
"TextArea.selectionBackground"
"TextArea.selectionForeground"
"TextArea.caretForeground"
"TextArea.caretBlinkRate"
"TextArea.border"
"TextArea.margin"
"TextArea.keyBindings"
"TextPane.font"
"TextPane.background"
"TextPane.foreground"
"TextPane.selectionBackground"
"TextPane.selectionForeground"
"TextPane.caretForeground"
"TextPane.caretBlinkRate"
"TextPane.inactiveForeground"
"TextPane.border"
"TextPane.margin"
"TextPane.keyBindings"
"EditorPane.font"
"EditorPane.background"
"EditorPane.foreground"
"EditorPane.selectionBackground"
"EditorPane.selectionForeground"
"EditorPane.caretForeground"
"EditorPane.caretBlinkRate"
"EditorPane.inactiveForeground"
"EditorPane.border"
"EditorPane.margin"
"EditorPane.keyBindings"
"TitledBorder.font"
"TitledBorder.titleColor"
"TitledBorder.border"
"ToolBar.font"
"ToolBar.background"
"ToolBar.foreground"
"ToolBar.dockingBackground"
"ToolBar.dockingForeground"
"ToolBar.floatingBackground"
"ToolBar.floatingForeground"
"ToolBar.border"
"ToolBar.separatorSize"
"ToolTip.font"
"ToolTip.background"
"ToolTip.foreground"
"ToolTip.border"
"Tree.font"
"Tree.background"
"Tree.foreground"
"Tree.hash"
"Tree.textForeground"
"Tree.textBackground"
"Tree.selectionForeground"
"Tree.selectionBackground"
"Tree.selectionBorderColor"
"Tree.editorBorder"
"Tree.leftChildIndent"
"Tree.rightChildIndent"
"Tree.rowHeight"
"Tree.scrollsOnExpand"
"Tree.openIcon"
"Tree.closedIcon"
"Tree.leafIcon"
"Tree.expandedIcon"
"Tree.collapsedIcon"
"Tree.changeSelectionWithFocus"
"Tree.drawsFocusBorderAroundIcon"
*/
                    };
    table.putDefaults (mioDef);
  } //initComponentDefaults


/*
  public static void main (String[] args) {
    // PER DEBUGGING
    UIManager.installLookAndFeel ("Gigi", "SOMA.gui.gigi.GigiLookAndFeel");
    try {     // IMPOSTA IL LOOK & FEEL
      UIManager.setLookAndFeel ("SOMA.gui.gigi.GigiLookAndFeel");
//      UIManager.setLookAndFeel ("SOMA/gui/gigi/GigiLookAndFeel");    // Win95: Class Not Found
//      UIManager.setLookAndFeel ("SOMA"+java.io.File.separator+"gui"+java.io.File.separator+"gigi"+java.io.File.separator+"GigiLookAndFeel");   // Win95: Class Not Found
//      UIManager.setLookAndFeel ("GigiLookAndFeel");     // Win95: Class Not Found

//"javax.swing.plaf.metal.MetalLookAndFeel";
//"com.sun.java.swing.plaf.windows.WindowsLookAndFeel";
//"com.sun.java.swing.plaf.motif.MotifLookAndFeel";

    } 
    catch (Exception e) { 
      System.err.println ("ERROR defining the Look & Feel");
      System.err.println ("      "+e);
    }
    JFrame F = new JFrame ();
    F.addWindowListener(new java.awt.event.WindowAdapter() {
                            public void windowClosing(java.awt.event.WindowEvent e) { 
                              System.exit(0); 
                            }
                        });
    F.setDefaultCloseOperation(WindowConstants.DO_NOTHING_ON_CLOSE);
    java.awt.Container contentPane = F.getContentPane();
    JPanel pan = new JPanel();
    pan.add (new JButton("  Bottone  "));
    pan.add (new JRadioButton("Radio"));
    pan.add (new JCheckBox("Check"));
    pan.add (new JTextField("TextField"));
    JTextField disab  = new JTextField("TextField Non Abilitato");
    disab.setEnabled (false);
    pan.add (disab);
    JTextField disatt = new JTextField("TextField Non Editabile");
    disatt.setEditable (false);
    pan.add (disatt);

    contentPane.add (pan);
    F.pack();
    F.setVisible (true);          // INFINE RENDO VISIBILE LA FINESTRA
  } //main
*/

} //GigiLookAndFeel