package SOMA.security.infrastructure.explorer;

import java.util.*;
import java.io.*;

import SOMA.explorer.ExplorerItem;
import SOMA.explorer.DirExplorerItem;
import SOMA.security.infrastructure.ProfileManager;
import SOMA.security.infrastructure.updatePolicy.*;

/** Voce di menu per la gestione dell'aggiornamento della directory.
*
* @author Luca Ghetti
*/
public class PolicyUpdateItem extends ExplorerItem
{
  /** @serial*/
  public ProfileManager profile;

  public PrintStream out = System.out;

  //  Current directory.
  public DirExplorerItem currentDir;

  private UpdateDaemon updateDaemon = null;

  Object myKey;

  public PolicyUpdateItem( Object myKey, ProfileManager profile, DirExplorerItem currentDir )
  {
    super( "[ CurrentPolicy | Update | LastUpdate | SetCRLDatePolicy | SetTimePolicy seconds | Daemon (start/stop) ]" );
    this.currentDir = currentDir;
    this.profile = profile;
    this.myKey = myKey;
    // default update
    this.updateDaemon = new UpdateDaemon ( (new UpdatePolicyCRL(profile.getEntrustInfrastructure())),
                                           profile.getEntrustInfrastructure(),
                                           out );
  }

  public Object Execute( Collection Parameters, PrintStream out )
  {
    if( Parameters.size() == 0 )
    {
      out.println( currentDir.toString() + "\n" + profile.toString() );
    }
    else
    {
      Iterator parametri = Parameters.iterator();
      String Param = (String)parametri.next();
      parametri.remove();

      // Return current update policy
      if( Param.equals( "CurrentPolicy" ) ) // && (parametri.size() == 0 ) )
       out.println("Current Policy: " + ( updateDaemon == null ? "null" : updateDaemon.toString() ));

           // Update the local certificate
      else if( Param.equals( "Update" ) )
      {
        try {
           out.println( "Update local certificate."  );
           profile.getEntrustInfrastructure().updateCertificateCRLList();
        } catch ( Exception e ) { out.println( "Error reading Distinguish Name: " + e ); }
      }
      else if( Param.equals( "LastUpdate" ) ) // && (parametri.size() == 3 ) )
      {
        out.println( "Last update" );
        try {

            Date CRLDate = profile.getEntrustInfrastructure().getCertificateCRLList().getLastCRLUpdate();
            Date CertDate = profile.getEntrustInfrastructure().getCertificateCRLList().getLastCertUpdate();
            out.println("CRL last update = " + CRLDate.toString());
            out.println("CRL last update = " + CertDate.toString());
        } catch (Exception e) { out.println("Error getting date update."); }
      }
      else if( Param.equals( "SetCRLDatePolicy" ) ) // && (Parameters.size() == 3 ) )
      {
        out.println( "Set CRL date update policy" );
        try {
          this.updateDaemon.setUpdatePolicy ( (new UpdatePolicyCRL(profile.getEntrustInfrastructure() )) );
                                             // profile.getEntrustInfrastructure(),
                                             // out );
        } catch (Exception e) { out.println("Error getting date update."); }
      }
      else if ( Param.equals( "SetTimePolicy" ) && (Parameters.size() == 1 ) )
      {
        out.println( "Set time update policy" );
        try {

          this.updateDaemon.setUpdatePolicy (
                  (new UpdatePolicyTime ( (new Long( (String)parametri.next() )).longValue() )) );
        } catch (Exception e) { out.println("Error getting date update."); }
      }
      else if( Param.equals( "Daemon" ) && ( Parameters.size() == 1 ) )  // (start/stop)
      {
        try {
          if ( this.updateDaemon == null ) out.println("Update deamon not created.");
          else
            if ( ((String) parametri.next()).toLowerCase().equals("start") )
            {
              this.updateDaemon.start();
              out.println( "Update deamon started."  );
            }
            else
            {
              this.updateDaemon.stop();
              out.println( "Update deamon stopped."  );
            }
        } catch ( Exception e ) { out.println( "Error running update deamon: " + e ); }
      }


      else
      {
        out.println( "Unknown operation: " + Param );
      }
    }

    return profile;
  }

  public UpdateDaemon getUpdateDaemon () {  // Aggiunta da Luigi Antenucci
    return updateDaemon;
  }

  public String Help( PrintStream out )
  {
    out.println( profile.toString() );
    return profile.toString();
  }
}