/**  TextAreaOutputStream2
 *     Pannello per visualizzare un OutputStream.
 *     Ho preso spunto da quanto fatto da Livio in "SOMA.output.JTextAreaOutputStream", ma
 *     ho abolito la "scrollbar" e la dimensione delle righe.
 *     Chi la usa passa una JTextArea, che dovr essere posta in una JScrollPane e quindi il 
 *     tutto visualizzato a video!
 *     @author     Luigi Antenucci (dopo Livio Profiri)
 *     @version    2.0
 *     @language   jdk 1.2.2
 */

package SOMA.gui;

import java.io.OutputStream;
import java.io.ByteArrayOutputStream;
import java.io.Serializable;
import java.io.IOException;
import java.awt.*;
import javax.swing.*;


public class TextAreaOutputStream2 extends OutputStream implements Serializable {

      /**
       *  La JTextArea a cui si fa riferimento per stampare lo stream di output
       */
  public JTextArea miaTextArea;

      /**
       *  Costruttore.
       */
  public TextAreaOutputStream2 (JTextArea miaTextArea) {
    this.miaTextArea = miaTextArea;
  } //costruttore


  public void write (int b) throws IOException {
    ByteArrayOutputStream Out = new ByteArrayOutputStream();
    Out.write (b);
    StampaSuTextArea (Out.toString());
    Out.close ();
  } //write

  public void write (byte[] b) throws IOException {
    ByteArrayOutputStream Out = new ByteArrayOutputStream();
    Out.write (b);
    StampaSuTextArea (Out.toString());
    Out.close ();
  } //write

  public void write (byte[] b, int off, int len) throws IOException {
    ByteArrayOutputStream Out = new ByteArrayOutputStream();
    Out.write (b, off, len);
    StampaSuTextArea (Out.toString());
    Out.close ();
  } //write

      /**
       *  Metodo interno, usato da tutte le "write"
       */
  protected void StampaSuTextArea (final String str) {
    SwingUtilities.invokeLater (new Runnable () {
          public void run () {
            miaTextArea.append (str);
          } //run
    }); //invokeLater
  } //StampaSuTextArea


/*
  public static void main (String[] args) {
    // PER DEBUGGING
    JFrame F = new JFrame ();
    F.addWindowListener(new java.awt.event.WindowAdapter() {
                        public void windowClosing(java.awt.event.WindowEvent e) { 
                          System.exit(0); 
                        }
                    });
    Container contentPane = F.getContentPane();

    JTextArea  miaTextArea  = new JTextArea();
    JScrollPane scroll = new JScrollPane (miaTextArea);
    TextAreaOutputStream2 mioOut = new TextAreaOutputStream2 (miaTextArea);
    byte[] testo = {65, 66, 67, 68, 69, 70};
    try {
      mioOut.write (testo);
    }
    catch (Exception e) { }

    contentPane.add (scroll, BorderLayout.CENTER);
    F.pack();
    F.setVisible (true);          // INFINE RENDO VISIBILE LA FINESTRA
  } //main
*/

} //TextAreaOutputStream2