/**  OiDialogoi
 *     @author     Luigi Antenucci
 *     @version    1.1
 *     @language   jdk 1.2.2
 */

package SOMA.gui;

import SOMA.gui.lingua.Lingua;

import java.io.PrintWriter;
import java.awt.Font;
import javax.swing.JFrame;
import javax.swing.JTextArea;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;


public class OiDialogoi {

      /**
       *  ICONE CARICATE UNA VOLTA SOLA ALLA CREAZIONE DELLA CLASSE!
       */
  protected static final ImageIcon IMG_ICO_ICONETTA = new ImageIcon(Finestra.PICTURE_PATH+"Esclamativo.gif");

      /**
       *  Tengo traccia se  la prima volta che si esegue un metodo di questa classe.
       *  Infatti la "prima volta" - e solo in quell'occasione - va caricato il file di lingua.
       */
  protected static boolean primaVolta = true;


        /**
       *  Carico il file di lingua di questa classe
       */
  protected static void CaricaMiaLingua () {
    if (primaVolta) {
      Lingua.caricaFileDiLingua (OiDialogoi.class);
      primaVolta=false;
    }
  } //CaricaMiaLingua

      /**
       *  Mostro una finestra di dialogo per l'eccezione passata (con scritta "errore").
       *  La finestra di dialogo non sar "modale" a nessuna finestra.
       */
  public static void mostraErrore (Exception eccezione) {
    mostraErrore (eccezione, null);
  } //mostraErrore

      /**
       *  Mostro una finestra di dialogo per l'eccezione passata (con scritta "errore").
       *  La finestra di dialogo sar "modale" alla finestra (JFrame) passata.
       */
  public static void mostraErrore (final Exception eccezione, final JFrame mioFrame) {
    if (primaVolta) 
      CaricaMiaLingua();
    Object[] opzioni = {Lingua.frase("OID_BOT_OK"), Lingua.frase("OID_BOT_STACK")};

    String messaggio = ": "+eccezione.getMessage();
    if (eccezione instanceof java.lang.NullPointerException)
      messaggio = Lingua.frase("OID_PPUNTATOPUTOPUN") + messaggio;
    else
      if (eccezione instanceof java.lang.SecurityException)
        messaggio = Lingua.frase("OID_SECURITY") + messaggio;
      else
        if (eccezione instanceof java.io.FileNotFoundException)
          messaggio = Lingua.frase("OID_FILENOTFOUND") + messaggio;
        else
          if (eccezione instanceof java.net.BindException)
            messaggio = Lingua.frase("OID_BINDING") + messaggio;
          else
            if (eccezione instanceof java.net.UnknownHostException)
              messaggio = Lingua.frase("OID_UNK_HOST") + messaggio;
            else
              if (eccezione instanceof javax.swing.UnsupportedLookAndFeelException)
                messaggio = Lingua.frase("OID_NO_LAF") + messaggio;
              else
                if (eccezione instanceof java.lang.ClassNotFoundException)
                  messaggio = Lingua.frase("OID_CLASS_NF") + messaggio;
                else
                  if (eccezione instanceof java.lang.ClassCastException)
                    messaggio = Lingua.frase("OID_CAST") + messaggio;
                  else
                    if (eccezione instanceof java.io.IOException)
                      messaggio = Lingua.frase("OID_IOERROR") + messaggio;
                    else {
                      messaggio = eccezione.getMessage();  // Prendo il solo messaggio
                      if (messaggio.equals(""))       // Se non c', considero l'intera frase!
                        messaggio = eccezione.toString();
                    }
    Debug.outln ("OiDialogoi:errore - "+messaggio);
    int risp = JOptionPane.showOptionDialog (mioFrame,
                                             messaggio,
                                             Lingua.frase("OID_TITLE_ERR"),
                                             JOptionPane.OK_OPTION,
                                             JOptionPane.ERROR_MESSAGE,
                                             IMG_ICO_ICONETTA,
                                             opzioni, null);
    if (risp != JOptionPane.YES_OPTION) {  // il bottone a destra
        SwingUtilities.invokeLater (new Runnable () {
            public void run () {

                JTextArea miaArea = new JTextArea (15,80);
                miaArea.setFont (new Font("DialogInput", Font.PLAIN, 11));

                TextAreaOutputStream2 myOut = new TextAreaOutputStream2 (miaArea);

                // STAMPA LO STACK (e l'eccezione avvenuta)!
                PrintWriter printer = new PrintWriter (myOut, true);  // true=autoFlush
                eccezione.printStackTrace (printer);

                FinConContainer finStack = new FinConContainer (miaArea, Lingua.frase("OID_WIN_STACK"));

            } //run
        }); //invokeLater
    }
  } //mostraErrore

      /**
       *  Mostro una finestra di dialogo per il messaggio passato (con scritta "messaggio").
       *  La finestra di dialogo non sar "modale" a nessuna finestra.
       */
  public static void mostraMessaggio (String messaggio) {
    mostraMessaggio (messaggio, null);
  } //mostraMessaggio

      /**
       *  Mostro una finestra di dialogo per il messaggio passato (con scritta "messaggio").
       *  La finestra di dialogo sar "modale" alla finestra (JFrame) passata.
       */
  public static void mostraMessaggio (final String messaggio, final JFrame mioFrame) {
    mostraMessaggio (messaggio, mioFrame, IMG_ICO_ICONETTA);
  } //mostraMessaggio

      /**
       *  Mostro una finestra di dialogo per il messaggio passato (con scritta "messaggio").
       *  La finestra di dialogo sar "modale" alla finestra (JFrame) passata.
       *  L'icona mostrata (a sinistra) sar quella passata.
       */
  public static void mostraMessaggio (final String messaggio, final JFrame mioFrame, final ImageIcon iconetta) {
    if (primaVolta) 
      CaricaMiaLingua();
    Object[] opzioni = {Lingua.frase("OID_BOT_OK")};
    Debug.outln ("OiDialogoi:messaggio - "+messaggio);
    JOptionPane.showOptionDialog (mioFrame,
                                  messaggio,
                                  Lingua.frase("OID_TITLE_MESS"),
                                  JOptionPane.OK_OPTION,
                                  JOptionPane.INFORMATION_MESSAGE,
                                  iconetta,
                                  opzioni, null);
  } //mostraMessaggio

      /**
       *  Mostro una finestra di dialogo con il testo passato.
       *  All'utente viene data la scelta tra un SI' o un NO.
       *  L'intero reso rappresenta la scelta fatta.
       *  La finestra di dialogo non sar "modale" a nessuna finestra.
       */
  public static int loFaccioSiNo (String domanda) {
    return loFaccioSiNo (domanda, null);
  } //loFaccioSiNo
  
      /**
       *  Mostro una finestra di dialogo con il testo passato.
       *  All'utente viene data la scelta tra un SI' o un NO.
       *  L'intero reso rappresenta la scelta fatta.
       *  La finestra di dialogo sar "modale" alla finestra (JFrame) passata.
       */
  public static int loFaccioSiNo (String domanda, JFrame mioFrame) {
    if (primaVolta) 
      CaricaMiaLingua();
    Object[] opzioniSiNo = {Lingua.frase("OID_BOT_SI"), Lingua.frase("OID_BOT_NO")};
    return loFaccioSiNo (domanda, mioFrame, opzioniSiNo);
  } //loFaccioSiNo

      /**
       *  Mostro una finestra di dialogo con il testo passato.
       *  All'utente viene data la scelta tra un SI' o un NO.
       *  I testi dei due bottoni sono passati attraverso l'array di oggetti "opzioni".
       *  L'intero reso rappresenta la scelta fatta.
       *  La finestra di dialogo sar "modale" alla finestra (JFrame) passata.
       */
  public static int loFaccioSiNo (String domanda, JFrame mioFrame, Object[] opzioniSiNo) {
    if (primaVolta) 
      CaricaMiaLingua();
    int risp = JOptionPane.showOptionDialog (mioFrame,
                                         domanda,
                                         Lingua.frase("OID_TITLE_MESS"),
                                         JOptionPane.YES_NO_OPTION,
                                         JOptionPane.QUESTION_MESSAGE,
                                         IMG_ICO_ICONETTA,
                                         opzioniSiNo, null);
    Debug.out ("OiDialogoi:richiestaSN - "+domanda+" (risposta="+risp+")");
    return risp;
  } //loFaccioSiNo

} //OiDialogoi