/**  Inizio
 *     E` la classe da cui si inizia a girellare tra le finestre dell'interfaccia
 *     grafica di SOMA. 
 *     Contiene l'interfaccia utente "iniziale" in cui fornisce la scelta se 
 *     creare sul computer un solo place (di default o normale) o se fare pi 
 *     place, a scopo dimostrativo.
 *     @author     Luigi Antenucci
 *     @version    1.0
 *     @language   jdk 1.2.2
 */

package SOMA.gui;

import SOMA.gui.lingua.Lingua;
import SOMA.Environment;
import SOMA.explorer.DirExplorerItem;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;


public class Inizio extends Finestra {

  // Variabili d'istanza:
      /**
       *  Oggetti che mostrano frasi, coi che dipendono dalla lingua.
       */ 
  protected JLabel     labSpiega1,  labSpiega2;
  protected JButton    botPlaceDef, botPlaceNor,
                       botPlaceMob,
                       botAdvanCfg,
                       botChiudi;

  protected PanTestoSC testata;

      /**
       *  Oggetto Anagrafe (reso non pi statico!) creato da questa classe.
       */
  protected Anagrafe anagrafe;


      /**
       *  Inizio del programma di interfaccia grafica per S.O.M.A.;
       *  costruisce e mostra la finestra di scelta.
       */ 
  public Inizio (DirExplorerItem rootDir) {
    super (10, 10);    // CHIAMO IL COSTRUTTORE DELLA SUPERCLASSE

    Creatore.defRootDir (rootDir);     // Rendo la "root" visibile a tutti!

    anagrafe = new Anagrafe ();        // Creazione dell'UNICO oggetto Anagrafe

    // Definizione delle PROPRIETA' GENERALI -----------------------------
    Config.defPropInt  ("Lingua",    Lingua.LINGUA_DEFAULT);
    Config.defProp     ("Apparenza", Apparenza.APPARENZA_DEFAULT);
    // Le seguenti sono modificabili tramite la finestra "FinOpzioni":
    Config.defPropInt  ("ChiediCaricaPlace",  FinOpzioni.OPZIONE_CHIEDI_UT);
    Config.defPropInt  ("ChiediApriPlace",    FinOpzioni.OPZIONE_CHIEDI_UT);
    Config.defPropBool ("ApriInfoSu",         true);
    Config.defPropBool ("ContinuaDopoUltima", false);
    Config.defPropBool ("UsaTestoSC",         false);
    Config.defPropBool ("SliderModiFont",     false);
    Config.defPropBool ("FinestraDiDebug",    false);
    // -------------------------------------------------------------------

    // INSTALLO (MA NON USO, PER ORA) IL MIO "Look and Feel"
    UIManager.installLookAndFeel ("Gigi", "SOMA.gui.gigi.GigiLookAndFeel");

    // Prova a caricare l'eventuale ridefinizione fatta dall'utente
    Config.caricaPropUtenteSeCiSono ();


    // DEFINIZIONE DELLA LINGUA DA USARE
    Lingua.defLingua (Config.chePropInt("Lingua"));

    // DEFINIZIONE DEL LOOK & FEEL DA USARE
    Apparenza.defApparenza (Config.cheProp ("Apparenza"));

    if (Config.chePropBool("FinestraDiDebug"))    // APRE EVENTUALE FINESTRA DI DEBUG
      Debug.apriFinestra ();

    // ORA COSTRUISCO LA FINESTRA
    costruisciFinestra();
  } //costruttore

      /**
       *  Vedi in superclasse {@link SOMA.gui.Finestra} il metodo {@link SOMA.gui.Finestra#costruisciFinestra()}
       */
  public void costruisciFinestra () {
    InizioCostruisciFinestra ();       // PARTE INIZIALE DI COSTRUZIONE DELLA FINESTRA

    // LISTENER PER LA CHIUSURA
    ListExit mioListExit = new ListExit(mioFrame, this, ListExit.EXIT_SOMA);
    mioFrame.addWindowListener (mioListExit);

    testata     = new PanTestoSC ();

    labSpiega1  = new JLabel ();
    labSpiega2  = new JLabel ();
    botPlaceDef = new JButton ();
    botPlaceNor = new JButton ();
    botPlaceMob = new JButton ();
    botAdvanCfg = new JButton ();
    botChiudi   = new JButton ();

    botPlaceDef.setCursor (cursoreBottone);
    botPlaceNor.setCursor (cursoreBottone);
    botPlaceMob.setCursor (cursoreBottone);
    botAdvanCfg.setCursor (cursoreBottone);
    botChiudi  .setCursor (cursoreBottone);

    impostaFrasi ();         // IMPOSTA LE FRASI (DIPENDENTI DALLA LINGUA)

    botPlaceDef.setIcon (new ImageIcon(PICTURE_PATH+"Persona.gif"));
    botPlaceNor.setIcon (new ImageIcon(PICTURE_PATH+"Personaggio.gif"));
    botPlaceMob.setIcon (new ImageIcon(PICTURE_PATH+"PersMobile.gif"));
    botAdvanCfg.setIcon (new ImageIcon(PICTURE_PATH+"Persone.gif"));
    botChiudi  .setIcon (new ImageIcon(PICTURE_PATH+"ExitIco.gif"));
    botChiudi.setPressedIcon(new ImageIcon(PICTURE_PATH+"Zampina.gif"));

    botPlaceDef.setHorizontalAlignment(JLabel.LEFT);
    botPlaceNor.setHorizontalAlignment(JLabel.LEFT);
    botPlaceMob.setHorizontalAlignment(JLabel.LEFT);
    botAdvanCfg.setHorizontalAlignment(JLabel.LEFT);

    botChiudi  .setVerticalTextPosition   (JButton.BOTTOM);
    botChiudi  .setHorizontalTextPosition (JButton.CENTER);

    ListBottoni bottoniera = new ListBottoni(this);
    botPlaceDef.addActionListener (bottoniera);
    botPlaceDef.setActionCommand("DefaultPlace");
    botPlaceNor.addActionListener (bottoniera);
    botPlaceNor.setActionCommand("NormalPlace");
    botPlaceMob.addActionListener (bottoniera);
    botPlaceMob.setActionCommand("MobilePlace");
    botAdvanCfg.addActionListener (bottoniera);
    botAdvanCfg.setActionCommand("AdvConfig");

    botChiudi.addActionListener (mioListExit);

    GridBagLayout GBL = new GridBagLayout();
    GridBagConstraints CC = new GridBagConstraints();
    PanCentro.setLayout (GBL);

    // AGGIUNGO SPAZIO VUOTO ATTORNO AL PANNELLO
    PanCentro.setBorder (BorderFactory.createEmptyBorder(10, 45, 0, 0));   // alto,sx,basso,dx

    Component spazio;

    CC.gridx = 1;   CC.gridy = 1;
    CC.anchor = GridBagConstraints.CENTER;
    GBL.setConstraints (testata, CC);
    PanCentro.add (testata);

    spazio = Box.createRigidArea (new Dimension(5,15));   // Aggiunge spazio vuoto
    CC.gridx = 1;   CC.gridy = 2;
    GBL.setConstraints (spazio, CC);
    PanCentro.add (spazio);

    CC.gridx = 1;   CC.gridy = 3;
    CC.anchor = GridBagConstraints.WEST;
    GBL.setConstraints (labSpiega1, CC);
    PanCentro.add (labSpiega1);

    // FORZO "STESSA DIMENSIONE" dei 2 bottoni, creando un PANNELLO CON GRID-LAYOUT
    JPanel panPiu = new JPanel(new GridLayout(3,1));  // 3 righe e 1 colonna
      panPiu.add (botPlaceDef);
      panPiu.add (botPlaceNor);
      panPiu.add (botPlaceMob);
    CC.gridx = 1;   CC.gridy = 4;
    CC.anchor = GridBagConstraints.EAST;
    GBL.setConstraints (panPiu, CC);
    PanCentro.add (panPiu);

    spazio = Box.createRigidArea (new Dimension(5,15));   // Aggiunge spazio vuoto
    CC.gridx = 1;   CC.gridy = 5;
    CC.anchor = GridBagConstraints.CENTER;
    GBL.setConstraints (spazio, CC);
    PanCentro.add (spazio);

    CC.gridx = 1;   CC.gridy = 6;
    CC.anchor = GridBagConstraints.WEST;
    GBL.setConstraints (labSpiega2, CC);
    PanCentro.add (labSpiega2);

    CC.gridx = 1;   CC.gridy = 7;
    CC.anchor = GridBagConstraints.EAST;
    GBL.setConstraints (botAdvanCfg, CC);
    PanCentro.add (botAdvanCfg);

    spazio = Box.createRigidArea (new Dimension(5,20));   // Aggiunge spazio vuoto
    CC.gridx = 1;   CC.gridy = 8;
    CC.anchor = GridBagConstraints.CENTER;
    GBL.setConstraints (spazio, CC);
    PanCentro.add (spazio);

    CC.gridx = 2;   CC.gridy = 9;
    CC.anchor = GridBagConstraints.EAST;
    GBL.setConstraints (botChiudi, CC);
    PanCentro.add (botChiudi);

    FineCostruisciFinestra ();       // PARTE FINALE DI COSTRUZIONE DELLA FINESTRA

    if (Config.chePropBool("ApriInfoSu")) {   // Apre automaticamente la finestrella "info su"
      FinAbout abbbaut = new FinAbout (mioFrame);
    }

    if (Creatore.esisteConfigSalvata()) {

      int load;
      int cheFo = Config.chePropInt ("ChiediCaricaPlace");    // Vedi classe "FinOpzioni"
      if (cheFo == FinOpzioni.OPZIONE_CHIEDI_UT) {
        Object[] opzioniLoad = {Lingua.frase("I_LOAD_YES"), Lingua.frase("I_LOAD_NO")};
        load = OiDialogoi.loFaccioSiNo (Lingua.frase("I_LOAD_MESSAGE"), mioFrame, opzioniLoad);
      }
      else
        if (cheFo == FinOpzioni.OPZIONE_SEMPRE_SI) 
          load = JOptionPane.YES_OPTION;
        else
          load = JOptionPane.NO_OPTION;

      if (load == JOptionPane.YES_OPTION) {
        // Si disabilita (in caso che la creazione necessitasse di un certo tempo)
        disabilitaFinestra();

        // Carica config salvata e crea i place
        Environment[] envArr = Creatore.caricaConfigSalvata (anagrafe);

        if (envArr.length == 0) {  // Ho creato almeno un place? Se no NON distruggo la finestra "Inizio"
          OiDialogoi.mostraErrore(new Exception(Lingua.frase("I_ERR_NOPLACES")), mioFrame);
        }
        else { // Ho creato almeno un place

          int apro;                  // Apro le finestre?
          if (envArr.length == 1)    // un solo place: USO MODALITA' SINGOLO PLACE
            apro = JOptionPane.YES_OPTION;
          else {                     // Faccio scegliere a utente
            int cheFo2 = Config.chePropInt ("ChiediApriPlace");    // Vedi classe "FinOpzioni"
            if (cheFo2 == FinOpzioni.OPZIONE_CHIEDI_UT) {
              Object[] opzioniApro = {Lingua.frase("I_OPEN_YES"), Lingua.frase("I_OPEN_NO")};
              apro = OiDialogoi.loFaccioSiNo (Lingua.frase("I_OPENWIN_MESSAGE"), mioFrame, opzioniApro);
            }
            else
              if (cheFo2 == FinOpzioni.OPZIONE_SEMPRE_SI)
                apro = JOptionPane.YES_OPTION;
              else
                apro = JOptionPane.NO_OPTION;
          } //else
          if (apro == JOptionPane.YES_OPTION) {         // APRO LE FINESTRE DEI PLACE!
            for (int i=0; i<envArr.length; i++) {
              try {
                envArr[i].actionPlace.start();          // Apre la finestra (invoca l'ActionPlace di Env)
              }
              catch (Exception ecc) { OiDialogoi.mostraErrore(ecc, mioFrame); }
            } //for
          } //if "apro"

          // In ogni caso (sia che apro le finestre "place" o no:
          if (envArr.length > 1) { // Se ho creato pi di UN place,
            AdvConfig nuovaFin = new AdvConfig (anagrafe);  // Apre "advanced config"
          }
          else
            AdvConfig.defAnagrafeFutura (anagrafe);
           
          distruggiFinestra();                      // Si auto-distrugge la finestra

        } //else "creato almeno un place"
      } //if "carica s"
    } //if "esiste config salvata"
  } //costruisciFinestra

      /**
       *  Disabilita la finestra. Vedi in superclasse {@link SOMA.gui.Finestra}.
       */
  public void disabilitaFinestra () {
    super.disabilitaFinestra();
    labSpiega1 .setEnabled (false);
    labSpiega2 .setEnabled (false);
    botPlaceDef.setEnabled (false);
    botPlaceNor.setEnabled (false);
    botPlaceMob.setEnabled (false);
    botAdvanCfg.setEnabled (false);
    botChiudi  .setEnabled (false);
  } //disabilitaFinestra

      /**
       *  Abilita la finestra (precedentemente disabilitata). Vedi in superclasse {@link SOMA.gui.Finestra}.
       */
  public void abilitaFinestra () {
    super.abilitaFinestra();
    labSpiega1 .setEnabled (true);
    labSpiega2 .setEnabled (true);
    botPlaceDef.setEnabled (true);
    botPlaceNor.setEnabled (true);
    botPlaceMob.setEnabled (true);
    botAdvanCfg.setEnabled (true);
    botChiudi  .setEnabled (true);
  } //abilitaFinestra

      /**
       *  Vedi in superclasse {@link SOMA.gui.Finestra} il metodo {@link SOMA.gui.Finestra#creaBarraMenu()}
       */
  protected void creaBarraMenu () {
    creaBarraMenuDefault (Finestra.MENU_EXIT);
  } //creaBarraMenu

      /**
       *  Vedi in superclasse {@link SOMA.gui.Finestra} il metodo {@link SOMA.gui.Finestra#impostaFrasi()}
       */
  protected void impostaFrasi () {
    mioFrame.setTitle (Lingua.frase("I_SOMA_CONFIG"));

    testata.setText (Lingua.frase("I_TESTATA"));

    labSpiega1.setText (Lingua.frase("I_LAB_SPIEGA1"));
    labSpiega2.setText (Lingua.frase("I_LAB_SPIEGA2"));

    botPlaceDef.setText (Lingua.frase("I_BOT_PLACE_DEF"));
    botPlaceNor.setText (Lingua.frase("I_BOT_PLACE_NOR"));
    botPlaceMob.setText (Lingua.frase("I_BOT_PLACE_MOB"));
    botAdvanCfg.setText (Lingua.frase("I_BOT_ADV_CFG"));
    botChiudi  .setText (Lingua.frase("I_BOT_CHIUDI"));

    botPlaceDef.setToolTipText (Lingua.frase("I_TIP_PLACE_DEF"));
    botPlaceNor.setToolTipText (Lingua.frase("I_TIP_PLACE_NOR"));
    botPlaceMob.setToolTipText (Lingua.frase("I_TIP_PLACE_MOB"));
    botAdvanCfg.setToolTipText (Lingua.frase("I_TIP_ADV_CFG"));
    botChiudi  .setToolTipText (Lingua.frase("I_TIP_CHIUDI"));

    FineImpostaFrasi();      // APPORTA ALLA FINESTRA LE MODIFICHE FATTE
  } //impostaFrasi


      /**
       *  CLASSE INTERNA PER ASCOLTARE LA PRESSIONE DEI BOTTONI DELLA FINESTRA.
       */
  class ListBottoni implements ActionListener {
    protected Inizio mioInizio;

    public ListBottoni (Inizio mioInizio) {
      this.mioInizio = mioInizio;
    } //costruttore

    public void actionPerformed (ActionEvent e) {
      String azione = e.getActionCommand();
      if (azione.equals("DefaultPlace")) {   // BUG DEL JDK? Qui  NECESSARIO il begin-end
        DefPlaceDef nuovaFin = new DefPlaceDef (mioInizio, false, anagrafe);  // no config. avanzata
      }
      else
        if (azione.equals("NormalPlace")) {
          DefPlace nuovaFin = new DefPlace (mioInizio, false, anagrafe);
        }
        else
          if (azione.equals("MobilePlace")) {
            DefPlaceMob nuovaFin = new DefPlaceMob (mioInizio, false, anagrafe);
          }
          else 
            if (azione.equals("AdvConfig")) {
              Creatore.cancellaConfigPlace();        // Prima cancello la config.place presente su disco
              AdvConfig nuovaFin = new AdvConfig (anagrafe);
              mioInizio.distruggiFinestra ();
            }
            else  // ultimo caso: "Chiudi"
              mioInizio.distruggiFinestra ();
    } //actionPerformed
  } //ListBottoni

} //Inizio