/**  FinProfileLogin
 *     Una finestrella tramite cui inserire i dati di "ProfileLogin"
 *     @author     Luigi Antenucci  (modificato da Angelo, per gestire gli errori del login)
 *     @version    1.3
 *     @language   jdk 1.2.2
 */

package SOMA.gui;

import SOMA.gui.lingua.Lingua;
import SOMA.security.infrastructure.ProfileManager;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.border.*;


public class FinProfileLogin extends Finestra {

      /**
       *  COSTANTI PRIVATE per le azioni di comando fatte dai bottoni
       */
  protected static final  String AZIONE_LOGIN     = "Logggin";
  protected static final  String AZIONE_CANCEL    = "Annulla";


  // Variabili d'istanza:
      /**
       *  Riferimenti dati tramite il costruttore.
       */
  protected FinestraPlace  finestraPlace;
  protected ProfileManager profile;
  protected boolean login = true;   // aggiunto da Angelo

      /**
       *  Oggetti che mostrano frasi, coi che dipendono dalla lingua.
       */
  protected JLabel       labSpiega1, labSpiega2,
                         labProf, labPass;
  protected JTextField   txtProf;
  protected JPasswordField txtPass;
  protected JButton      botLogin,
                         botKO;

      /**
       *  Costruisce e mostra la finestra di inserimento dati.
       */
  public FinProfileLogin (FinestraPlace finestraPlace, ProfileManager profile) {
    super (80, 60);    // CHIAMO IL COSTRUTTORE DELLA SUPERCLASSE

    this.finestraPlace = finestraPlace;
    this.profile       = profile;

    Config.defPropVariabile ("UltimoProfilo", "");  // "Variabile" perch  definita anche da "LancioAgente"

    if (finestraPlace != null)
      finestraPlace.disabilitaFinestra();

    costruisciFinestra();
  } //costruttore

      /**
       *  Vedi in superclasse {@link SOMA.gui.Finestra} il metodo {@link SOMA.gui.Finestra#costruisciFinestra()}
       */
  public void costruisciFinestra () {
    InizioCostruisciFinestra ();       // PARTE INIZIALE DI COSTRUZIONE DELLA FINESTRA

    labSpiega1    = new JLabel ();
    labSpiega2    = new JLabel ();

    labProf       = new JLabel ();
    labPass       = new JLabel ();

    txtProf       = new JTextField (30);
    txtProf.setText (Config.cheProp("UltimoProfilo"));
    txtPass       = new JPasswordField (10);

    botLogin = new JButton ();
    botKO    = new JButton ();

    impostaFrasi ();         // IMPOSTA LE FRASI (DIPENDENTI DALLA LINGUA)

    ListBottoni bottoniera = new ListBottoni();

    botLogin.setCursor (cursoreBottone);
    botKO   .setCursor (cursoreBottone);

    botLogin     .setCursor (cursoreBottone);
    botLogin     .setIcon (new ImageIcon(PICTURE_PATH+"ProfLogin.gif"));
    botLogin     .addActionListener (bottoniera);
    botLogin     .setActionCommand(AZIONE_LOGIN);
    botKO        .setCursor (cursoreBottone);
    botKO        .setIcon (new ImageIcon(PICTURE_PATH+"BotKO.gif"));
    botKO        .addActionListener (bottoniera);
    botKO        .setActionCommand(AZIONE_CANCEL);
    botKO        .setPressedIcon(new ImageIcon(PICTURE_PATH+"Zampina.gif"));

    txtProf.setActionCommand(AZIONE_LOGIN);
    txtProf.addActionListener (bottoniera);    // PRESSIONE "INVIO" SU TextField
    txtPass.setActionCommand(AZIONE_LOGIN);
    txtPass.addActionListener (bottoniera);

    mioFrame.addWindowListener (bottoniera);

    GridBagLayout GBL = new GridBagLayout();
    GridBagConstraints CC = new GridBagConstraints();
    PanCentro.setLayout (GBL);

    // AGGIUNGO SPAZIO VUOTO ATTORNO AL PANNELLO
    PanCentro.setBorder (BorderFactory.createEmptyBorder(10, 15, 8, 15));   // alto,sx,basso,dx

    Component spazio;

    CC.anchor = GridBagConstraints.CENTER;

    CC.gridx = 1;   CC.gridy = 1;
    GBL.setConstraints (labSpiega1, CC);
    PanCentro.add (labSpiega1);

    CC.gridx = 1;   CC.gridy = 2;
    GBL.setConstraints (labSpiega2, CC);
    PanCentro.add (labSpiega2);

    spazio = Box.createRigidArea (new Dimension(5,15));
    CC.gridx = 1;   CC.gridy = 3;
    CC.anchor = GridBagConstraints.WEST;
    GBL.setConstraints (spazio, CC);
    PanCentro.add (spazio);

    JPanel panLog = new JPanel ();                       // PLACE ID
      GridBagLayout GBL2     = new GridBagLayout();
      GridBagConstraints CC2 = new GridBagConstraints();
      panLog.setLayout (GBL2);

      CC2.anchor = GridBagConstraints.EAST;
      CC2.gridx = 1;   CC2.gridy = 1;
      GBL2.setConstraints (labProf, CC2);
      panLog.add (labProf);
      CC2.gridx = 1;   CC2.gridy = 3;
      GBL2.setConstraints (labPass, CC2);
      panLog.add (labPass);

      CC2.anchor = GridBagConstraints.WEST;
      CC2.gridx = 2;   CC2.gridy = 1;
      GBL2.setConstraints (txtProf, CC2);
      panLog.add (txtProf);
      CC2.gridx = 2;   CC2.gridy = 3;
      GBL2.setConstraints (txtPass, CC2);
      panLog.add (txtPass);

      spazio = Box.createRigidArea (new Dimension(2,6));
      CC2.gridx = 2;   CC2.gridy = 2;
      GBL2.setConstraints (spazio, CC2);
      panLog.add (spazio);
      spazio = Box.createRigidArea (new Dimension(2,20));
      CC2.gridx = 2;   CC2.gridy = 4;
      GBL2.setConstraints (spazio, CC2);
      panLog.add (spazio);

    CC.anchor = GridBagConstraints.WEST;
    CC.gridx = 1;   CC.gridy = 8;
    GBL.setConstraints (panLog, CC);
    PanCentro.add (panLog);

    CC.fill   = GridBagConstraints.VERTICAL;
    CC.anchor = GridBagConstraints.WEST;
    CC.gridx = 1;   CC.gridy = 10;
    GBL.setConstraints (botLogin, CC);
    PanCentro.add (botLogin);

    CC.anchor = GridBagConstraints.EAST;
    CC.gridx = 1;   CC.gridy = 10;
    GBL.setConstraints (botKO, CC);
    PanCentro.add (botKO);

    FineCostruisciFinestra ();       // PARTE FINALE DI COSTRUZIONE DELLA FINESTRA
  } //costruisciFinestra

      /**
       *  Vedi in superclasse {@link SOMA.gui.Finestra} il metodo {@link SOMA.gui.Finestra#creaBarraMenu()}
       */
  protected void creaBarraMenu () {
    creaBarraMenuDefault (Finestra.MENU_CLOSE);
  } //creaBarraMenu

      /**
       *  Vedi in superclasse {@link SOMA.gui.Finestra} il metodo {@link SOMA.gui.Finestra#distruggiFinestra()}
       */
  public void distruggiFinestra () {

    super.distruggiFinestra();

    if (finestraPlace != null) {
      finestraPlace.abilitaFinestra();
      finestraPlace.inPrimoPiano();
    }
  } //distruggiFinestra

      /**
       *  Vedi in superclasse {@link SOMA.gui.Finestra} il metodo {@link SOMA.gui.Finestra#impostaFrasi()}
       */
  protected void impostaFrasi () {
    mioFrame.setTitle (Lingua.frase("FPROLO_WINTITLE"));

    labSpiega1.setText (Lingua.frase("FPROLO_SPIEGAZ1"));
    labSpiega2.setText (Lingua.frase("FPROLO_SPIEGAZ2"));

    labProf .setText (Lingua.frase("FPROLO_PROFILE"));
    labPass .setText (Lingua.frase("FPROLO_PASSW1"));

    botLogin.setText (Lingua.frase("FPROLO_BOT_LOGIN"));
    botKO   .setText (Lingua.frase("FPROLO_BOT_CANC"));

    FineImpostaFrasi();      // APPORTA ALLA FINESTRA LE MODIFICHE FATTE
  } //impostaFrasi


      /**
       *  CLASSE INTERNA PER ASCOLTARE LA PRESSIONE DEI BOTTONI DELLA FINESTRA.
       */
  class ListBottoni extends WindowAdapter implements ActionListener {

    public void actionPerformed (ActionEvent e) {
      String azione = e.getActionCommand();
      try {

        if (azione.equals(AZIONE_LOGIN)) {
          // PRELEVA PARAMETRI
          try {
            String fileProf = txtProf.getText();
            Config.modifProp ("UltimoProfilo", fileProf);

            char charPass[] = txtPass.getPassword();
            String strPass = new String(charPass);

            //DEBUG: if (finestraPlace != null)
            //DEBUG: finestraPlace.abilitaVociSicurezza(FinestraPlace.VOCE_RESTANTI);

                    profile.logonProfile (fileProf,    // filename
                                          strPass);    // password

            // Attiva le "altre" voci del men,
            // disabilitando la possibilit del Login (si dovr fare il logoff)

            if  (finestraPlace != null)
              if  (! profile.errlogin )     // aggiunto da Angelo per gestire gli errori
                 finestraPlace.abilitaVociSicurezza(FinestraPlace.VOCE_RESTANTI);

            distruggiFinestra();    // Altrimenti, distruggo questa finestra!
          }
          catch (Exception ec2) {
           throw ec2;
          }
        }
        else // ANNULLA
          distruggiFinestra();    // Altrimenti, distruggo questa finestra!

      }
      catch (Exception eccezione) {
        OiDialogoi.mostraErrore (eccezione, mioFrame);    // STAMPA L'ECCEZIONE GENERATA!
      }
    } //actionPerformed

    public void windowClosing (WindowEvent e)   {
      distruggiFinestra();   // distruggo questa finestra (torno a Inizio)
    } //windowClosing
  } //ListBottoni

/*
  public static void main (String[] args) {
    // PER DEBUGGING
    UIManager.installLookAndFeel ("Gigi", "SOMA.gui.gigi.GigiLookAndFeel");
    ProfileManager profile = new ProfileManager();
    FinProfileLogin fin = new FinProfileLogin(null, profile);
  } //main
*/

} //FinProfileLogin