/**  FinProfileCreRec
 *     Una finestrella tramite cui inserire i dati di "ProfileCreate/Recover"
 *     @author     Luigi Antenucci
 *     @version    1.5
 *     @language   jdk 1.2.2
 */

package SOMA.gui;

import SOMA.gui.lingua.Lingua;
import SOMA.security.infrastructure.ProfileManager;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;


public class FinProfileCreRec extends Finestra {

      /**
       *  COSTANTI PRIVATE per le azioni di comando fatte dai bottoni
       */
  protected static final  String AZIONE_CREATE    = "Create";
  protected static final  String AZIONE_RECOVER   = "Recover";
  protected static final  String AZIONE_CANCEL    = "Annulla";


  // Variabili d'istanza:
      /**
       *  Riferimenti dati tramite il costruttore.
       */ 
  protected FinestraPlace  finestraPlace;
  protected ProfileManager profile;

      /**
       *  Oggetti che mostrano frasi, coi che dipendono dalla lingua.
       */ 
  protected JLabel       labSpiega,
                         labRef, labAuth, labPass2, labNome;
  protected JTextField   txtRef, txtAuth,           txtNome;
  protected JPasswordField                txtPass2;
  protected JButton      botCreat, botRecov,
                         botKO;

      /**
       *  Costruisce e mostra la finestra di inserimento dati.
       */ 
  public FinProfileCreRec (FinestraPlace finestraPlace, ProfileManager profile) {
    super (80, 60);    // CHIAMO IL COSTRUTTORE DELLA SUPERCLASSE

    this.finestraPlace = finestraPlace;
    this.profile       = profile;
    if (finestraPlace != null)
      finestraPlace.disabilitaFinestra();

    costruisciFinestra();
  } //costruttore

      /**
       *  Vedi in superclasse {@link SOMA.gui.Finestra} il metodo {@link SOMA.gui.Finestra#costruisciFinestra()}
       */
  public void costruisciFinestra () {
    InizioCostruisciFinestra ();       // PARTE INIZIALE DI COSTRUZIONE DELLA FINESTRA

    labSpiega     = new JLabel ();

    labRef        = new JLabel ();
    labAuth       = new JLabel ();
    labPass2      = new JLabel ();
    labNome       = new JLabel ();

    txtRef        = new JTextField (30);
    txtAuth       = new JTextField (20);
    txtNome       = new JTextField (30);

    txtPass2      = new JPasswordField (10);

    botCreat = new JButton ();
    botRecov = new JButton ();
    botKO    = new JButton ();

    impostaFrasi ();         // IMPOSTA LE FRASI (DIPENDENTI DALLA LINGUA)

    ListBottoni bottoniera = new ListBottoni();

    botCreat.setCursor (cursoreBottone);
    botRecov.setCursor (cursoreBottone);
    botKO   .setCursor (cursoreBottone);

    botCreat     .setCursor (cursoreBottone);
    botCreat     .setIcon (new ImageIcon(PICTURE_PATH+"ProfCre.gif"));
    botCreat     .addActionListener (bottoniera);
    botCreat     .setActionCommand(AZIONE_CREATE);
    botRecov     .setCursor (cursoreBottone);
    botRecov     .setIcon (new ImageIcon(PICTURE_PATH+"ProfRec.gif"));
    botRecov     .addActionListener (bottoniera);
    botRecov     .setActionCommand(AZIONE_RECOVER);
    botKO        .setCursor (cursoreBottone);
    botKO        .setIcon (new ImageIcon(PICTURE_PATH+"BotKO.gif"));
    botKO        .addActionListener (bottoniera);
    botKO        .setActionCommand(AZIONE_CANCEL);
    botKO        .setPressedIcon(new ImageIcon(PICTURE_PATH+"Zampina.gif"));

    mioFrame.addWindowListener (bottoniera);

    GridBagLayout GBL = new GridBagLayout();
    GridBagConstraints CC = new GridBagConstraints();
    PanCentro.setLayout (GBL);

    // AGGIUNGO SPAZIO VUOTO ATTORNO AL PANNELLO
    PanCentro.setBorder (BorderFactory.createEmptyBorder(10, 15, 8, 15));   // alto,sx,basso,dx

    Component spazio;

    CC.gridx = 1;   CC.gridy = 2;
    CC.anchor = GridBagConstraints.CENTER;
    GBL.setConstraints (labSpiega, CC);
    PanCentro.add (labSpiega);

    spazio = Box.createRigidArea (new Dimension(5,15));
    CC.gridx = 1;   CC.gridy = 3;
    GBL.setConstraints (spazio, CC);
    PanCentro.add (spazio);

    JPanel panCR = new JPanel ();                       // PLACE ID
      GridBagLayout GBL3     = new GridBagLayout();
      GridBagConstraints CC3 = new GridBagConstraints();
      panCR.setLayout (GBL3);

      CC3.anchor = GridBagConstraints.EAST;
      CC3.gridx = 1;   CC3.gridy = 1;
      GBL3.setConstraints (labRef, CC3);
      panCR.add (labRef);
      CC3.gridx = 1;   CC3.gridy = 3;
      GBL3.setConstraints (labAuth, CC3);
      panCR.add (labAuth);
      CC3.gridx = 1;   CC3.gridy = 5;
      GBL3.setConstraints (labPass2, CC3);
      panCR.add (labPass2);
      CC3.gridx = 1;   CC3.gridy = 7;
      GBL3.setConstraints (labNome, CC3);
      panCR.add (labNome);

      CC3.anchor = GridBagConstraints.WEST;
      CC3.gridx = 2;   CC3.gridy = 1;
      GBL3.setConstraints (txtRef, CC3);
      panCR.add (txtRef);
      CC3.gridx = 2;   CC3.gridy = 3;
      GBL3.setConstraints (txtAuth, CC3);
      panCR.add (txtAuth);
      CC3.gridx = 2;   CC3.gridy = 5;
      GBL3.setConstraints (txtPass2, CC3);
      panCR.add (txtPass2);
      CC3.gridx = 2;   CC3.gridy = 7;
      GBL3.setConstraints (txtNome, CC3);
      panCR.add (txtNome);

      spazio = Box.createRigidArea (new Dimension(2,6));
      CC3.gridx = 2;   CC3.gridy = 2;
      GBL3.setConstraints (spazio, CC3);
      panCR.add (spazio);
      spazio = Box.createRigidArea (new Dimension(2,6));
      CC3.gridx = 2;   CC3.gridy = 4;
      GBL3.setConstraints (spazio, CC3);
      panCR.add (spazio);
      spazio = Box.createRigidArea (new Dimension(2,6));
      CC3.gridx = 2;   CC3.gridy = 6;
      GBL3.setConstraints (spazio, CC3);
      panCR.add (spazio);
      spazio = Box.createRigidArea (new Dimension(2,10));
      CC3.gridx = 2;   CC3.gridy = 8;
      GBL3.setConstraints (spazio, CC3);
      panCR.add (spazio);

    CC.anchor = GridBagConstraints.WEST;
    CC.gridx = 1;   CC.gridy = 12;
    GBL.setConstraints (panCR, CC);
    PanCentro.add (panCR);

    CC.fill = GridBagConstraints.VERTICAL;

    JPanel panBot = new JPanel ();                   // PLACE ID
      panBot.setLayout (new FlowLayout());

      panBot.add (botCreat);
      panBot.add (botRecov);

    CC.anchor = GridBagConstraints.WEST;
    CC.gridx = 1;   CC.gridy = 16;
    GBL.setConstraints (panBot, CC);
    PanCentro.add (panBot);

    CC.anchor = GridBagConstraints.EAST;
    CC.gridx = 1;   CC.gridy = 16;
    GBL.setConstraints (botKO, CC);
    PanCentro.add (botKO);

    FineCostruisciFinestra ();       // PARTE FINALE DI COSTRUZIONE DELLA FINESTRA
  } //costruisciFinestra

      /**
       *  Vedi in superclasse {@link SOMA.gui.Finestra} il metodo {@link SOMA.gui.Finestra#creaBarraMenu()}
       */
  protected void creaBarraMenu () {
    creaBarraMenuDefault (Finestra.MENU_CLOSE);
  } //creaBarraMenu

      /**
       *  Vedi in superclasse {@link SOMA.gui.Finestra} il metodo {@link SOMA.gui.Finestra#distruggiFinestra()}
       */
  public void distruggiFinestra () {

    super.distruggiFinestra();

    if (finestraPlace != null) {
      finestraPlace.abilitaFinestra();
      finestraPlace.inPrimoPiano();
    }
  } //distruggiFinestra

      /**
       *  Vedi in superclasse {@link SOMA.gui.Finestra} il metodo {@link SOMA.gui.Finestra#impostaFrasi()}
       */
  protected void impostaFrasi () {
    mioFrame.setTitle (Lingua.frase("FPROCRREC_WINTITLE"));

    labSpiega.setText (Lingua.frase("FPROCRREC_SPIEGAZ"));

    labRef  .setText (Lingua.frase("FPROCRREC_REFNUM"));
    labAuth .setText (Lingua.frase("FPROCRREC_AUTHCODE"));
    labPass2.setText (Lingua.frase("FPROCRREC_PASSW2"));
    labNome .setText (Lingua.frase("FPROCRREC_FILENAME"));

    botCreat.setText (Lingua.frase("FPROCRREC_BOT_CREATE"));
    botRecov.setText (Lingua.frase("FPROCRREC_BOT_RECOVER"));
    botKO   .setText (Lingua.frase("FPROCRREC_BOT_CANC"));

    FineImpostaFrasi();      // APPORTA ALLA FINESTRA LE MODIFICHE FATTE
  } //impostaFrasi


      /**
       *  CLASSE INTERNA PER ASCOLTARE LA PRESSIONE DEI BOTTONI DELLA FINESTRA.
       */
  class ListBottoni extends WindowAdapter implements ActionListener {

    public void actionPerformed (ActionEvent e) {
      String azione = e.getActionCommand();
      try {

        if (azione.equals(AZIONE_CREATE)  ||
            azione.equals(AZIONE_RECOVER)   ) {
              // PRELEVA PARAMETRI
              String refNum   = txtRef.getText();
              String authCode = txtAuth.getText();
              String fileName = txtNome.getText();

              char[] passw2Chr = txtPass2.getPassword();
              String passw2    = new String(passw2Chr);

              if (azione.equals(AZIONE_CREATE))
                profile.createProfile(refNum,
                                      authCode,  //authcode
                                      passw2,    //password
                                      fileName); //filename
              else                                      
                profile.recoverProfile(refNum,
                                       authCode,  //authcode
                                       passw2,    //password
                                       fileName); //filename
      }
      else // ANNULLA
        distruggiFinestra();    // Altrimenti, distruggo questa finestra!

      }
      catch (Exception eccezione) {
        OiDialogoi.mostraErrore (eccezione, mioFrame);    // STAMPA L'ECCEZIONE GENERATA!
      }
    } //actionPerformed

    public void windowClosing (WindowEvent e)   { 
      distruggiFinestra();   // distruggo questa finestra (torno a Inizio)
    } //windowClosing
  } //ListBottoni

/*
  public static void main (String[] args) {
    // PER DEBUGGING
    UIManager.installLookAndFeel ("Gigi", "SOMA.gui.gigi.GigiLookAndFeel");
    ProfileManager profile = new ProfileManager();
    FinProfileCreRec fin = new FinProfileCreRec(null, profile);
  } //main
*/

} //FinProfileCreRec